/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.NetAddress;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.Serializable;

@NotThreadSafe
public final class Address
implements Serializable {
    private static final long serialVersionUID = 1645922245406539186L;
    private String mHost = "";
    private int mRpcPort;

    public Address() {
    }

    public Address(String hostname, int rpcPort) {
        this.mHost = hostname;
        this.mRpcPort = rpcPort;
    }

    protected Address(NetAddress netAddress) {
        this.mHost = netAddress.getHost();
        this.mRpcPort = netAddress.getRpcPort();
    }

    public String getHost() {
        return this.mHost;
    }

    public int getRpcPort() {
        return this.mRpcPort;
    }

    public Address setHost(String host) {
        this.mHost = Preconditions.checkNotNull(host, "host");
        return this;
    }

    public Address setRpcPort(int rpcPort) {
        this.mRpcPort = rpcPort;
        return this;
    }

    public NetAddress toProto() {
        return NetAddress.newBuilder().setHost(this.mHost).setRpcPort(this.mRpcPort).build();
    }

    public static Address fromProto(NetAddress address) {
        return new Address(address);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address that = (Address)o;
        return this.mHost.equals(that.mHost) && this.mRpcPort == that.mRpcPort;
    }

    public int hashCode() {
        return Objects.hashCode(this.mHost, this.mRpcPort);
    }

    public String toString() {
        return this.mHost + ":" + this.mRpcPort;
    }
}

