/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import java.util.Optional;
import javax.validation.constraints.Size;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class SizeAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<Size> size = this.extractAnnotation(context);
        size.ifPresent(size1 -> {
            AllowableRangeValues allowableRangeValues = RangeAnnotations.stringLengthRange(size1);
            context.getBuilder().allowableValues((AllowableValues)allowableRangeValues);
            context.getSpecificationBuilder().stringFacet(s -> {
                s.minLength((Integer)this.tryGetInteger(allowableRangeValues.getMin()).orElse(null));
                s.maxLength((Integer)this.tryGetInteger(allowableRangeValues.getMax()).orElse(null));
            });
        });
    }

    private Optional<Integer> tryGetInteger(String min) {
        try {
            return Optional.of(Integer.valueOf(min));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    Optional<Size> extractAnnotation(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, Size.class).map(Optional::of).orElse(Validators.annotationFromField(context, Size.class));
    }
}

