/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.sentinel;

import io.lettuce.core.KillArgs;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.protocol.AsyncCommand;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.ProtocolKeyword;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.sentinel.SentinelCommandBuilder;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import io.lettuce.core.sentinel.api.async.RedisSentinelAsyncCommands;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public class RedisSentinelAsyncCommandsImpl<K, V>
implements RedisSentinelAsyncCommands<K, V> {
    private final SentinelCommandBuilder<K, V> commandBuilder;
    private final StatefulConnection<K, V> connection;

    public RedisSentinelAsyncCommandsImpl(StatefulConnection<K, V> connection, RedisCodec<K, V> codec) {
        this.connection = connection;
        this.commandBuilder = new SentinelCommandBuilder<K, V>(codec);
    }

    @Override
    public RedisFuture<SocketAddress> getMasterAddrByName(K key) {
        return this.dispatch(this.commandBuilder.getMasterAddrByKey(key));
    }

    @Override
    public RedisFuture<List<Map<K, V>>> masters() {
        return this.dispatch(this.commandBuilder.masters());
    }

    @Override
    public RedisFuture<Map<K, V>> master(K key) {
        return this.dispatch(this.commandBuilder.master(key));
    }

    @Override
    public RedisFuture<List<Map<K, V>>> slaves(K key) {
        return this.dispatch(this.commandBuilder.slaves(key));
    }

    @Override
    public RedisFuture<Long> reset(K key) {
        return this.dispatch(this.commandBuilder.reset(key));
    }

    @Override
    public RedisFuture<String> failover(K key) {
        return this.dispatch(this.commandBuilder.failover(key));
    }

    @Override
    public RedisFuture<String> monitor(K key, String ip, int port, int quorum) {
        return this.dispatch(this.commandBuilder.monitor(key, ip, port, quorum));
    }

    @Override
    public RedisFuture<String> set(K key, String option, V value) {
        return this.dispatch(this.commandBuilder.set(key, option, value));
    }

    @Override
    public RedisFuture<String> remove(K key) {
        return this.dispatch(this.commandBuilder.remove(key));
    }

    @Override
    public RedisFuture<String> ping() {
        return this.dispatch(this.commandBuilder.ping());
    }

    @Override
    public RedisFuture<K> clientGetname() {
        return this.dispatch(this.commandBuilder.clientGetname());
    }

    @Override
    public RedisFuture<String> clientSetname(K name) {
        return this.dispatch(this.commandBuilder.clientSetname(name));
    }

    @Override
    public RedisFuture<String> clientKill(String addr) {
        return this.dispatch(this.commandBuilder.clientKill(addr));
    }

    @Override
    public RedisFuture<Long> clientKill(KillArgs killArgs) {
        return this.dispatch(this.commandBuilder.clientKill(killArgs));
    }

    @Override
    public RedisFuture<String> clientPause(long timeout) {
        return this.dispatch(this.commandBuilder.clientPause(timeout));
    }

    @Override
    public RedisFuture<String> clientList() {
        return this.dispatch(this.commandBuilder.clientList());
    }

    @Override
    public RedisFuture<String> info() {
        return this.dispatch(this.commandBuilder.info());
    }

    @Override
    public RedisFuture<String> info(String section) {
        return this.dispatch(this.commandBuilder.info(section));
    }

    @Override
    public <T> RedisFuture<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, T> output) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        return this.dispatch(new AsyncCommand<K, V, T>(new Command<K, V, T>(type, output)));
    }

    @Override
    public <T> RedisFuture<T> dispatch(ProtocolKeyword type, CommandOutput<K, V, T> output, CommandArgs<K, V> args) {
        LettuceAssert.notNull((Object)type, "Command type must not be null");
        LettuceAssert.notNull(output, "CommandOutput type must not be null");
        LettuceAssert.notNull(args, "CommandArgs type must not be null");
        return this.dispatch(new AsyncCommand<K, V, T>(new Command<K, V, T>(type, output, args)));
    }

    public <T> AsyncCommand<K, V, T> dispatch(RedisCommand<K, V, T> cmd) {
        AsyncCommand<K, V, T> asyncCommand = new AsyncCommand<K, V, T>(cmd);
        RedisCommand<K, V, T> dispatched = this.connection.dispatch(asyncCommand);
        if (dispatched instanceof AsyncCommand) {
            return (AsyncCommand)dispatched;
        }
        return asyncCommand;
    }

    public void close() {
        this.connection.close();
    }

    @Override
    public boolean isOpen() {
        return this.connection.isOpen();
    }

    @Override
    public StatefulRedisSentinelConnection<K, V> getStatefulConnection() {
        return (StatefulRedisSentinelConnection)this.connection;
    }
}

