/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.TempMetadataBuilder;
import org.apache.kylin.common.util.TimeZoneUtils;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.source.jdbc.H2Database;
import org.apache.kylin.tool.kerberos.DelegationTokenManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Profiles;

public class KylinPrepareEnvListener
implements EnvironmentPostProcessor,
Ordered {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinPrepareEnvListener.class);

    public int getOrder() {
        return -2147482628;
    }

    public void postProcessEnvironment(ConfigurableEnvironment env, SpringApplication application) {
        if (env.getPropertySources().contains("bootstrap")) {
            return;
        }
        if (env.getActiveProfiles().length == 0) {
            env.addActiveProfile("dev");
        }
        if (env.acceptsProfiles(Profiles.of((String[])new String[]{"sandbox"}))) {
            if (env.acceptsProfiles(Profiles.of((String[])new String[]{"docker"}))) {
                KylinPrepareEnvListener.setSandboxEnvs("../../dev-support/contributor/sandbox/conf");
            } else {
                KylinPrepareEnvListener.setSandboxEnvs("../../../kylin/src/examples/test_case_data/sandbox");
            }
        } else if (env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}))) {
            if (env.getSystemEnvironment().containsKey("KYLIN_CONF")) {
                ClassUtil.addClasspath((String)env.getSystemEnvironment().get("KYLIN_CONF").toString());
            }
            if (env.getProperty("dev.dont-load-test-metadata") == null && !StringUtils.equals((CharSequence)"true", (CharSequence)env.getProperty("dev.diag-meta"))) {
                KylinPrepareEnvListener.setLocalEnvs();
            }
        }
        Unsafe.setProperty((String)"needCheckCC", (String)"true");
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isCalciteCompatibleWithMsSqlPlusEnabled()) {
            Unsafe.setProperty((String)"calcite.compatible-with-mssql-plus", (String)"true");
        } else {
            Unsafe.setProperty((String)"calcite.compatible-with-mssql-plus", (String)"false");
        }
        Unsafe.setProperty((String)"calcite.bindable.cache.maxSize", (String)Integer.toString(config.getCalciteBindableCacheSize()));
        Unsafe.setProperty((String)"calcite.bindable.cache.concurrencyLevel", (String)Integer.toString(config.getCalciteBindableCacheConcurrencyLevel()));
        TimeZoneUtils.setDefaultTimeZone((KylinConfig)config);
        DelegationTokenManager delegationTokenManager = new DelegationTokenManager();
        delegationTokenManager.start();
        env.addActiveProfile(config.getSecurityProfile());
        String extraClassPath = config.getHiveMetastoreExtraClassPath();
        if (StringUtils.isNotEmpty((CharSequence)extraClassPath)) {
            ClassUtil.addToClasspath((String)extraClassPath, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
    }

    private static void setSandboxEnvs(String sandboxEnvPath) {
        File dir1 = new File(sandboxEnvPath);
        ClassUtil.addClasspath((String)dir1.getAbsolutePath());
        Unsafe.setProperty((String)"KYLIN_CONF", (String)dir1.getAbsolutePath());
        Unsafe.setProperty((String)"kylin.hadoop.conf.dir", (String)sandboxEnvPath);
        Unsafe.setProperty((String)"hdp.version", (String)"current");
    }

    private static void setLocalEnvs() {
        String tempMetadataDir = TempMetadataBuilder.prepareLocalTempMetadata();
        KylinConfig.setKylinConfigForLocalTest((String)tempMetadataDir);
        File localMetadata = new File(tempMetadataDir);
        Unsafe.setProperty((String)"hadoop.home.dir", (String)(localMetadata.getAbsolutePath() + "/working-dir"));
        Unsafe.setProperty((String)"spark.local", (String)"true");
        Unsafe.setProperty((String)"kylin.query.pushdown-enabled", (String)"true");
        Unsafe.setProperty((String)"kylin.query.pushdown.runner-class-name", (String)"org.apache.kylin.query.pushdown.PushDownRunnerJdbcImpl");
        Unsafe.setProperty((String)"kylin.query.pushdown.jdbc.url", (String)"jdbc:h2:mem:db_default;SCHEMA=DEFAULT");
        Unsafe.setProperty((String)"kylin.query.pushdown.jdbc.driver", (String)"org.h2.Driver");
        Unsafe.setProperty((String)"kylin.query.pushdown.jdbc.username", (String)"sa");
        Unsafe.setProperty((String)"kylin.query.pushdown.jdbc.password", (String)"");
        try {
            String username = System.getProperty("kylin.query.pushdown.jdbc.username");
            String password = System.getProperty("kylin.query.pushdown.jdbc.password");
            Connection h2Connection = DriverManager.getConnection("jdbc:h2:mem:db_default;DB_CLOSE_DELAY=-1", username, password);
            H2Database h2DB = new H2Database(h2Connection, KylinConfig.getInstanceFromEnv(), "default");
            h2DB.loadAllTables();
        }
        catch (SQLException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

