/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsController;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.cluster.ClusterManager;
import org.apache.kylin.rest.config.initialize.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;

@Configuration
public class MetricsConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricsConfig.class);
    @Autowired
    ClusterManager clusterManager;
    private static final ScheduledExecutorService METRICS_SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, (ThreadFactory)new NamedThreadFactory("MetricsChecker"));
    private static final Set<String> allControlledProjects = Collections.synchronizedSet(new HashSet());

    @EventListener(value={ApplicationReadyEvent.class})
    public void registerMetrics() {
        if (KylinConfig.getInstanceFromEnv().isPrometheusMetricsEnabled()) {
            log.info("Register prometheus global metrics... ");
            MetricsRegistry.registerGlobalPrometheusMetrics();
            METRICS_SCHEDULED_EXECUTOR.scheduleAtFixedRate(() -> {
                Set<String> allProjects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toSet());
                MetricsRegistry.refreshProjectLongRunningJobs(KylinConfig.getInstanceFromEnv(), allProjects);
                Sets.SetView newProjects = Sets.difference(allProjects, allControlledProjects);
                for (String newProject : newProjects) {
                    log.info("Register prometheus metrics for project {}", (Object)newProject);
                    MetricsRegistry.registerProjectPrometheusMetrics(KylinConfig.getInstanceFromEnv(), newProject);
                }
                allControlledProjects.clear();
                allControlledProjects.addAll(allProjects);
            }, 0L, 1L, TimeUnit.MINUTES);
        }
        if (!KapConfig.getInstanceFromEnv().isMonitorEnabled()) {
            return;
        }
        MetricsController.init((KapConfig)KapConfig.wrap((KylinConfig)KylinConfig.getInstanceFromEnv()));
        String host = this.clusterManager.getLocalServer();
        log.info("Register global metrics...");
        MetricsRegistry.registerGlobalMetrics(KylinConfig.getInstanceFromEnv(), host);
        log.info("Register host metrics...");
        MetricsRegistry.registerHostMetrics(host);
        METRICS_SCHEDULED_EXECUTOR.scheduleAtFixedRate(() -> {
            Set<String> allProjects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toSet());
            MetricsRegistry.refreshProjectLongRunningJobs(KylinConfig.getInstanceFromEnv(), allProjects);
            Sets.SetView newProjects = Sets.difference(allProjects, allControlledProjects);
            for (String newProject : newProjects) {
                log.info("Register project metrics for {}", (Object)newProject);
                MetricsRegistry.registerProjectMetrics(KylinConfig.getInstanceFromEnv(), newProject, host);
                MetricsRegistry.registerProjectPrometheusMetrics(KylinConfig.getInstanceFromEnv(), newProject);
            }
            Sets.SetView outDatedProjects = Sets.difference(allControlledProjects, allProjects);
            for (String outDatedProject : outDatedProjects) {
                log.info("Remove project metrics for {}", (Object)outDatedProject);
                MetricsGroup.removeProjectMetrics((String)outDatedProject);
                if (KylinConfig.getInstanceFromEnv().isPrometheusMetricsEnabled()) {
                    MetricsRegistry.deletePrometheusProjectMetrics(outDatedProject);
                }
                MetricsRegistry.removeProjectFromStorageSizeMap(outDatedProject);
            }
            allControlledProjects.clear();
            allControlledProjects.addAll(allProjects);
        }, 0L, 1L, TimeUnit.MINUTES);
        METRICS_SCHEDULED_EXECUTOR.scheduleAtFixedRate(MetricsRegistry::refreshTotalStorageSize, 0L, 10L, TimeUnit.MINUTES);
        METRICS_SCHEDULED_EXECUTOR.execute(() -> MetricsController.startReporters((KapConfig)KapConfig.wrap((KylinConfig)KylinConfig.getInstanceFromEnv())));
    }
}

