/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.handler.resourcegroup;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.resourcegroup.RequestTypeEnum;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupEntity;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupMappingInfo;
import org.apache.kylin.rest.handler.resourcegroup.IResourceGroupRequestValidator;
import org.apache.kylin.rest.request.resourecegroup.ResourceGroupRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=500)
@Component
public class ResourceGroupMappingInfoValidator
implements IResourceGroupRequestValidator {
    @Override
    public void validate(ResourceGroupRequest request) {
        if (!request.isResourceGroupEnabled()) {
            return;
        }
        List resourceGroups = request.getResourceGroupEntities().stream().map(ResourceGroupEntity::getId).collect(Collectors.toList());
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        List<ResourceGroupMappingInfo> mappingInfo = request.getResourceGroupMappingInfoList();
        for (ResourceGroupMappingInfo info2 : mappingInfo) {
            if (StringUtils.isBlank((CharSequence)info2.getProject())) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_IN_PARAMETER_NOT_EMPTY, new Object[]{"project", "mapping_info"});
            }
            ProjectInstance prjInstance = projectManager.getProject(info2.getProject());
            if (prjInstance == null) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{info2.getProject()});
            }
            if (StringUtils.isBlank((CharSequence)info2.getResourceGroupId())) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_IN_PARAMETER_NOT_EMPTY, new Object[]{"resource_group_id", "mapping_info"});
            }
            if (resourceGroups.contains(info2.getResourceGroupId())) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.RESOURCE_GROUP_ID_NOT_EXIST_IN_MAPPING_INFO, new Object[]{info2.getResourceGroupId()});
        }
        Map<String, List<ResourceGroupMappingInfo>> projectMappingInfo = mappingInfo.stream().collect(Collectors.groupingBy(ResourceGroupMappingInfo::getProject));
        for (Map.Entry<String, List<ResourceGroupMappingInfo>> entry : projectMappingInfo.entrySet()) {
            boolean bindInvalidNumInOneType;
            String project = entry.getKey();
            List<ResourceGroupMappingInfo> projectMapping = entry.getValue();
            boolean bindInvalidTotalNum = projectMapping.size() > 2;
            boolean bl = bindInvalidNumInOneType = projectMapping.stream().filter(info -> info.getRequestType() == RequestTypeEnum.BUILD).count() > 1L || projectMapping.stream().filter(info -> info.getRequestType() == RequestTypeEnum.QUERY).count() > 1L;
            if (!bindInvalidTotalNum && !bindInvalidNumInOneType) continue;
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.RESOURCE_GROUP_BINDING_PROJECT_INVALID, new Object[]{project});
        }
    }
}

