/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service.task;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;
import org.apache.kylin.metadata.favorite.AccelerateRuleUtil;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffset;
import org.apache.kylin.metadata.favorite.QueryHistoryIdOffsetManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.service.task.MetaUpdateJob;
import org.apache.kylin.rest.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class QueryHistoryMetaUpdateScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryHistoryMetaUpdateScheduler.class);
    private ScheduledExecutorService taskScheduler;
    private boolean hasStarted;
    @VisibleForTesting
    RDBMSQueryHistoryDAO queryHistoryDAO = RDBMSQueryHistoryDAO.getInstance();
    AccelerateRuleUtil accelerateRuleUtil = new AccelerateRuleUtil();
    private IUserGroupService userGroupService;

    public QueryHistoryMetaUpdateScheduler() {
        if (this.userGroupService == null && SpringContext.getApplicationContext() != null) {
            this.userGroupService = (IUserGroupService)SpringContext.getApplicationContext().getBean("userGroupService");
        }
        try (SetLogCategory ignored = new SetLogCategory("schedule");){
            log.debug("New QueryHistoryMetaUpdateScheduler created.");
        }
    }

    public static QueryHistoryMetaUpdateScheduler getInstance() {
        return (QueryHistoryMetaUpdateScheduler)Singletons.getInstance(QueryHistoryMetaUpdateScheduler.class);
    }

    public void init() {
        this.taskScheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("QueryHistoryMetaUpdateWorker"));
        this.taskScheduler.scheduleWithFixedDelay(this::checkAndSubmitJob, 0L, KylinConfig.getInstanceFromEnv().getQueryHistoryStatMetaUpdateInterval(), TimeUnit.MINUTES);
        this.hasStarted = true;
        log.info("Query history task scheduler is started.");
    }

    private void checkAndSubmitJob() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!JobContextUtil.getJobContext((KylinConfig)config).getJobScheduler().isMaster()) {
            log.info("Not master node, skip submitting meta job");
            return;
        }
        List prjList = NProjectManager.getInstance((KylinConfig)config).listAllProjects();
        prjList.forEach(projectInstance -> {
            String project = projectInstance.getName();
            ExecutableManager manager = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            manager.checkAndSubmitCronJob("META_JOB_FACTORY", JobTypeEnum.META);
        });
    }

    public Future scheduleImmediately(QueryHistoryTask runner) {
        return this.taskScheduler.schedule(runner, 10L, TimeUnit.SECONDS);
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    @Generated
    public IUserGroupService getUserGroupService() {
        return this.userGroupService;
    }

    static {
        JobFactory.register((String)"META_JOB_FACTORY", (JobFactory)new MetaUpdateJob.MetaUpdateJobFactory());
    }

    private static class DataflowHitCount {
        Map<Long, FrequencyMap> layoutHits = Maps.newHashMap();
        int dataflowHit;

        @Generated
        public DataflowHitCount() {
        }

        @Generated
        public Map<Long, FrequencyMap> getLayoutHits() {
            return this.layoutHits;
        }

        @Generated
        public int getDataflowHit() {
            return this.dataflowHit;
        }

        @Generated
        public void setLayoutHits(Map<Long, FrequencyMap> layoutHits) {
            this.layoutHits = layoutHits;
        }

        @Generated
        public void setDataflowHit(int dataflowHit) {
            this.dataflowHit = dataflowHit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataflowHitCount)) {
                return false;
            }
            DataflowHitCount other = (DataflowHitCount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Long, FrequencyMap> this$layoutHits = this.getLayoutHits();
            Map<Long, FrequencyMap> other$layoutHits = other.getLayoutHits();
            if (this$layoutHits == null ? other$layoutHits != null : !((Object)this$layoutHits).equals(other$layoutHits)) {
                return false;
            }
            return this.getDataflowHit() == other.getDataflowHit();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DataflowHitCount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Long, FrequencyMap> $layoutHits = this.getLayoutHits();
            result = result * 59 + ($layoutHits == null ? 43 : ((Object)$layoutHits).hashCode());
            result = result * 59 + this.getDataflowHit();
            return result;
        }

        @Generated
        public String toString() {
            return "QueryHistoryMetaUpdateScheduler.DataflowHitCount(layoutHits=" + this.getLayoutHits() + ", dataflowHit=" + this.getDataflowHit() + ")";
        }
    }

    private static abstract class QueryHistoryTask
    implements Runnable {
        protected final String project;

        public QueryHistoryTask(String project) {
            this.project = project;
        }

        protected abstract String name();

        public void batchHandle(int batchSize, int maxSize, Consumer<List<QueryHistory>> consumer) {
            List<QueryHistory> queryHistories;
            if (batchSize <= 0 || maxSize < batchSize) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s task, batch size: %d , maxsize: %d is illegal", this.name(), batchSize, maxSize));
            }
            int finishNum = 0;
            do {
                queryHistories = this.getQueryHistories(batchSize);
                finishNum += queryHistories.size();
                if (this.isInterrupted()) break;
                if (!queryHistories.isEmpty()) {
                    consumer.accept(queryHistories);
                }
                log.debug("{} handled {} query history", (Object)this.name(), (Object)queryHistories.size());
            } while (queryHistories.size() >= batchSize && finishNum < maxSize);
        }

        protected boolean isInterrupted() {
            return false;
        }

        protected abstract List<QueryHistory> getQueryHistories(int var1);

        @Override
        public void run() {
            try (SetLogCategory ignored = new SetLogCategory("schedule");){
                this.work();
            }
            catch (Exception e) {
                log.warn("QueryHistory {}  process failed of project({})", new Object[]{this.name(), this.project, e});
            }
        }

        protected abstract void work();
    }

    public class QueryHistoryMetaUpdateRunner
    extends QueryHistoryTask {
        private long lastOffset;

        public QueryHistoryMetaUpdateRunner(String project) {
            super(project);
            this.lastOffset = 0L;
        }

        @Override
        protected String name() {
            return "metaUpdate";
        }

        @Override
        protected List<QueryHistory> getQueryHistories(int batchSize) {
            QueryHistoryIdOffsetManager qhIdOffsetManager = QueryHistoryIdOffsetManager.getInstance((String)this.project);
            this.lastOffset = qhIdOffsetManager.get(QueryHistoryIdOffset.OffsetType.META).getOffset();
            return QueryHistoryMetaUpdateScheduler.this.queryHistoryDAO.queryQueryHistoriesByIdOffset(this.lastOffset, batchSize, this.project);
        }

        @Override
        public void work() {
            int maxSize = KylinConfig.getInstanceFromEnv().getQueryHistoryStatMetaUpdateMaxSize();
            int batchSize = KylinConfig.getInstanceFromEnv().getQueryHistoryStatMetaUpdateBatchSize();
            this.batchHandle(batchSize, maxSize, this::updateStatMeta);
        }

        private void updateStatMeta(List<QueryHistory> queryHistories) {
            long maxId = 0L;
            HashMap modelsLastQueryTime = Maps.newHashMap();
            Map<String, DataflowHitCount> dfHitCountMap = this.collectDataflowHitCount(queryHistories);
            for (QueryHistory queryHistory : queryHistories) {
                this.collectModelLastQueryTime(queryHistory, modelsLastQueryTime);
                if (queryHistory.getId() <= maxId) continue;
                maxId = queryHistory.getId();
            }
            Pair<Map<TableExtDesc, Integer>, Map<InternalTableDesc, Integer>> hitCountMap = this.collectHitCount(queryHistories);
            this.updateMetadata(dfHitCountMap, modelsLastQueryTime, maxId, hitCountMap);
        }

        private void updateMetadata(Map<String, DataflowHitCount> dfHitCountMap, Map<String, Long> modelsLastQueryTime, Long maxId, Pair<Map<TableExtDesc, Integer>, Map<InternalTableDesc, Integer>> hitCountMap) {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                this.incQueryHitCount(dfHitCountMap, this.project);
                this.updateLastQueryTime(modelsLastQueryTime, this.project);
                this.incQueryHitSnapshotCount((Map)hitCountMap.getFirst(), this.project);
                this.incQueryHitInternalTableCount((Map)hitCountMap.getSecond(), this.project);
                QueryHistoryIdOffsetManager offsetManager = QueryHistoryIdOffsetManager.getInstance((String)this.project);
                if (offsetManager.get(QueryHistoryIdOffset.OffsetType.META).getOffset() != this.lastOffset) {
                    log.warn("Multiple QueryHistoryMetaUpdateRunners are executing concurrently, just exit this one.");
                    throw new IllegalStateException("Multiple QueryHistoryMetaUpdateRunners are executing concurrently, just exit this one.");
                }
                JdbcUtil.withTxAndRetry((DataSourceTransactionManager)offsetManager.getTransactionManager(), () -> {
                    offsetManager.updateOffset(QueryHistoryIdOffset.OffsetType.META, copyForWrite -> copyForWrite.setOffset(maxId.longValue()));
                    return null;
                });
                return 0;
            }, (String)this.project, (int)1);
        }

        private Map<String, DataflowHitCount> collectDataflowHitCount(List<QueryHistory> queryHistories) {
            HashMap result = Maps.newHashMap();
            for (QueryHistory queryHistory : queryHistories) {
                List realizations = queryHistory.transformRealizations(this.project);
                if (CollectionUtils.isEmpty((Collection)realizations)) continue;
                List realizationList = realizations.stream().filter(this::isIndexRealization).collect(Collectors.toList());
                for (NativeQueryRealization realization : realizationList) {
                    String modelId = realization.getModelId();
                    result.computeIfAbsent(modelId, k -> new DataflowHitCount());
                    ++((DataflowHitCount)result.get((Object)modelId)).dataflowHit;
                    Map<Long, FrequencyMap> layoutHits = ((DataflowHitCount)result.get(modelId)).getLayoutHits();
                    layoutHits.computeIfAbsent(realization.getLayoutId(), k -> new FrequencyMap());
                    layoutHits.get(realization.getLayoutId()).incFrequency(queryHistory.getQueryTime());
                }
            }
            return result;
        }

        private boolean isIndexRealization(NativeQueryRealization realization) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)config, (String)this.project);
            return dfManager.getDataflow(realization.getModelId()) != null && realization.getLayoutId() != null;
        }

        private Pair<Map<TableExtDesc, Integer>, Map<InternalTableDesc, Integer>> collectHitCount(List<QueryHistory> queryHistories) {
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
            InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
            HashMap tableExtDescMap = new HashMap();
            HashMap internalTableDescMap = new HashMap();
            Pair results = new Pair(tableExtDescMap, internalTableDescMap);
            for (QueryHistory queryHistory : queryHistories) {
                List realizationMetrics;
                if (queryHistory.getQueryHistoryInfo() == null || CollectionUtils.isEmpty((Collection)(realizationMetrics = queryHistory.getQueryHistoryInfo().getRealizationMetrics()))) continue;
                for (QueryMetrics.RealizationMetrics realizationMetric : realizationMetrics) {
                    if (CollectionUtils.isEmpty((Collection)realizationMetric.getSnapshots())) continue;
                    realizationMetric.getSnapshots().forEach(tableIdentify -> {
                        if ("Table Snapshot".equals(realizationMetric.getIndexType())) {
                            ((Map)results.getFirst()).merge(tableManager.getOrCreateTableExt(tableIdentify), 1, Integer::sum);
                        } else if ("Internal Table".equals(realizationMetric.getIndexType())) {
                            ((Map)results.getSecond()).merge(internalTableManager.getInternalTableDesc(tableIdentify), 1, Integer::sum);
                        }
                    });
                }
            }
            return results;
        }

        private void collectModelLastQueryTime(QueryHistory queryHistory, Map<String, Long> modelsLastQueryTime) {
            List realizations = queryHistory.transformRealizations(this.project);
            long queryTime = queryHistory.getQueryTime();
            for (NativeQueryRealization realization : realizations) {
                String modelId = realization.getModelId();
                if (StringUtils.isEmpty((CharSequence)modelId)) continue;
                modelsLastQueryTime.put(modelId, queryTime);
            }
        }

        private void incQueryHitCount(Map<String, DataflowHitCount> dfHitCountMap, String project) {
            NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            for (Map.Entry<String, DataflowHitCount> entry : dfHitCountMap.entrySet()) {
                if (dfManager.getDataflow(entry.getKey()) == null) continue;
                Map<Long, FrequencyMap> layoutHitCount = entry.getValue().getLayoutHits();
                dfManager.updateDataflow(entry.getKey(), copyForWrite -> {
                    copyForWrite.setQueryHitCount(copyForWrite.getQueryHitCount() + ((DataflowHitCount)entry.getValue()).getDataflowHit());
                    for (Map.Entry layoutHitEntry : layoutHitCount.entrySet()) {
                        copyForWrite.getLayoutHitCount().merge(layoutHitEntry.getKey(), layoutHitEntry.getValue(), FrequencyMap::merge);
                    }
                });
            }
        }

        private void incQueryHitSnapshotCount(Map<TableExtDesc, Integer> hitSnapshotCountMap, String project) {
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            for (Map.Entry<TableExtDesc, Integer> entry : hitSnapshotCountMap.entrySet()) {
                if (tableManager.getOrCreateTableExt(entry.getKey().getIdentity()) == null) continue;
                TableExtDesc tableCopy = tableManager.copyForWrite(entry.getKey());
                tableCopy.setSnapshotHitCount(tableCopy.getSnapshotHitCount() + entry.getValue());
                tableManager.saveTableExt(tableCopy);
            }
        }

        private void incQueryHitInternalTableCount(Map<InternalTableDesc, Integer> hitInternalTableCountMap, String project) {
            InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            for (Map.Entry<InternalTableDesc, Integer> entry : hitInternalTableCountMap.entrySet()) {
                if (internalTableManager.getInternalTableDesc(entry.getKey().getIdentity()) == null) continue;
                InternalTableDesc internalTableCopy = internalTableManager.copyForWrite(entry.getKey());
                internalTableCopy.setHitCount(internalTableCopy.getHitCount() + (long)entry.getValue().intValue());
                internalTableManager.saveOrUpdateInternalTable(internalTableCopy);
            }
        }

        private void updateLastQueryTime(Map<String, Long> modelsLastQueryTime, String project) {
            NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            for (Map.Entry<String, Long> entry : modelsLastQueryTime.entrySet()) {
                String dataflowId = entry.getKey();
                Long lastQueryTime = entry.getValue();
                if (dfManager.getDataflow(dataflowId) == null) continue;
                dfManager.updateDataflow(dataflowId, copyForWrite -> copyForWrite.setLastQueryTime(lastQueryTime.longValue()));
            }
        }
    }
}

