/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeSystem;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.response.NHiveTableNameResponse;
import org.apache.kylin.rest.security.KerberosLoginManager;
import org.apache.kylin.rest.source.NHiveSourceInfo;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.apache.spark.sql.SparderEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceState
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceState.class);
    private static final String JDBC_SOURCE_KEY_PREFIX = "project#";
    private static final String SOURCE_KEY_PREFIX = "ugi#";
    private final StopWatch sw;
    private final Map<String, NHiveSourceInfo> cache;
    private final Map<String, Boolean> runningStateMap;
    private final Map<String, Long> lastLoadTimeMap;
    private ISourceMetadataExplorer explore;
    private static final Set<Integer> USE_PROJECT_AS_KEY_SOURCE_TYPE = Sets.newHashSet((Object[])new Integer[]{8});

    public static DataSourceState getInstance() {
        return (DataSourceState)Singletons.getInstance(DataSourceState.class);
    }

    private DataSourceState() {
        this.setExplore(SourceFactory.getSparkSource().getSourceMetadataExplorer());
        this.cache = Maps.newConcurrentMap();
        this.runningStateMap = Maps.newConcurrentMap();
        this.lastLoadTimeMap = Maps.newConcurrentMap();
        this.sw = StopWatch.create();
    }

    @Override
    public void run() {
        try {
            int waitSeconds = 0;
            while (!SparderEnv.isSparkAvailable() && KylinConfig.getInstanceFromEnv().getKerberosProjectLevelEnable()) {
                if (waitSeconds >= KylinConfig.getInstanceFromEnv().getLoadHiveTableWaitSparderSeconds()) {
                    log.warn("Skip wait sparder start, wait seconds :{}", (Object)waitSeconds);
                    return;
                }
                this.startSparder();
                log.info("Wait sparder start");
                Integer intervals = KylinConfig.getInstanceFromEnv().getLoadHiveTableWaitSparderIntervals();
                TimeUnit.SECONDS.sleep(intervals.intValue());
                waitSeconds += intervals.intValue();
            }
            this.loadAllSourceInfoToCache();
        }
        catch (InterruptedException ex) {
            log.info("thread interrupted while wait sparder start");
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("Scheduling refresh of hive table name cache failed", (Throwable)e);
        }
        finally {
            this.sw.reset();
        }
    }

    private void startSparder() {
        if (!KylinConfig.getInstanceFromEnv().isUTEnv()) {
            SparderEnv.init();
        }
    }

    public void loadAllSourceInfoToCache() throws IOException {
        this.sw.start();
        this.checkIsAllNode();
        log.info("start load all table name to cache");
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        KerberosLoginManager kerberosManager = KerberosLoginManager.getInstance();
        LinkedHashMap ugiMap = Maps.newLinkedHashMap();
        ugiMap.put(SOURCE_KEY_PREFIX + UserGroupInformation.getLoginUser().getUserName(), Pair.newPair(null, (Object)UserGroupInformation.getLoginUser()));
        projectManager.listAllProjects().stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getPrincipal())).forEach(projectInstance -> {
            try {
                UserGroupInformation projectUgi = kerberosManager.getProjectUGI(projectInstance.getName());
                ugiMap.put(this.getCacheKeyByProject((ProjectInstance)projectInstance), Pair.newPair((Object)projectInstance, (Object)projectUgi));
            }
            catch (Exception e) {
                log.error("The kerberos information of the project {} is incorrect.", (Object)projectInstance.getName());
            }
        });
        ugiMap.forEach((cacheKey, pair) -> {
            ProjectInstance projectInstance = (ProjectInstance)pair.getFirst();
            UserGroupInformation projectUgi = (UserGroupInformation)pair.getSecond();
            this.runningStateMap.put((String)cacheKey, true);
            List<String> tableFilterList = this.getHiveFilterList(projectInstance);
            NHiveSourceInfo sourceInfo = this.fetchUgiSourceInfo(projectUgi, tableFilterList);
            this.putCache((String)cacheKey, sourceInfo, tableFilterList);
            this.runningStateMap.put((String)cacheKey, false);
            this.lastLoadTimeMap.put((String)cacheKey, System.currentTimeMillis());
        });
        this.sw.stop();
        log.info("Load hive table name successful within {} second", (Object)this.sw.getTime(TimeUnit.SECONDS));
    }

    public NHiveTableNameResponse loadAllSourceInfoToCacheForced(String project, boolean force) {
        log.info("Load hive tables immediately {}, force: {}", (Object)project, (Object)force);
        this.checkIsAllNode();
        this.checkKerberosInfo(project);
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance projectInstance = projectManager.getProject(project);
        NHiveTableNameResponse response = new NHiveTableNameResponse();
        String cacheKey = this.getCacheKeyByProject(projectInstance);
        this.runningStateMap.putIfAbsent(cacheKey, false);
        this.lastLoadTimeMap.putIfAbsent(cacheKey, 0L);
        if (!force) {
            response.setIsRunning(this.runningStateMap.get(cacheKey));
            response.setTime(System.currentTimeMillis() - this.lastLoadTimeMap.get(cacheKey));
            return response;
        }
        this.setExplore(SourceFactory.getSource((ISourceAware)projectInstance).getSourceMetadataExplorer());
        KerberosLoginManager kerberosManager = KerberosLoginManager.getInstance();
        UserGroupInformation projectUGI = kerberosManager.getProjectUGI(project);
        this.runningStateMap.put(cacheKey, true);
        List<String> tableFilterList = this.getHiveFilterList(projectInstance);
        NHiveSourceInfo sourceInfo = this.fetchUgiSourceInfo(projectUGI, tableFilterList);
        this.putCache(cacheKey, sourceInfo, tableFilterList);
        this.runningStateMap.put(cacheKey, false);
        response.setIsRunning(this.runningStateMap.get(cacheKey));
        response.setTime(0L);
        return response;
    }

    public synchronized List<String> getTables(String project, String db) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance projectInstance = projectManager.getProject(project);
        ArrayList result = Lists.newArrayList();
        NHiveSourceInfo sourceInfo = this.cache.get(this.getCacheKeyByProject(projectInstance));
        if (Objects.nonNull(sourceInfo) && Objects.nonNull(sourceInfo.getDatabaseInfo(db))) {
            result.addAll(sourceInfo.getDatabaseInfo(db));
        }
        return result;
    }

    public synchronized void putCache(String cacheKey, NHiveSourceInfo sourceInfo, List<String> tableFilterList) {
        if (CollectionUtils.isNotEmpty(tableFilterList)) {
            NHiveSourceInfo info = this.cache.get(cacheKey);
            if (!this.checkSourceInfoEmpty(sourceInfo) && !this.checkSourceInfoEmpty(info)) {
                info.getTables().keySet().forEach(db -> {
                    if (CollectionUtils.isEmpty(sourceInfo.getDatabaseInfo((String)db))) {
                        if (tableFilterList.contains(db)) {
                            return;
                        }
                        sourceInfo.putDatabaseInfo((String)db, info.getDatabaseInfo((String)db));
                    }
                });
            }
        }
        this.cache.put(cacheKey, sourceInfo);
    }

    private boolean checkSourceInfoEmpty(NHiveSourceInfo sourceInfo) {
        return sourceInfo == null || sourceInfo.getTables().isEmpty();
    }

    private String getCacheKeyByProject(ProjectInstance projectInstance) {
        String projectName = projectInstance.getName();
        if (USE_PROJECT_AS_KEY_SOURCE_TYPE.contains(projectInstance.getSourceType())) {
            return JDBC_SOURCE_KEY_PREFIX + projectName;
        }
        return SOURCE_KEY_PREFIX + KerberosLoginManager.getInstance().getProjectUGI(projectName).getUserName();
    }

    public NHiveSourceInfo fetchUgiSourceInfo(UserGroupInformation ugi, List<String> filterList) {
        log.info("Load hive tables from ugi {}", (Object)ugi.getUserName());
        NHiveSourceInfo sourceInfo = UserGroupInformation.isSecurityEnabled() ? (NHiveSourceInfo)ugi.doAs(() -> this.fetchSourceInfo(filterList)) : this.fetchSourceInfo(filterList);
        return sourceInfo;
    }

    private NHiveSourceInfo fetchSourceInfo(List<String> filterList) {
        NHiveSourceInfo sourceInfo = new NHiveSourceInfo();
        try {
            List<String> databaseList = this.explore.listDatabases().stream().map(StringUtils::toRootUpperCase).filter(database -> CollectionUtils.isEmpty((Collection)filterList) || filterList.contains(database)).collect(Collectors.toList());
            Map<String, List<String>> dbTableList = this.listTables(databaseList);
            sourceInfo.setTables(dbTableList);
        }
        catch (Exception e) {
            log.error("Load hive tables error.", (Throwable)e);
        }
        return sourceInfo;
    }

    private Map<String, List<String>> listTables(List<String> databaseList) throws Exception {
        HashMap dbTableList = Maps.newHashMap();
        int databaseTotalSize = databaseList.size();
        for (String database : databaseList) {
            int currDatabaseSize;
            if (!this.explore.checkDatabaseAccess(database)) continue;
            List tableList = this.explore.listTables(database).stream().map(StringUtils::toRootUpperCase).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tableList)) {
                dbTableList.put(database, tableList);
            }
            if ((currDatabaseSize = dbTableList.keySet().size()) % 20 != 0) continue;
            log.info("Foreach database curr pos {}, total num {}", (Object)currDatabaseSize, (Object)databaseTotalSize);
        }
        return dbTableList;
    }

    private void checkKerberosInfo(String project) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)kylinConfig);
        ProjectInstance projectInstance = projectManager.getProject(project);
        String principal = projectInstance.getPrincipal();
        String keytab = projectInstance.getKeytab();
        try {
            if (kylinConfig.getKerberosProjectLevelEnable() && !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{principal, keytab})) {
                String kylinConfHome = KapConfig.getKylinConfDirAtBestEffort();
                String keyTabPath = new Path(kylinConfHome, principal.concat(".keytab")).toString();
                File keyTabFile = new File(keyTabPath);
                if (!keyTabFile.exists()) {
                    FileUtils.writeStringToFile((File)keyTabFile, (String)keytab);
                }
                UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keyTabPath);
            }
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CHECK_KERBEROS, "The project " + project + " kerberos information has expired.");
        }
    }

    public List<String> getHiveFilterList(ProjectInstance projectInstance) {
        if (Objects.isNull(projectInstance)) {
            return Collections.emptyList();
        }
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String[] databases = projectInstance.getConfig().getHiveDatabases();
        if (databases.length == 0) {
            databases = config.getHiveDatabases();
        }
        return Arrays.stream(databases).map(str -> str.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
    }

    private void checkIsAllNode() {
        if (!KylinConfig.getInstanceFromEnv().isJobNode() && !KylinConfig.getInstanceFromEnv().isMetadataNode()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeSystem.QUERY_NODE_API_INVALID, new Object[0]);
        }
        if (!KylinConfig.getInstanceFromEnv().getLoadHiveTablenameEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getInvalidLoadHiveTableName());
        }
    }

    private synchronized void setExplore(ISourceMetadataExplorer explore) {
        this.explore = explore;
    }
}

