/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.IOException;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.FileSystemUtil;
import org.apache.kylin.common.util.HadoopUtil;

public class HDFSMetadataTool {
    private HDFSMetadataTool() {
    }

    public static void cleanBeforeBackup(KylinConfig kylinConfig) throws IOException {
        Path rootMetadataBackupPath = new Path(HadoopUtil.getBackupFolder((KylinConfig)KylinConfig.getInstanceFromEnv()));
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (!fs.exists(rootMetadataBackupPath)) {
            fs.mkdirs(rootMetadataBackupPath);
            return;
        }
        for (int childrenSize = fs.listStatus(rootMetadataBackupPath).length; childrenSize >= kylinConfig.getMetadataBackupCountThreshold(); --childrenSize) {
            Optional<FileStatus> maybeOldest = Stream.of(FileSystemUtil.listStatus((FileSystem)fs, (Path)rootMetadataBackupPath)).min(Comparator.comparing(FileStatus::getModificationTime));
            if (!maybeOldest.isPresent()) continue;
            fs.delete(maybeOldest.get().getPath(), true);
        }
    }
}

