/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.optimization.GarbageLayoutType;
import org.apache.kylin.metadata.cube.optimization.IndexOptimizerFactory;
import org.apache.kylin.metadata.cube.optimization.event.ApproveRecsEvent;
import org.apache.kylin.metadata.cube.optimization.event.BuildIndexEvent;
import org.apache.kylin.metadata.cube.utils.IndexPlanReduceUtil;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.apache.kylin.tool.garbage.MetadataCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class IndexCleaner
extends MetadataCleaner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IndexCleaner.class);
    private List<String> needUpdateModels = Lists.newArrayList();
    private Map<NDataflow, Map<Long, GarbageLayoutType>> needOptAggressivelyModels = Maps.newHashMap();
    private final boolean needAggressiveOpt;

    public IndexCleaner(String project, boolean needAggressiveOpt) {
        super(project);
        this.needAggressiveOpt = needAggressiveOpt;
    }

    @Override
    public void prepare() {
        log.info("Start to clean index in project {}", (Object)this.project);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)config, (String)this.project);
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)config).getProject(this.project);
        if (projectInstance.isExpertMode()) {
            log.info("not semiautomode, can't run index clean");
            return;
        }
        OptRecManagerV2 recManagerV2 = OptRecManagerV2.getInstance((String)this.project);
        for (NDataModel model : dataflowManager.listUnderliningDataModels()) {
            boolean hasNewRecItem;
            NDataflow dataflow = dataflowManager.getDataflow(model.getId()).copy();
            Map garbageLayouts = IndexOptimizerFactory.getOptimizer((NDataflow)dataflow, (boolean)this.needAggressiveOpt, (boolean)true).getGarbageLayoutMap(dataflow);
            if (this.needAggressiveOpt) {
                this.needOptAggressivelyModels.put(dataflow, garbageLayouts);
                continue;
            }
            if (MapUtils.isEmpty((Map)garbageLayouts) || !(hasNewRecItem = recManagerV2.genRecItemsFromIndexOptimizer(this.project, model.getUuid(), garbageLayouts))) continue;
            this.needUpdateModels.add(model.getId());
        }
        log.info("Clean index in project {} finished", (Object)this.project);
    }

    @Override
    public void beforeExecute() {
        if (MapUtils.isEmpty(this.needOptAggressivelyModels)) {
            return;
        }
        this.approveRec();
        this.mergeSameDimAggLayout();
    }

    @Override
    public void execute() {
        if (MapUtils.isNotEmpty(this.needOptAggressivelyModels)) {
            this.cleanUpIndexAggressively();
        }
        if (this.needUpdateModels.isEmpty()) {
            return;
        }
        NDataModelManager mgr = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        this.needUpdateModels.forEach(modelId -> {
            NDataModel dataModel = mgr.getDataModelDesc(modelId);
            if (dataModel != null && !dataModel.isBroken()) {
                OptRecV2 optRecV2 = OptRecManagerV2.getInstance((String)this.project).loadOptRecV2(modelId);
                int newSize = optRecV2.getAdditionalLayoutRefs().size() + optRecV2.getRemovalLayoutRefs().size();
                if (dataModel.getRecommendationsCount() != newSize) {
                    mgr.updateDataModel(modelId, copyForWrite -> copyForWrite.setRecommendationsCount(newSize));
                }
            }
        });
    }

    @Override
    public void afterExecute() {
        if (MapUtils.isEmpty(this.needOptAggressivelyModels)) {
            return;
        }
        this.buildIndexes();
    }

    private List<Set<LayoutEntity>> getMergedLayouts(IndexPlan indexPlan, Map<Long, GarbageLayoutType> garbageLayouts) {
        ArrayList merged = Lists.newArrayList();
        garbageLayouts.forEach((layoutId, garbageLayoutType) -> {
            LayoutEntity layout = indexPlan.getLayoutEntity(layoutId);
            if (GarbageLayoutType.MERGED == garbageLayoutType && !Objects.isNull(layout)) {
                merged.add(layout);
            }
        });
        return IndexPlanReduceUtil.collectSameDimAggLayouts((List)merged);
    }

    private void approveRec() {
        EventBusFactory eventBusF = EventBusFactory.getInstance();
        eventBusF.callService((Object)new ApproveRecsEvent(this.project, this.needOptAggressivelyModels));
    }

    private void mergeSameDimAggLayout() {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        this.needOptAggressivelyModels.forEach((dataflow, garbageLayouts) -> {
            IndexPlan indexPlan = indexPlanManager.getIndexPlan(dataflow.getId());
            List<Set<LayoutEntity>> mergedLayouts = this.getMergedLayouts(indexPlan, (Map<Long, GarbageLayoutType>)garbageLayouts);
            if (CollectionUtils.isEmpty(mergedLayouts)) {
                return;
            }
            log.info("merge same dimension index for model: {} under project: {}", (Object)dataflow.getModelAlias(), (Object)this.project);
            indexPlanManager.updateIndexPlan(dataflow.getId(), copyForWrite -> {
                IndexPlan indexPlanMerged = IndexPlanReduceUtil.mergeSameDimLayout((IndexPlan)indexPlan, (List)mergedLayouts);
                copyForWrite.setIndexes(indexPlanMerged.getIndexes());
                copyForWrite.setLastModified(System.currentTimeMillis());
            });
        });
    }

    private void cleanUpIndexAggressively() {
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        this.needOptAggressivelyModels.forEach((dataflow, garbageLayouts) -> {
            if (MapUtils.isEmpty((Map)garbageLayouts)) {
                return;
            }
            log.info("aggressively clean up index for model: {} under project: {}", (Object)dataflow.getModelAlias(), (Object)this.project);
            IndexPlan indexPlan = indexPlanManager.getIndexPlan(dataflow.getId());
            this.deleteIndexes(indexPlan, garbageLayouts.keySet());
        });
    }

    private void deleteIndexes(IndexPlan indexPlan, Set<Long> garbageLayouts) {
        garbageLayouts.stream().map(layoutId -> indexPlan.getLayoutEntity(layoutId).getIndex()).forEachOrdered(index -> {
            indexPlan.getIndexes().remove(index);
            indexPlan.getToBeDeletedIndexes().add(index);
        });
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
        indexPlanManager.updateIndexPlan(indexPlan.getId(), copyForWrite -> {
            copyForWrite.setLastModified(System.currentTimeMillis());
            copyForWrite.getToBeDeletedIndexes().addAll(indexPlan.getToBeDeletedIndexes().stream().filter(index -> !copyForWrite.getToBeDeletedIndexes().contains(index)).collect(Collectors.toList()));
            copyForWrite.getIndexes().removeAll(indexPlan.getToBeDeletedIndexes());
        });
    }

    private void buildIndexes() {
        EventBusFactory eventBusFactory = EventBusFactory.getInstance();
        eventBusFactory.callService((Object)new BuildIndexEvent(this.project, (List)Lists.newArrayList(this.needOptAggressivelyModels.keySet())));
    }
}

