/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import java.util.Arrays;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.scheduler.SourceUsageUpdateNotifier;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.garbage.ExecutableCleaner;
import org.apache.kylin.tool.garbage.GarbageCleaner;
import org.apache.kylin.tool.garbage.IndexCleaner;
import org.apache.kylin.tool.garbage.SnapshotCleaner;

public abstract class MetadataCleaner
implements GarbageCleaner {
    protected final String project;

    protected MetadataCleaner(String project) {
        this.project = project;
    }

    public abstract void beforeExecute();

    @Override
    public abstract void execute();

    public abstract void afterExecute();

    public void prepare() {
    }

    public static void clean(String project, boolean needAggressiveOpt) {
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project);
        if (projectInstance == null) {
            return;
        }
        List<MetadataCleaner> cleaners = MetadataCleaner.initCleaners(project, needAggressiveOpt);
        cleaners.forEach(MetadataCleaner::prepare);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            cleaners.forEach(MetadataCleaner::beforeExecute);
            cleaners.forEach(MetadataCleaner::execute);
            cleaners.forEach(MetadataCleaner::afterExecute);
            return 0;
        }, (String)project);
        EventBusFactory.getInstance().postAsync((SchedulerEventNotifier)new SourceUsageUpdateNotifier());
        MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_CLEAN, (MetricsCategory)MetricsCategory.PROJECT, (String)project);
    }

    private static List<MetadataCleaner> initCleaners(String project, boolean needAggressiveOpt) {
        return Arrays.asList(new SnapshotCleaner(project), new IndexCleaner(project, needAggressiveOpt), new ExecutableCleaner(project));
    }
}

