/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.routine;

import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.helper.RoutineToolHelper;
import org.apache.kylin.tool.routine.RoutineTool;
import org.apache.kylin.tool.util.ToolMainWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastRoutineTool
extends RoutineTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FastRoutineTool.class);

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (this.printUsage(optionsHelper)) {
            return;
        }
        this.initOptionValues(optionsHelper);
        List<String> projectsToCleanup = this.getProjectsToCleanup();
        try {
            if (this.isMetadataCleanup()) {
                System.out.println("Start to fast cleanup metadata");
                RoutineToolHelper.cleanMeta(projectsToCleanup);
            }
            System.out.println("Start to fast cleanup hdfs");
            this.cleanStorage();
            this.cleanEventLogs();
        }
        catch (Exception e) {
            log.error("Failed to execute fast routintool", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        ToolMainWrapper.wrap(args, () -> {
            FastRoutineTool tool = new FastRoutineTool();
            tool.execute(args);
        });
        Unsafe.systemExit((int)0);
    }
}

