/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableFromJson {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateTableFromJson.class);
    private static final String QUOTE = "`";
    private static final Map<String, String> TYPE_MAP = new HashMap<String, String>();

    public static void main(String[] args) throws IOException {
        String pathDir = args[0];
        Map<String, List<String>> map = CreateTableFromJson.createDbAndTables(pathDir);
        map.forEach((db, tables) -> {
            for (String s : db.split("\n")) {
                log.info(s);
            }
            tables.forEach(arg_0 -> ((Logger)log).info(arg_0));
        });
    }

    private static Map<String, List<String>> createDbAndTables(String pathDir) throws IOException {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        File file = new File(pathDir).getAbsoluteFile();
        File[] files = file.listFiles();
        for (File f : Objects.requireNonNull(files)) {
            TableDesc tableDesc = (TableDesc)JsonUtil.readValue((File)f, TableDesc.class);
            ArrayList<String> columnNameTypeList = new ArrayList<String>();
            for (ColumnDesc column : tableDesc.getColumns()) {
                String name = column.getName();
                String type = CreateTableFromJson.convert(column.getDatatype());
                columnNameTypeList.add(String.format(Locale.ROOT, "%s %s", CreateTableFromJson.quote(name), type));
            }
            String databaseSql = String.format(Locale.ROOT, "create database %s;%nuse %s;", CreateTableFromJson.quote(tableDesc.getDatabase()), CreateTableFromJson.quote(tableDesc.getDatabase()));
            map.putIfAbsent(databaseSql, new ArrayList());
            String tableSql = CreateTableFromJson.createTableSql(tableDesc.getName(), columnNameTypeList);
            ((List)map.get(databaseSql)).add(tableSql);
        }
        return map;
    }

    private static String quote(String identifier) {
        return QUOTE + identifier + QUOTE;
    }

    private static String createTableSql(String table, List<String> columns) {
        return String.format(Locale.ROOT, "create table %s(%s);", CreateTableFromJson.quote(table), String.join((CharSequence)", ", columns));
    }

    private static String convert(String oriType) {
        return TYPE_MAP.getOrDefault(oriType.toLowerCase(Locale.ROOT), oriType.toLowerCase(Locale.ROOT));
    }

    static {
        TYPE_MAP.put("integer", "int");
        TYPE_MAP.put("long", "bigint");
    }
}

