/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import com.codahale.metrics.Gauge;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.event.ModelAddEvent;
import org.apache.kylin.common.event.ModelDropEvent;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.metrics.MetricsTag;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkContext;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.rest.config.initialize.MetricsRegistry;
import org.apache.kylin.rest.util.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelDropAddListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelDropAddListener.class);

    @Subscribe
    public void onDelete(ModelDropEvent modelDropEvent) {
        String project = modelDropEvent.getProject();
        String modelId = modelDropEvent.getModelId();
        String modelName = modelDropEvent.getModelName();
        UnitOfWorkContext context = UnitOfWork.get();
        context.doAfterUnit(() -> {
            log.debug("delete model {} in project {}", (Object)modelId, (Object)project);
            MetricsGroup.removeModelMetrics((String)project, (String)modelId);
            if (KylinConfig.getInstanceFromEnv().isPrometheusMetricsEnabled()) {
                MetricsRegistry.removePrometheusModelMetrics((String)project, (String)modelName);
            }
        });
    }

    @Subscribe
    public void onAdd(ModelAddEvent modelAddEvent) {
        String project = modelAddEvent.getProject();
        final String modelId = modelAddEvent.getModelId();
        String modelAlias = modelAddEvent.getModelAlias();
        final NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        HashMap tags = Maps.newHashMap();
        tags.put(MetricsTag.MODEL.getVal(), project.concat("-").concat(modelAlias));
        MetricsGroup.newGauge((MetricsName)MetricsName.MODEL_SEGMENTS, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (Gauge)new GaugeWrapper(){

            @Override
            public Long getResult() {
                NDataflow df = dfManager.getDataflow(modelId);
                return df == null ? 0L : (long)df.getSegments().size();
            }
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.MODEL_STORAGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (Gauge)new GaugeWrapper(){

            @Override
            public Long getResult() {
                NDataflow df = dfManager.getDataflow(modelId);
                return df == null ? 0L : df.getStorageBytesSize();
            }
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.MODEL_LAST_QUERY_TIME, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (Gauge)new GaugeWrapper(){

            @Override
            public Long getResult() {
                NDataflow df = dfManager.getDataflow(modelId);
                return df == null ? 0L : df.getLastQueryTime();
            }
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.MODEL_QUERY_COUNT, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (Gauge)new GaugeWrapper(){

            @Override
            public Long getResult() {
                NDataflow df = dfManager.getDataflow(modelId);
                return df == null ? 0L : (long)df.getQueryHitCount();
            }
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.MODEL_INDEX_NUM_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, (Gauge)new GaugeWrapper(){

            @Override
            public Long getResult() {
                NDataflow df = dfManager.getDataflow(modelId);
                return df == null ? 0L : (long)df.getIndexPlan().getAllLayouts().size();
            }
        });
        MetricsGroup.newGauge((MetricsName)MetricsName.MODEL_EXPANSION_RATE_GAUGE, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags, () -> {
            NDataflow df = dfManager.getDataflow(modelId);
            return df == null ? 0.0 : Double.parseDouble(ModelUtils.computeExpansionRate(df.getStorageBytesSize(), df.getSourceBytesSize()));
        });
        MetricsGroup.newCounter((MetricsName)MetricsName.MODEL_BUILD_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
        MetricsGroup.newCounter((MetricsName)MetricsName.MODEL_WAIT_DURATION, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
        MetricsGroup.newHistogram((MetricsName)MetricsName.MODEL_BUILD_DURATION_HISTOGRAM, (MetricsCategory)MetricsCategory.PROJECT, (String)project, (Map)tags);
    }

    static abstract class GaugeWrapper
    implements Gauge<Long> {
        GaugeWrapper() {
        }

        public abstract Long getResult();

        public Long getValue() {
            try {
                return this.getResult();
            }
            catch (Exception e) {
                log.error("Exception happens.", (Throwable)e);
                return 0L;
            }
        }
    }
}

