/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.job.exception.JobSubmissionException;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.NDataSegmentResponse;

public class JobInfoResponseWithFailure
extends JobInfoResponse {
    @JsonProperty(value="failed_segments")
    List<FailedSegmentJobWithReason> failedSegments = new LinkedList<FailedSegmentJobWithReason>();

    public void addFailedSeg(NDataflow dataflow, JobSubmissionException jobSubmissionException) {
        Segments segments = dataflow.getSegments();
        for (Map.Entry entry : jobSubmissionException.getSegmentFailInfos().entrySet()) {
            String segId = (String)entry.getKey();
            KylinException kylinException = (KylinException)entry.getValue();
            FailedSegmentJobWithReason failedSeg = new FailedSegmentJobWithReason(dataflow, (Segments<NDataSegment>)segments, dataflow.getSegment(segId));
            String code = this.getErrorCode(kylinException);
            Error errorInfo = new Error(code, kylinException.getMessage());
            failedSeg.setError(errorInfo);
            this.failedSegments.add(failedSeg);
        }
    }

    private String getErrorCode(KylinException kylinException) {
        String code = null;
        if (null != kylinException.getErrorCode()) {
            code = kylinException.getErrorCode().getCodeString();
        } else if (null != kylinException.getErrorCodeProducer()) {
            code = kylinException.getErrorCodeProducer().getErrorCode().getCode();
        }
        return code;
    }

    @Generated
    public JobInfoResponseWithFailure() {
    }

    @Generated
    public List<FailedSegmentJobWithReason> getFailedSegments() {
        return this.failedSegments;
    }

    @Generated
    public void setFailedSegments(List<FailedSegmentJobWithReason> failedSegments) {
        this.failedSegments = failedSegments;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobInfoResponseWithFailure)) {
            return false;
        }
        JobInfoResponseWithFailure other = (JobInfoResponseWithFailure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FailedSegmentJobWithReason> this$failedSegments = this.getFailedSegments();
        List<FailedSegmentJobWithReason> other$failedSegments = other.getFailedSegments();
        return !(this$failedSegments == null ? other$failedSegments != null : !((Object)this$failedSegments).equals(other$failedSegments));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JobInfoResponseWithFailure;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FailedSegmentJobWithReason> $failedSegments = this.getFailedSegments();
        result = result * 59 + ($failedSegments == null ? 43 : ((Object)$failedSegments).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "JobInfoResponseWithFailure(failedSegments=" + this.getFailedSegments() + ")";
    }

    public static class Error
    implements Serializable {
        @JsonProperty(value="code")
        private String code;
        @JsonProperty(value="msg")
        private String msg;

        public Error(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Error;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JobInfoResponseWithFailure.Error(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
        }
    }

    public static class FailedSegmentJobWithReason
    extends NDataSegmentResponse {
        @JsonProperty(value="error")
        private Error error;

        public FailedSegmentJobWithReason(NDataflow dataflow, Segments<NDataSegment> segments, NDataSegment segment) {
            super(dataflow, segments, segment);
        }

        @Generated
        public Error getError() {
            return this.error;
        }

        @Generated
        public void setError(Error error) {
            this.error = error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FailedSegmentJobWithReason)) {
                return false;
            }
            FailedSegmentJobWithReason other = (FailedSegmentJobWithReason)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Error this$error = this.getError();
            Error other$error = other.getError();
            return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FailedSegmentJobWithReason;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Error $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JobInfoResponseWithFailure.FailedSegmentJobWithReason(error=" + this.getError() + ")";
        }
    }
}

