/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.com.squareup.moshi;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonDataException;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonEncodingException;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonScope;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonUtf8Reader;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonUtf8Writer;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.LinkedHashTreeMap;
import org.apache.kylin.shaded.influxdb.okio.Buffer;
import org.apache.kylin.shaded.influxdb.okio.BufferedSource;
import org.apache.kylin.shaded.influxdb.okio.ByteString;

public abstract class JsonReader
implements Closeable {
    int stackSize = 0;
    final int[] scopes = new int[32];
    final String[] pathNames = new String[32];
    final int[] pathIndices = new int[32];
    boolean lenient;
    boolean failOnUnknown;

    public static JsonReader of(BufferedSource source) {
        return new JsonUtf8Reader(source);
    }

    JsonReader() {
    }

    final void pushScope(int newTop) {
        if (this.stackSize == this.scopes.length) {
            throw new JsonDataException("Nesting too deep at " + this.getPath());
        }
        this.scopes[this.stackSize++] = newTop;
    }

    final JsonEncodingException syntaxError(String message) throws JsonEncodingException {
        throw new JsonEncodingException(message + " at path " + this.getPath());
    }

    final JsonDataException typeMismatch(@Nullable Object value, Object expected) {
        if (value == null) {
            return new JsonDataException("Expected " + expected + " but was null at path " + this.getPath());
        }
        return new JsonDataException("Expected " + expected + " but was " + value + ", a " + value.getClass().getName() + ", at path " + this.getPath());
    }

    public final void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public final void setFailOnUnknown(boolean failOnUnknown) {
        this.failOnUnknown = failOnUnknown;
    }

    public final boolean failOnUnknown() {
        return this.failOnUnknown;
    }

    public abstract void beginArray() throws IOException;

    public abstract void endArray() throws IOException;

    public abstract void beginObject() throws IOException;

    public abstract void endObject() throws IOException;

    public abstract boolean hasNext() throws IOException;

    public abstract Token peek() throws IOException;

    public abstract String nextName() throws IOException;

    public abstract int selectName(Options var1) throws IOException;

    public abstract String nextString() throws IOException;

    public abstract int selectString(Options var1) throws IOException;

    public abstract boolean nextBoolean() throws IOException;

    @Nullable
    public abstract <T> T nextNull() throws IOException;

    public abstract double nextDouble() throws IOException;

    public abstract long nextLong() throws IOException;

    public abstract int nextInt() throws IOException;

    public abstract void skipValue() throws IOException;

    @Nullable
    public final Object readJsonValue() throws IOException {
        switch (this.peek()) {
            case BEGIN_ARRAY: {
                ArrayList<Object> list = new ArrayList<Object>();
                this.beginArray();
                while (this.hasNext()) {
                    list.add(this.readJsonValue());
                }
                this.endArray();
                return list;
            }
            case BEGIN_OBJECT: {
                LinkedHashTreeMap<String, Object> map = new LinkedHashTreeMap<String, Object>();
                this.beginObject();
                while (this.hasNext()) {
                    Object value;
                    String name = this.nextName();
                    Object replaced = map.put(name, value = this.readJsonValue());
                    if (replaced == null) continue;
                    throw new JsonDataException("Map key '" + name + "' has multiple values at path " + this.getPath() + ": " + replaced + " and " + value);
                }
                this.endObject();
                return map;
            }
            case STRING: {
                return this.nextString();
            }
            case NUMBER: {
                return this.nextDouble();
            }
            case BOOLEAN: {
                return this.nextBoolean();
            }
            case NULL: {
                return this.nextNull();
            }
        }
        throw new IllegalStateException("Expected a value but was " + (Object)((Object)this.peek()) + " at path " + this.getPath());
    }

    public final String getPath() {
        return JsonScope.getPath(this.stackSize, this.scopes, this.pathNames, this.pathIndices);
    }

    abstract void promoteNameToValue() throws IOException;

    public static enum Token {
        BEGIN_ARRAY,
        END_ARRAY,
        BEGIN_OBJECT,
        END_OBJECT,
        NAME,
        STRING,
        NUMBER,
        BOOLEAN,
        NULL,
        END_DOCUMENT;

    }

    public static final class Options {
        final String[] strings;
        final org.apache.kylin.shaded.influxdb.okio.Options doubleQuoteSuffix;

        private Options(String[] strings, org.apache.kylin.shaded.influxdb.okio.Options doubleQuoteSuffix) {
            this.strings = strings;
            this.doubleQuoteSuffix = doubleQuoteSuffix;
        }

        public static Options of(String ... strings) {
            try {
                ByteString[] result = new ByteString[strings.length];
                Buffer buffer = new Buffer();
                for (int i = 0; i < strings.length; ++i) {
                    JsonUtf8Writer.string(buffer, strings[i]);
                    buffer.readByte();
                    result[i] = buffer.readByteString();
                }
                return new Options((String[])strings.clone(), org.apache.kylin.shaded.influxdb.okio.Options.of(result));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

