/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.List;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.builders.NoopValidator;
import springfox.documentation.builders.OAuth2SchemeValidator;
import springfox.documentation.builders.ValidationResult;
import springfox.documentation.builders.Validator;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.OAuth2Scheme;
import springfox.documentation.service.VendorExtension;

public class OAuth2SchemeBuilder {
    String name;
    String flowType;
    String description;
    String authorizationUrl;
    String tokenUrl;
    String refreshUrl;
    final List<AuthorizationScope> scopes = new ArrayList<AuthorizationScope>();
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();
    private Validator<OAuth2SchemeBuilder> validator = new OAuth2SchemeValidator();

    public OAuth2SchemeBuilder(String flowType) {
        this.flowType = flowType;
    }

    public OAuth2SchemeBuilder name(String name) {
        this.name = name;
        return this;
    }

    public OAuth2SchemeBuilder description(String description) {
        this.description = description;
        return this;
    }

    public OAuth2SchemeBuilder authorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
        return this;
    }

    public OAuth2SchemeBuilder tokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return this;
    }

    public OAuth2SchemeBuilder refreshUrl(String refreshUrl) {
        this.refreshUrl = refreshUrl;
        return this;
    }

    public OAuth2SchemeBuilder scopes(List<AuthorizationScope> scopes) {
        this.scopes.addAll(BuilderDefaults.nullToEmptyList(scopes));
        return this;
    }

    public OAuth2SchemeBuilder extensions(List<VendorExtension> extensions) {
        this.extensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public OAuth2SchemeBuilder validator(Validator<OAuth2SchemeBuilder> validator) {
        this.validator = validator;
        return this;
    }

    public OAuth2Scheme build() {
        List<ValidationResult> results = this.validator.validate(this);
        if (NoopValidator.logProblems(results).size() > 0) {
            return null;
        }
        return new OAuth2Scheme(this.name, this.flowType, this.description, this.authorizationUrl, this.tokenUrl, this.refreshUrl, this.scopes, this.extensions);
    }
}

