/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.jackson.datatype.guava;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import java.io.Serializable;
import org.apache.kylin.guava30.shaded.common.base.Optional;
import org.apache.kylin.guava30.shaded.common.collect.ArrayListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.BoundType;
import org.apache.kylin.guava30.shaded.common.collect.EnumBiMap;
import org.apache.kylin.guava30.shaded.common.collect.EnumHashBiMap;
import org.apache.kylin.guava30.shaded.common.collect.EnumMultiset;
import org.apache.kylin.guava30.shaded.common.collect.ForwardingListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ForwardingSetMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ForwardingSortedSetMultimap;
import org.apache.kylin.guava30.shaded.common.collect.HashBiMap;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.HashMultiset;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableCollection;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMultiset;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSetMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSortedMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSortedMultiset;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSortedSet;
import org.apache.kylin.guava30.shaded.common.collect.LinkedHashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.LinkedHashMultiset;
import org.apache.kylin.guava30.shaded.common.collect.LinkedListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ListMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.apache.kylin.guava30.shaded.common.collect.Multiset;
import org.apache.kylin.guava30.shaded.common.collect.Range;
import org.apache.kylin.guava30.shaded.common.collect.RangeSet;
import org.apache.kylin.guava30.shaded.common.collect.SetMultimap;
import org.apache.kylin.guava30.shaded.common.collect.SortedMultiset;
import org.apache.kylin.guava30.shaded.common.collect.SortedSetMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Table;
import org.apache.kylin.guava30.shaded.common.collect.TreeMultimap;
import org.apache.kylin.guava30.shaded.common.collect.TreeMultiset;
import org.apache.kylin.guava30.shaded.common.hash.HashCode;
import org.apache.kylin.guava30.shaded.common.net.HostAndPort;
import org.apache.kylin.guava30.shaded.common.net.InternetDomainName;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.GuavaOptionalDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.HashCodeDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.HashMultisetDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.HostAndPortDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.ImmutableBiMapDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.ImmutableListDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.ImmutableMapDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.ImmutableMultisetDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.ImmutableSetDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.ImmutableSortedMapDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.ImmutableSortedMultisetDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.ImmutableSortedSetDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.InternetDomainNameDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.LinkedHashMultisetDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.RangeDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.RangeSetDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.TreeMultisetDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.multimap.list.ArrayListMultimapDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.multimap.list.LinkedListMultimapDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.multimap.set.HashMultimapDeserializer;
import org.apache.kylin.shaded.jackson.datatype.guava.deser.multimap.set.LinkedHashMultimapDeserializer;

public class GuavaDeserializers
extends Deserializers.Base
implements Serializable {
    static final long serialVersionUID = 1L;
    protected BoundType _defaultBoundType;

    public GuavaDeserializers() {
        this(null);
    }

    public GuavaDeserializers(BoundType defaultBoundType) {
        this._defaultBoundType = defaultBoundType;
    }

    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (ImmutableCollection.class.isAssignableFrom(raw)) {
            if (ImmutableList.class.isAssignableFrom(raw)) {
                return new ImmutableListDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (ImmutableMultiset.class.isAssignableFrom(raw)) {
                if (ImmutableSortedMultiset.class.isAssignableFrom(raw)) {
                    this.requireCollectionOfComparableElements(type, "ImmutableSortedMultiset");
                    return new ImmutableSortedMultisetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
                }
                return new ImmutableMultisetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (ImmutableSet.class.isAssignableFrom(raw)) {
                if (ImmutableSortedSet.class.isAssignableFrom(raw)) {
                    this.requireCollectionOfComparableElements(type, "ImmutableSortedSet");
                    return new ImmutableSortedSetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
                }
                return new ImmutableSetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            return new ImmutableListDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
        }
        if (Multiset.class.isAssignableFrom(raw)) {
            if (SortedMultiset.class.isAssignableFrom(raw)) {
                if (TreeMultiset.class.isAssignableFrom(raw)) {
                    return new TreeMultisetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
                }
                return new TreeMultisetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (LinkedHashMultiset.class.isAssignableFrom(raw)) {
                return new LinkedHashMultisetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (HashMultiset.class.isAssignableFrom(raw)) {
                return new HashMultisetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
            }
            if (EnumMultiset.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new HashMultisetDeserializer((JavaType)type, elementDeserializer, elementTypeDeserializer, null, null);
        }
        return null;
    }

    private void requireCollectionOfComparableElements(CollectionType actualType, String targetType) {
        Class elemType = actualType.getContentType().getRawClass();
        if (!Comparable.class.isAssignableFrom(elemType)) {
            throw new IllegalArgumentException("Can not handle " + targetType + " with elements that are not Comparable<?> (" + elemType.getName() + ")");
        }
    }

    public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer valueTypeDeserializer, JsonDeserializer<?> valueDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (ImmutableMap.class.isAssignableFrom(raw)) {
            if (ImmutableSortedMap.class.isAssignableFrom(raw)) {
                return new ImmutableSortedMapDeserializer((JavaType)type, keyDeserializer, valueDeserializer, valueTypeDeserializer, null);
            }
            if (ImmutableBiMap.class.isAssignableFrom(raw)) {
                return new ImmutableBiMapDeserializer((JavaType)type, keyDeserializer, valueDeserializer, valueTypeDeserializer, null);
            }
            return new ImmutableMapDeserializer((JavaType)type, keyDeserializer, valueDeserializer, valueTypeDeserializer, null);
        }
        if (BiMap.class.isAssignableFrom(raw)) {
            if (EnumBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (EnumHashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (HashBiMap.class.isAssignableFrom(raw)) {
                // empty if block
            }
        }
        return null;
    }

    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        Class raw = type.getRawClass();
        if (ListMultimap.class.isAssignableFrom(raw)) {
            if (ImmutableListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            if (ArrayListMultimap.class.isAssignableFrom(raw)) {
                return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedListMultimap.class.isAssignableFrom(raw)) {
                return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ForwardingListMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new ArrayListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (SetMultimap.class.isAssignableFrom(raw)) {
            if (SortedSetMultimap.class.isAssignableFrom(raw)) {
                if (TreeMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
                if (ForwardingSortedSetMultimap.class.isAssignableFrom(raw)) {
                    // empty if block
                }
            }
            if (ImmutableSetMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (HashMultimap.class.isAssignableFrom(raw)) {
                return new HashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (LinkedHashMultimap.class.isAssignableFrom(raw)) {
                return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
            }
            if (ForwardingSetMultimap.class.isAssignableFrom(raw)) {
                // empty if block
            }
            return new LinkedHashMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Multimap.class.isAssignableFrom(raw)) {
            return new LinkedListMultimapDeserializer(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
        }
        if (Table.class.isAssignableFrom(raw)) {
            // empty if block
        }
        return null;
    }

    public JsonDeserializer<?> findReferenceDeserializer(ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) {
        if (refType.hasRawClass(Optional.class)) {
            return new GuavaOptionalDeserializer((JavaType)refType, null, contentTypeDeserializer, contentDeserializer);
        }
        return null;
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
        if (type.hasRawClass(RangeSet.class)) {
            return new RangeSetDeserializer();
        }
        if (type.hasRawClass(Range.class)) {
            return new RangeDeserializer(this._defaultBoundType, type);
        }
        if (type.hasRawClass(HostAndPort.class)) {
            return HostAndPortDeserializer.std;
        }
        if (type.hasRawClass(InternetDomainName.class)) {
            return InternetDomainNameDeserializer.std;
        }
        if (type.hasRawClass(HashCode.class)) {
            return HashCodeDeserializer.std;
        }
        return null;
    }

    public boolean hasDeserializerFor(DeserializationConfig config, Class<?> valueType) {
        if (valueType.getName().startsWith("org.apache.kylin.guava30.shaded.")) {
            return valueType == Optional.class || valueType == RangeSet.class || valueType == HostAndPort.class || valueType == InternetDomainName.class || valueType == HashCode.class || Multiset.class.isAssignableFrom(valueType) || Multimap.class.isAssignableFrom(valueType) || ImmutableCollection.class.isAssignableFrom(valueType) || ImmutableMap.class.isAssignableFrom(valueType) || BiMap.class.isAssignableFrom(valueType);
        }
        return false;
    }
}

