/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.actions;

import io.delta.standalone.actions.Action;
import io.delta.standalone.actions.Format;
import io.delta.standalone.types.StructType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Metadata
implements Action {
    @Nonnull
    private final String id;
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @Nonnull
    private final Format format;
    @Nonnull
    private final List<String> partitionColumns;
    @Nonnull
    private final Map<String, String> configuration;
    @Nonnull
    private final Optional<Long> createdTime;
    @Nullable
    private final StructType schema;

    public Metadata(@Nonnull String string, @Nullable String string2, @Nullable String string3, @Nonnull Format format, @Nonnull List<String> list, @Nonnull Map<String, String> map, @Nonnull Optional<Long> optional, @Nullable StructType structType) {
        this.id = string;
        this.name = string2;
        this.description = string3;
        this.format = format;
        this.partitionColumns = list;
        this.configuration = map;
        this.createdTime = optional;
        this.schema = structType;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public Format getFormat() {
        return this.format;
    }

    @Nonnull
    public List<String> getPartitionColumns() {
        return Collections.unmodifiableList(this.partitionColumns);
    }

    @Nonnull
    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    @Nonnull
    public Optional<Long> getCreatedTime() {
        return this.createdTime;
    }

    @Nullable
    public StructType getSchema() {
        return this.schema;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)object;
        return Objects.equals(this.id, metadata.id) && Objects.equals(this.name, metadata.name) && Objects.equals(this.description, metadata.description) && Objects.equals(this.format, metadata.format) && Objects.equals(this.partitionColumns, metadata.partitionColumns) && Objects.equals(this.configuration, metadata.configuration) && Objects.equals(this.createdTime, metadata.createdTime) && Objects.equals(this.schema, metadata.schema);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.format, this.partitionColumns, this.configuration, this.createdTime, this.schema);
    }

    public Builder copyBuilder() {
        return new Builder(this.id, this.name, this.description, this.format, this.partitionColumns, this.configuration, this.createdTime, this.schema);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nonnull
        private String id = UUID.randomUUID().toString();
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nonnull
        private Format format = new Format("parquet", Collections.emptyMap());
        @Nonnull
        private List<String> partitionColumns = Collections.emptyList();
        @Nonnull
        private Map<String, String> configuration = Collections.emptyMap();
        @Nonnull
        private Optional<Long> createdTime = Optional.of(System.currentTimeMillis());
        @Nullable
        private StructType schema;

        public Builder() {
        }

        private Builder(@Nonnull String string, @Nullable String string2, @Nullable String string3, @Nonnull Format format, @Nonnull List<String> list, @Nonnull Map<String, String> map, @Nonnull Optional<Long> optional, @Nullable StructType structType) {
            this.id = string;
            this.name = string2;
            this.description = string3;
            this.format = format;
            this.partitionColumns = list;
            this.configuration = map;
            this.createdTime = optional;
            this.schema = structType;
        }

        public Builder id(@Nonnull String string) {
            this.id = string;
            return this;
        }

        public Builder name(@Nullable String string) {
            this.name = string;
            return this;
        }

        public Builder description(@Nullable String string) {
            this.description = string;
            return this;
        }

        public Builder format(@Nonnull Format format) {
            this.format = format;
            return this;
        }

        public Builder partitionColumns(@Nonnull List<String> list) {
            this.partitionColumns = list;
            return this;
        }

        public Builder configuration(@Nonnull Map<String, String> map) {
            this.configuration = map;
            return this;
        }

        public Builder createdTime(Long l) {
            this.createdTime = Optional.of(l);
            return this;
        }

        public Builder createdTime(@Nonnull Optional<Long> optional) {
            this.createdTime = optional;
            return this;
        }

        public Builder schema(@Nullable StructType structType) {
            this.schema = structType;
            return this;
        }

        public Metadata build() {
            Metadata metadata = new Metadata(this.id, this.name, this.description, this.format, this.partitionColumns, this.configuration, this.createdTime, this.schema);
            return metadata;
        }
    }
}

