/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaVacuumStats;
import org.apache.spark.sql.delta.commands.VacuumCommand;
import org.apache.spark.sql.delta.commands.VacuumCommand$;
import org.apache.spark.sql.delta.commands.VacuumCommandImpl;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class VacuumCommand$
implements VacuumCommandImpl,
scala.Serializable {
    public static VacuumCommand$ MODULE$;
    private final Seq<String> org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new VacuumCommand$();
    }

    @Override
    public void logVacuumStart(SparkSession spark, DeltaLog deltaLog, Path path, Dataset<String> diff, long sizeOfDataToDelete, Option<Object> specifiedRetentionMillis, long defaultRetentionMillis) {
        VacuumCommandImpl.logVacuumStart$(this, spark, deltaLog, path, diff, sizeOfDataToDelete, specifiedRetentionMillis, defaultRetentionMillis);
    }

    @Override
    public void logVacuumEnd(DeltaLog deltaLog, SparkSession spark, Path path, Option<Object> filesDeleted, Option<Object> dirCounts) {
        VacuumCommandImpl.logVacuumEnd$(this, deltaLog, spark, path, filesDeleted, dirCounts);
    }

    @Override
    public Option<Object> logVacuumEnd$default$4() {
        return VacuumCommandImpl.logVacuumEnd$default$4$(this);
    }

    @Override
    public Option<Object> logVacuumEnd$default$5() {
        return VacuumCommandImpl.logVacuumEnd$default$5$(this);
    }

    @Override
    public String relativize(Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return VacuumCommandImpl.relativize$(this, path, fs, reservoirBase, isDir);
    }

    @Override
    public Iterator<String> getAllSubdirs(String base, String file, FileSystem fs) {
        return VacuumCommandImpl.getAllSubdirs$(this, base, file, fs);
    }

    @Override
    public long delete(Dataset<String> diff, SparkSession spark, String basePath, Broadcast<SerializableConfiguration> hadoopConf, boolean parallel, int parallelPartitions) {
        return VacuumCommandImpl.delete$(this, diff, spark, basePath, hadoopConf, parallel, parallelPartitions);
    }

    @Override
    public Path stringToPath(String path) {
        return VacuumCommandImpl.stringToPath$(this, path);
    }

    @Override
    public String pathToString(Path path) {
        return VacuumCommandImpl.pathToString$(this, path);
    }

    @Override
    public Option<String> getActionRelativePath(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError) {
        return VacuumCommandImpl.getActionRelativePath$(this, action, fs, basePath, relativizeIgnoreError);
    }

    @Override
    public Seq<String> getValidRelativePathsAndSubdirs(FileAction action, FileSystem fs, Path basePath, boolean relativizeIgnoreError, boolean isBloomFiltered) {
        return VacuumCommandImpl.getValidRelativePathsAndSubdirs$(this, action, fs, basePath, relativizeIgnoreError, isBloomFiltered);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Seq<String> org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging() {
        return this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$VacuumCommandImpl$_setter_$org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging_$eq(Seq<String> x$1) {
        this.org$apache$spark$sql$delta$commands$VacuumCommandImpl$$supportedFsForLogging = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void checkRetentionPeriodSafety(SparkSession spark, Option<Object> retentionMs, long configuredRetention) {
        Predef$.MODULE$.require(retentionMs.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 >= 0L), (Function0 & Serializable & scala.Serializable)() -> "Retention for Vacuum can't be less than 0.");
        boolean checkEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RETENTION_CHECK_ENABLED()));
        boolean retentionSafe = retentionMs.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 >= configuredRetention);
        LongRef configuredRetentionHours = LongRef.create((long)TimeUnit.MILLISECONDS.toHours(configuredRetention));
        if (TimeUnit.HOURS.toMillis(configuredRetentionHours.elem) < configuredRetention) {
            ++configuredRetentionHours.elem;
        }
        Predef$.MODULE$.require(!checkEnabled || retentionSafe, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(578).append("Are you sure you would like to vacuum files with such a low retention period? If you have\n        |writers that are currently writing to this table, there is a risk that you may corrupt the\n        |state of your Delta table.\n        |\n        |If you are certain that there are no operations being performed on this table, such as\n        |insert/upsert/delete/optimize, then you may turn off this check by setting:\n        |spark.databricks.delta.retentionDurationCheck.enabled = false\n        |\n        |If you are not sure, please use a value not less than \"").append(configuredRetentionHours$1.elem).append(" hours\".\n       ").toString())).stripMargin());
    }

    public Dataset<Row> gc(SparkSession spark, DeltaLog deltaLog, boolean dryRun, Option<Object> retentionHours, Clock clock) {
        Dataset dataset;
        Object object = new Object();
        try {
            dataset = (Dataset)this.recordDeltaOperation(deltaLog, "delta.gc", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                Dataset dataset;
                Path path = deltaLog.dataPath();
                Configuration deltaHadoopConf = deltaLog.newDeltaHadoopConf();
                FileSystem fs = path.getFileSystem(deltaHadoopConf);
                Snapshot snapshot = deltaLog.update(deltaLog.update$default$1(), deltaLog.update$default$2());
                Predef$.MODULE$.require(snapshot.version() >= 0L, (Function0 & Serializable & scala.Serializable)() -> "No state defined for this table. Is this really a Delta table? Refusing to garbage collect.");
                DeletionVectorUtils$.MODULE$.assertDeletionVectorsNotReadable(spark, snapshot.metadata(), snapshot.protocol());
                long snapshotTombstoneRetentionMillis = DeltaLog$.MODULE$.tombstoneRetentionMillis(snapshot.metadata());
                Option retentionMillis = retentionHours.map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)h -> TimeUnit.HOURS.toMillis(scala.math.package$.MODULE$.round(h)));
                MODULE$.checkRetentionPeriodSafety(spark, (Option<Object>)retentionMillis, snapshotTombstoneRetentionMillis);
                long deleteBeforeTimestamp = BoxesRunTime.unboxToLong((Object)retentionMillis.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)millis -> clock.getTimeMillis() - millis).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> snapshot.minFileRetentionTimestamp()));
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Starting garbage collection (dryRun = ").append(dryRun).append(") of untracked files older than ").append(new Date(deleteBeforeTimestamp).toGMTString()).append(" in ").append(path).toString());
                Broadcast hadoopConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(deltaHadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
                String basePath = fs.makeQualified(path).toString();
                BooleanRef isBloomFiltered = BooleanRef.create((boolean)false);
                boolean parallelDeleteEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_PARALLEL_DELETE_ENABLED()));
                int parallelDeletePartitions = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_PARALLEL_DELETE_PARALLELISM()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> spark.sessionState().conf().numShufflePartitions()));
                boolean relativizeIgnoreError = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RELATIVIZE_IGNORE_ERROR()));
                long startTimeToIdentifyEligibleFiles = System.currentTimeMillis();
                Dataset validFiles = snapshot.stateDS().mapPartitions((Function1 & Serializable & scala.Serializable)actions -> {
                    Path reservoirBase = new Path(basePath);
                    FileSystem fs = reservoirBase.getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
                    return actions.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                        Seq<String> seq;
                        RemoveFile removeFile;
                        Action action = x$3.unwrap();
                        if (action instanceof RemoveFile && (removeFile = (RemoveFile)action).delTimestamp() < deleteBeforeTimestamp) {
                            seq = Nil$.MODULE$;
                        } else if (action instanceof FileAction) {
                            FileAction fileAction = (FileAction)action;
                            seq = MODULE$.getValidRelativePathsAndSubdirs(fileAction, fs, reservoirBase, relativizeIgnoreError, isBloomFiltered$1.elem);
                        } else {
                            seq = Nil$.MODULE$;
                        }
                        return seq;
                    });
                }, org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"}));
                String[] partitionColumns = snapshot.metadata().partitionSchema().fieldNames();
                int parallelism = spark.sessionState().conf().parallelPartitionDiscoveryParallelism();
                Dataset allFilesAndDirs = DeltaFileOperations$.MODULE$.recursiveListDirs(spark, (Seq<String>)((Seq)new .colon.colon((Object)basePath, (List)Nil$.MODULE$)), (Broadcast<SerializableConfiguration>)hadoopConf, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.MODULE$.isHiddenDirectory((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])partitionColumns), x$4)), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.MODULE$.isHiddenDirectory((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])partitionColumns), x$5)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)parallelism)), DeltaFileOperations$.MODULE$.recursiveListDirs$default$7()).groupByKey((Function1 & Serializable & scala.Serializable)x$6 -> x$6.path(), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).mapGroups((Function2 & Serializable & scala.Serializable)(k, v) -> {
                    Seq duplicates = v.toSeq();
                    return (SerializableFileStatus)duplicates.maxBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.modificationTime()), (Ordering)Ordering.Long$.MODULE$);
                }, org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
                try {
                    long l;
                    allFilesAndDirs.cache();
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
                    public final class Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.sql.delta.commands.VacuumCommand.FileNameAndSize").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$1() {
                        }
                    }
                    Encoder fileNameAndSizeEncoder = Encoders$.MODULE$.product(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_commands_VacuumCommand$$typecreator1$1()));
                    long dirCounts = allFilesAndDirs.where(functions$.MODULE$.col("isDir")).count() + 1L;
                    Dataset diff = allFilesAndDirs.where(functions$.MODULE$.col("modificationTime").$less((Object)BoxesRunTime.boxToLong((long)deleteBeforeTimestamp)).$bar$bar((Object)functions$.MODULE$.col("isDir"))).mapPartitions((Function1 & Serializable & scala.Serializable)fileStatusIterator -> {
                        Path reservoirBase = new Path(basePath);
                        FileSystem fs = reservoirBase.getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
                        return fileStatusIterator.flatMap((Function1 & Serializable & scala.Serializable)fileStatus -> {
                            Iterator iterator;
                            if (fileStatus.isDir()) {
                                iterator = scala.package$.MODULE$.Iterator().single((Object)new VacuumCommand.FileNameAndSize(MODULE$.relativize(fileStatus.getHadoopPath(), fs, reservoirBase, true), 0L));
                            } else {
                                Iterator<String> dirs = MODULE$.getAllSubdirs(basePath, fileStatus.path(), fs);
                                Iterator dirsWithSlash = dirs.map((Function1 & Serializable & scala.Serializable)p -> {
                                    String relativizedPath = MODULE$.relativize(new Path(p), fs, reservoirBase, true);
                                    return new VacuumCommand.FileNameAndSize(relativizedPath, 0L);
                                });
                                iterator = dirsWithSlash.$plus$plus((Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VacuumCommand.FileNameAndSize[]{new VacuumCommand.FileNameAndSize(MODULE$.relativize(fileStatus.getHadoopPath(), fs, reservoirBase, false), fileStatus.length())})));
                            }
                            return iterator;
                        });
                    }, fileNameAndSizeEncoder).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("path")})).agg(functions$.MODULE$.count(new Column("*")).as("count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("length").as("length")})).join(validFiles, (Seq)new .colon.colon((Object)"path", (List)Nil$.MODULE$), "leftanti").where(functions$.MODULE$.col("count").$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                    Row sizeOfDataToDeleteRow = (Row)diff.agg(functions$.MODULE$.sum("length").cast("long"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).first();
                    long sizeOfDataToDelete = sizeOfDataToDeleteRow.isNullAt(0) ? 0L : sizeOfDataToDeleteRow.getLong(0);
                    Dataset diffFiles = diff.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("path")})).as(org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).map((Function1 & Serializable & scala.Serializable)relativePath -> {
                        Predef$.MODULE$.assert(!MODULE$.stringToPath((String)relativePath).isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> "Shouldn't have any absolute paths for deletion here.");
                        return MODULE$.pathToString(DeltaFileOperations$.MODULE$.absolutePath(basePath, (String)relativePath));
                    }, org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder());
                    long timeTakenToIdentifyEligibleFiles = System.currentTimeMillis() - startTimeToIdentifyEligibleFiles;
                    long numFiles = diffFiles.count();
                    if (dryRun) {
                        DeltaVacuumStats stats = new DeltaVacuumStats(true, (Option<Object>)retentionMillis, snapshotTombstoneRetentionMillis, deleteBeforeTimestamp, dirCounts, numFiles, sizeOfDataToDelete, timeTakenToIdentifyEligibleFiles, 0L);
                        DeltaLog x$1 = deltaLog;
                        String x$2 = "delta.gc.stats";
                        DeltaVacuumStats x$3 = stats;
                        Map<TagDefinition, String> x$42 = MODULE$.recordDeltaEvent$default$3();
                        Option<Path> x$52 = MODULE$.recordDeltaEvent$default$5();
                        MODULE$.recordDeltaEvent(x$1, x$2, x$42, x$3, x$52);
                        MODULE$.logConsole(new StringBuilder(89).append("Found ").append(numFiles).append(" files (").append(sizeOfDataToDelete).append(" bytes) and directories in ").append("a total of ").append(dirCounts).append(" directories that are safe to delete.").toString());
                        throw new NonLocalReturnControl(object, (Object)diffFiles.map((Function1 & Serializable & scala.Serializable)f -> MODULE$.stringToPath((String)f).toString(), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"})));
                    }
                    MODULE$.logVacuumStart(spark, deltaLog, path, (Dataset<String>)diffFiles, sizeOfDataToDelete, (Option<Object>)retentionMillis, snapshotTombstoneRetentionMillis);
                    long deleteStartTime = System.currentTimeMillis();
                    try {
                        l = MODULE$.delete((Dataset<String>)diffFiles, spark, basePath, (Broadcast<SerializableConfiguration>)hadoopConf, parallelDeleteEnabled, parallelDeletePartitions);
                    }
                    catch (Throwable t) {
                        MODULE$.logVacuumEnd(deltaLog, spark, path, MODULE$.logVacuumEnd$default$4(), MODULE$.logVacuumEnd$default$5());
                        throw t;
                    }
                    long filesDeleted = l;
                    long timeTakenForDelete = System.currentTimeMillis() - deleteStartTime;
                    DeltaVacuumStats stats = new DeltaVacuumStats(false, (Option<Object>)retentionMillis, snapshotTombstoneRetentionMillis, deleteBeforeTimestamp, dirCounts, filesDeleted, sizeOfDataToDelete, timeTakenToIdentifyEligibleFiles, timeTakenForDelete);
                    DeltaLog x$62 = deltaLog;
                    String x$7 = "delta.gc.stats";
                    DeltaVacuumStats x$8 = stats;
                    Map<TagDefinition, String> x$9 = MODULE$.recordDeltaEvent$default$3();
                    Option<Path> x$10 = MODULE$.recordDeltaEvent$default$5();
                    MODULE$.recordDeltaEvent(x$62, x$7, x$9, x$8, x$10);
                    MODULE$.logVacuumEnd(deltaLog, spark, path, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)filesDeleted)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)dirCounts)));
                    dataset = spark.createDataset((Seq)new .colon.colon((Object)basePath, (List)Nil$.MODULE$), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"}));
                }
                finally {
                    allFilesAndDirs.unpersist();
                }
                return dataset;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                dataset = (Dataset)ex.value();
            }
            throw ex;
        }
        return dataset;
    }

    public boolean gc$default$3() {
        return true;
    }

    public Option<Object> gc$default$4() {
        return None$.MODULE$;
    }

    public Clock gc$default$5() {
        return new SystemClock();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private VacuumCommand$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        VacuumCommandImpl.$init$(this);
    }
}

