/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.sql.JDBCType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.TableExpression;
import org.mybatis.dynamic.sql.TableExpressionVisitor;

public class SqlTable
implements TableExpression {
    protected Supplier<String> nameSupplier;

    protected SqlTable(String tableName) {
        Objects.requireNonNull(tableName);
        this.nameSupplier = () -> tableName;
    }

    @Deprecated
    protected SqlTable(Supplier<String> tableNameSupplier) {
        Objects.requireNonNull(tableNameSupplier);
        this.nameSupplier = tableNameSupplier;
    }

    @Deprecated
    protected SqlTable(Supplier<Optional<String>> schemaSupplier, String tableName) {
        this(Optional::empty, schemaSupplier, tableName);
    }

    @Deprecated
    protected SqlTable(Supplier<Optional<String>> catalogSupplier, Supplier<Optional<String>> schemaSupplier, String tableName) {
        Objects.requireNonNull(catalogSupplier);
        Objects.requireNonNull(schemaSupplier);
        Objects.requireNonNull(tableName);
        this.nameSupplier = () -> this.compose(catalogSupplier, schemaSupplier, tableName);
    }

    private String compose(Supplier<Optional<String>> catalogSupplier, Supplier<Optional<String>> schemaSupplier, String tableName) {
        return catalogSupplier.get().map(c -> this.compose((String)c, schemaSupplier, tableName)).orElseGet(() -> this.compose(schemaSupplier, tableName));
    }

    private String compose(String catalog, Supplier<Optional<String>> schemaSupplier, String tableName) {
        return schemaSupplier.get().map(s -> this.composeCatalogSchemaAndTable(catalog, (String)s, tableName)).orElseGet(() -> this.composeCatalogAndTable(catalog, tableName));
    }

    private String compose(Supplier<Optional<String>> schemaSupplier, String tableName) {
        return schemaSupplier.get().map(s -> this.composeSchemaAndTable((String)s, tableName)).orElse(tableName);
    }

    private String composeCatalogAndTable(String catalog, String tableName) {
        return catalog + ".." + tableName;
    }

    private String composeSchemaAndTable(String schema, String tableName) {
        return schema + "." + tableName;
    }

    private String composeCatalogSchemaAndTable(String catalog, String schema, String tableName) {
        return catalog + "." + schema + "." + tableName;
    }

    public String tableNameAtRuntime() {
        return this.nameSupplier.get();
    }

    public BasicColumn allColumns() {
        return SqlColumn.of("*", this);
    }

    @NotNull
    public <T> SqlColumn<T> column(String name) {
        return SqlColumn.of(name, this);
    }

    @NotNull
    public <T> SqlColumn<T> column(String name, JDBCType jdbcType) {
        return SqlColumn.of(name, this, jdbcType);
    }

    @NotNull
    public <T> SqlColumn<T> column(String name, JDBCType jdbcType, String typeHandler) {
        SqlColumn column = SqlColumn.of(name, this, jdbcType);
        return column.withTypeHandler(typeHandler);
    }

    @Override
    public <R> R accept(TableExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public Optional<String> tableAlias() {
        return Optional.empty();
    }

    public static SqlTable of(String name) {
        return new SqlTable(name);
    }
}

