/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.util.Messages;

public class GroupByModel {
    private final List<BasicColumn> columns = new ArrayList<BasicColumn>();

    private GroupByModel(Collection<BasicColumn> columns) {
        Objects.requireNonNull(columns);
        if (columns.isEmpty()) {
            throw new InvalidSqlException(Messages.getString("ERROR.11"));
        }
        this.columns.addAll(columns);
    }

    public <R> Stream<R> mapColumns(Function<BasicColumn, R> mapper) {
        return this.columns.stream().map(mapper);
    }

    public static GroupByModel of(Collection<BasicColumn> columns) {
        return new GroupByModel(columns);
    }
}

