/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.function.AbstractUniTypeFunction;

public class Concat<T>
extends AbstractUniTypeFunction<T, Concat<T>> {
    private final List<BasicColumn> allColumns = new ArrayList<BasicColumn>();

    protected Concat(BindableColumn<T> firstColumn, List<BasicColumn> subsequentColumns) {
        super(firstColumn);
        this.allColumns.add(firstColumn);
        this.allColumns.addAll(subsequentColumns);
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return this.allColumns.stream().map(c -> c.renderWithTableAlias(tableAliasCalculator)).collect(Collectors.joining(", ", "concat(", ")"));
    }

    @Override
    protected Concat<T> copy() {
        return new Concat<T>(this.column, this.allColumns.subList(1, this.allColumns.size()));
    }

    public static <T> Concat<T> concat(BindableColumn<T> firstColumn, BasicColumn ... subsequentColumns) {
        return new Concat<T>(firstColumn, Arrays.asList(subsequentColumns));
    }

    public static <T> Concat<T> of(BindableColumn<T> firstColumn, List<BasicColumn> subsequentColumns) {
        return new Concat<T>(firstColumn, subsequentColumns);
    }
}

