/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.common.CommonBuilder;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.update.render.UpdateRenderer;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Messages;
import org.mybatis.dynamic.sql.where.WhereModel;

public class UpdateModel {
    private final SqlTable table;
    private final String tableAlias;
    private final WhereModel whereModel;
    private final List<AbstractColumnMapping> columnMappings;
    private final Long limit;
    private final OrderByModel orderByModel;

    private UpdateModel(Builder builder) {
        this.table = Objects.requireNonNull(builder.table());
        this.whereModel = builder.whereModel();
        this.columnMappings = Objects.requireNonNull(builder.columnMappings);
        this.tableAlias = builder.tableAlias();
        this.limit = builder.limit();
        this.orderByModel = builder.orderByModel();
        if (this.columnMappings.isEmpty()) {
            throw new InvalidSqlException(Messages.getString("ERROR.17"));
        }
    }

    public SqlTable table() {
        return this.table;
    }

    public Optional<String> tableAlias() {
        return Optional.ofNullable(this.tableAlias);
    }

    public Optional<WhereModel> whereModel() {
        return Optional.ofNullable(this.whereModel);
    }

    public <R> Stream<R> mapColumnMappings(Function<AbstractColumnMapping, R> mapper) {
        return this.columnMappings.stream().map(mapper);
    }

    public Optional<Long> limit() {
        return Optional.ofNullable(this.limit);
    }

    public Optional<OrderByModel> orderByModel() {
        return Optional.ofNullable(this.orderByModel);
    }

    @NotNull
    public UpdateStatementProvider render(RenderingStrategy renderingStrategy) {
        return UpdateRenderer.withUpdateModel(this).withRenderingStrategy(renderingStrategy).build().render();
    }

    public static Builder withTable(SqlTable table) {
        return (Builder)new Builder().withTable(table);
    }

    public static class Builder
    extends CommonBuilder<Builder> {
        private final List<AbstractColumnMapping> columnMappings = new ArrayList<AbstractColumnMapping>();

        public Builder withColumnMappings(List<AbstractColumnMapping> columnMappings) {
            this.columnMappings.addAll(columnMappings);
            return this;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public UpdateModel build() {
            return new UpdateModel(this);
        }
    }
}

