/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cache.fs;

import alluxio.client.file.FileInStream;
import alluxio.exception.ExceptionMessage;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class AlluxioHdfsFileInputStream
extends InputStream
implements Seekable,
PositionedReadable,
ByteBufferReadable {
    private static final Logger logger = LoggerFactory.getLogger(AlluxioHdfsFileInputStream.class);
    private final FileSystem.Statistics statistics;
    private final FileInStream fileInStream;
    private boolean streamClosed = false;

    public AlluxioHdfsFileInputStream(FileInStream inputStream, FileSystem.Statistics stats) {
        this.fileInStream = inputStream;
        this.statistics = stats;
    }

    @Override
    public int available() throws IOException {
        if (this.streamClosed) {
            throw new IOException("Cannot query available bytes from a closed stream.");
        }
        return (int)this.fileInStream.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        this.fileInStream.close();
        this.streamClosed = true;
    }

    public long getPos() throws IOException {
        return this.fileInStream.getPos();
    }

    @Override
    public int read() throws IOException {
        if (this.streamClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        int data = this.fileInStream.read();
        if (data != -1 && this.statistics != null) {
            this.statistics.incrementBytesRead(1L);
            logger.trace("Read one byte.");
        }
        return data;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.streamClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        int bytesRead = this.fileInStream.read(buffer, offset, length);
        if (bytesRead != -1 && this.statistics != null) {
            this.statistics.incrementBytesRead((long)bytesRead);
            logger.trace("Read {} bytes.", (Object)bytesRead);
        }
        return bytesRead;
    }

    public int read(ByteBuffer buf, int off, int len) throws IOException {
        byte[] b = new byte[buf.remaining()];
        int totalBytesRead = this.read(b, off, len);
        if (totalBytesRead == -1) {
            return -1;
        }
        buf.put(b, off, totalBytesRead);
        return totalBytesRead;
    }

    public int read(ByteBuffer buf) throws IOException {
        int bytesRead;
        if (this.streamClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        if (buf.hasArray() || !buf.isDirect()) {
            bytesRead = this.fileInStream.read(buf.array(), buf.position(), buf.remaining());
            if (bytesRead > 0) {
                buf.position(buf.position() + bytesRead);
            }
        } else {
            bytesRead = this.fileInStream.read(buf);
        }
        if (bytesRead != -1 && this.statistics != null) {
            this.statistics.incrementBytesRead((long)bytesRead);
            logger.trace("Read {} byte buffer {}.", (Object)bytesRead, (Object)buf.hasArray());
        }
        return bytesRead;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        if (this.streamClosed) {
            throw new IOException(ExceptionMessage.READ_CLOSED_STREAM.getMessage(new Object[0]));
        }
        int bytesRead = this.fileInStream.positionedRead(position, buffer, offset, length);
        if (bytesRead != -1 && this.statistics != null) {
            this.statistics.incrementBytesRead((long)bytesRead);
            logger.trace("Read {} {} byte buffer.", (Object)position, (Object)bytesRead);
        }
        return bytesRead;
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        int totalBytesRead;
        int bytesRead;
        for (totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
            bytesRead = this.read(position + (long)totalBytesRead, buffer, offset + totalBytesRead, length - totalBytesRead);
            if (bytesRead != -1) continue;
            throw new EOFException();
        }
        logger.trace("Read fully {} {} byte buffer.", (Object)position, (Object)totalBytesRead);
    }

    public void seek(long pos) throws IOException {
        try {
            this.fileInStream.seek(pos);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        throw new IOException(ExceptionMessage.NOT_SUPPORTED.getMessage(new Object[0]));
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Cannot skip bytes in a closed stream.");
        }
        return this.fileInStream.skip(n);
    }
}

