/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.fileseg;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.fileseg.FileSegments;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.metadata.model.FilePartitionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSegmentsDetector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSegmentsDetector.class);
    private static final ThreadLocal<FileSegmentsDetector> local = new ThreadLocal();
    private final String project;
    private boolean inited;
    private Map<String, Set<String>> findings;

    public static void startLocally(String project) {
        local.set(new FileSegmentsDetector(project));
    }

    public static void onObserveFileSystemListFileStatus(Path p, LocatedFileStatus[] content) {
        if (p == null || content == null) {
            return;
        }
        QueryContext queryContext = QueryContext.current();
        if (queryContext == null) {
            return;
        }
        FileSegmentsDetector detector = local.get();
        if (detector == null) {
            return;
        }
        detector._onObserveFileSystemListFileStatus(p, content);
    }

    public static void report(Consumer<Finding> findingConsumer) {
        FileSegmentsDetector detector = local.get();
        if (detector == null || findingConsumer == null) {
            return;
        }
        try {
            detector._report(findingConsumer);
        }
        catch (Exception ex) {
            log.error("Tolerate error reporting detected file segments", (Throwable)ex);
        }
    }

    public static void endLocally() {
        local.remove();
    }

    public FileSegmentsDetector(String project) {
        this.project = project;
    }

    private void lazyInit() {
        if (this.inited) {
            return;
        }
        this.findings = new HashMap<String, Set<String>>();
        this.inited = true;
    }

    private void _onObserveFileSystemListFileStatus(Path p, LocatedFileStatus[] content) {
        this.lazyInit();
        Set set = this.findings.computeIfAbsent(p.toString(), path -> new LinkedHashSet());
        for (LocatedFileStatus file : content) {
            set.add(FileSegments.computeFileHash((FileStatus)file));
        }
    }

    private void _report(Consumer<Finding> findingConsumer) {
        List<NDataModel> models = FileSegments.listModelsOfFileSeg(this.project);
        for (NDataModel model : models) {
            String loc = ((FilePartitionDesc)model.getPartitionDesc()).getFileStorageLocation();
            if (loc == null || !this.findings.containsKey(loc)) continue;
            Set<String> fileHashs = this.findings.get(loc);
            try {
                findingConsumer.accept(new Finding(this.project, model.getId(), loc, (List<String>)ImmutableList.copyOf(fileHashs)));
            }
            catch (Exception ex) {
                log.error("Tolerate error while model {} consuming detected file segments {}", new Object[]{this.project + "/" + model.getAlias(), fileHashs, ex});
            }
        }
    }

    public static class Finding {
        public final String project;
        public final String modelId;
        public final String storageLocation;
        public final List<String> fileHashs;

        @Generated
        public Finding(String project, String modelId, String storageLocation, List<String> fileHashs) {
            this.project = project;
            this.modelId = modelId;
            this.storageLocation = storageLocation;
            this.fileHashs = fileHashs;
        }
    }
}

