/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.engine.spark.job.BeforePartitionBuildExec;
import org.apache.kylin.engine.spark.job.BeforeSegmentBuildExec;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.ResourceDetect;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.step.ParamPropagation;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;

public class BeforeSegmentBuildJob
extends SegmentJob
implements ResourceDetect {
    public static void main(String[] args) {
        BeforeSegmentBuildJob segmentBuildJob = new BeforeSegmentBuildJob();
        segmentBuildJob.execute(args);
    }

    @Override
    protected final void doExecute() throws Exception {
        this.writeCountDistinct();
        if (this.isPartitioned()) {
            this.detectPartition();
        } else {
            this.detect();
        }
    }

    @Override
    protected void waitForResourceSuccess() {
    }

    private void detectPartition() throws IOException {
        for (NDataSegment dataSegment : this.readOnlySegments) {
            ParamPropagation params = new ParamPropagation();
            BeforePartitionBuildExec exec = new BeforePartitionBuildExec(this, dataSegment, params);
            exec.detectResource();
        }
    }

    private void detect() throws IOException {
        for (NDataSegment dataSegment : this.readOnlySegments) {
            ParamPropagation params = new ParamPropagation();
            BeforeSegmentBuildExec exec = new BeforeSegmentBuildExec(this, dataSegment, params);
            exec.detectResource();
        }
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.resourceDetectBeforeCubingJobInfo();
    }

    private void writeCountDistinct() {
        ResourceDetectUtils.write((Path)new Path(this.rdSharedPath, ResourceDetectUtils.countDistinctSuffix()), (Object)ResourceDetectUtils.findCountDistinctMeasure(this.getReadOnlyLayouts()));
    }
}

