/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildLayoutWithUpdate {
    protected static final Logger logger = LoggerFactory.getLogger(BuildLayoutWithUpdate.class);
    private static final int CHECK_POINT_DELAY_SEC = 5;
    private final ScheduledExecutorService checkPointer;
    private final LinkedBlockingQueue<LayoutPoint> layoutPoints;
    private ExecutorService pool = Executors.newCachedThreadPool();
    private CompletionService<JobResult> completionService = new ExecutorCompletionService<JobResult>(this.pool);
    private int currentLayoutsNum = 0;

    public BuildLayoutWithUpdate() {
        this.layoutPoints = new LinkedBlockingQueue();
        this.checkPointer = Executors.newSingleThreadScheduledExecutor();
        this.startCheckPoint();
    }

    public void submit(final JobEntity job, final KylinConfig config) {
        this.completionService.submit(new Callable<JobResult>(){

            @Override
            public JobResult call() throws Exception {
                KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)config);
                Thread.currentThread().setName("thread-" + job.getName());
                LinkedList<NDataLayout> nDataLayouts = new LinkedList();
                Throwable throwable = null;
                try {
                    nDataLayouts = job.build();
                }
                catch (Throwable t) {
                    logger.error("Error occurred when run " + job.getName(), t);
                    throwable = t;
                }
                return new JobResult(job.getIndexId(), nDataLayouts, throwable);
            }
        });
        ++this.currentLayoutsNum;
    }

    public void updateLayout(NDataSegment seg, KylinConfig config, String project) {
        for (int i = 0; i < this.currentLayoutsNum; ++i) {
            this.updateSingleLayout(seg, config, project);
        }
        this.doCheckPoint();
        this.currentLayoutsNum = 0;
    }

    public long updateSingleLayout(NDataSegment seg, KylinConfig config, String project) {
        long indexId = -1L;
        try {
            logger.info("Wait to take job result.");
            JobResult result = this.completionService.take().get();
            logger.info("Take job result successful.");
            if (result.isFailed()) {
                this.shutDown();
                throw new RuntimeException(result.getThrowable());
            }
            indexId = result.getIndexId();
            for (NDataLayout layout : result.getLayouts()) {
                logger.info("Update layout {} in dataflow {}, segment {}", new Object[]{layout.getLayoutId(), seg.getDataflow().getUuid(), seg.getId()});
                if (this.layoutPoints.offer(new LayoutPoint(project, config, seg.getDataflow().getId(), layout))) continue;
                throw new IllegalStateException("[UNLIKELY_THINGS_HAPPENED] Make sure that layoutPoints can offer.");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            this.shutDown();
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        this.doCheckPoint();
        return indexId;
    }

    private void startCheckPoint() {
        this.checkPointer.scheduleWithFixedDelay(this::doCheckPoint, 5L, 5L, TimeUnit.SECONDS);
    }

    private synchronized void doCheckPoint() {
        LayoutPoint lp = this.layoutPoints.poll();
        if (Objects.isNull(lp)) {
            return;
        }
        if (Objects.isNull(lp.getLayout())) {
            logger.warn("[LESS_LIKELY_THINGS_HAPPENED] layout shouldn't be empty.");
            return;
        }
        String project = lp.getProject();
        KylinConfig config = lp.getConfig();
        String dataFlowId = lp.getDataFlowId();
        ArrayList<NDataLayout> layouts = new ArrayList<NDataLayout>();
        layouts.add(lp.getLayout());
        StringBuilder sb = new StringBuilder("Checkpoint layouts: ").append(lp.getLayout().getLayoutId());
        while (Objects.nonNull(lp = this.layoutPoints.peek()) && Objects.equals(project, lp.getProject()) && Objects.equals(dataFlowId, lp.getDataFlowId()) && Objects.nonNull(lp.getLayout())) {
            layouts.add(lp.getLayout());
            sb.append(',').append(lp.getLayout().getLayoutId());
            LayoutPoint temp = (LayoutPoint)this.layoutPoints.remove();
            if (Objects.equals(lp, temp)) continue;
            throw new IllegalStateException("[UNLIKELY_THINGS_HAPPENED] Make sure that only one thread can execute layoutPoints poll.");
        }
        String layoutsLog = sb.toString();
        logger.info(layoutsLog);
        KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)config);
        this.updateLayouts(config, project, dataFlowId, layouts);
        if (Objects.nonNull(this.layoutPoints.peek())) {
            this.doCheckPoint();
        }
    }

    protected void updateLayouts(KylinConfig config, String project, String dataFlowId, List<NDataLayout> layouts) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflowUpdate update = new NDataflowUpdate(dataFlowId);
            update.setToAddOrUpdateLayouts(layouts.toArray(new NDataLayout[0]));
            NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).updateDataflow(update);
            return 0;
        }, (String)project);
    }

    public void shutDown() {
        this.pool.shutdown();
        try {
            this.pool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Error occurred when shutdown thread pool.", (Throwable)e);
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.pool);
            Thread.currentThread().interrupt();
        }
        this.checkPointer.shutdown();
        try {
            this.checkPointer.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("Error occurred when shutdown checkPointer.", (Throwable)e);
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.checkPointer);
            Thread.currentThread().interrupt();
        }
    }

    public static abstract class JobEntity {
        public abstract long getIndexId();

        public abstract String getName();

        public abstract List<NDataLayout> build() throws IOException;
    }

    private static class JobResult {
        private long indexId;
        private List<NDataLayout> layouts;
        private Throwable throwable;

        JobResult(long indexId, List<NDataLayout> layouts, Throwable throwable) {
            this.indexId = indexId;
            this.layouts = layouts;
            this.throwable = throwable;
        }

        boolean isFailed() {
            return this.throwable != null;
        }

        Throwable getThrowable() {
            return this.throwable;
        }

        long getIndexId() {
            return this.indexId;
        }

        List<NDataLayout> getLayouts() {
            return this.layouts;
        }
    }

    private static class LayoutPoint {
        private final String project;
        private final KylinConfig config;
        private final String dataFlowId;
        private final NDataLayout layout;

        public LayoutPoint(String project, KylinConfig config, String dataFlowId, NDataLayout layout) {
            this.project = project;
            this.config = config;
            this.dataFlowId = dataFlowId;
            this.layout = layout;
        }

        public String getProject() {
            return this.project;
        }

        public KylinConfig getConfig() {
            return this.config;
        }

        public String getDataFlowId() {
            return this.dataFlowId;
        }

        public NDataLayout getLayout() {
            return this.layout;
        }
    }
}

