/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoadCacheStep
extends AbstractExecutable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoadCacheStep.class);
    private static final String CACHE_API = "/kylin/api/jobs/gluten_cache";

    protected LoadCacheStep() {
        this.setName("Load Gluten Cache");
    }

    protected LoadCacheStep(Object notSetId) {
        super(notSetId);
    }

    public void routeCacheToAllQueryNode(String project, Set<String> cacheCommand) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isUTEnv()) {
            return;
        }
        String localInstance = AddressUtil.getLocalInstance();
        String requestApi = String.format(Locale.ROOT, "http://%s%s", localInstance, CACHE_API);
        HashMap request = Maps.newHashMap();
        request.put("project", project);
        request.put("cache_commands", cacheCommand);
        byte[] requestEntity = JsonUtil.writeValueAsBytes((Object)request);
        int timeout = config.getGlutenCacheRequestTimeout();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setStaleConnectionCheckEnabled(true).build();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultRequestConfig(defaultRequestConfig).build();
        HttpPost httpPost = new HttpPost(requestApi);
        httpPost.addHeader("Content-Type", "application/vnd.apache.kylin-v4+json");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(requestEntity, ContentType.APPLICATION_JSON));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        byte[] content = EntityUtils.toByteArray((HttpEntity)httpResponse.getEntity());
        if (content != null) {
            EnvelopeResponse response = (EnvelopeResponse)JsonUtil.readValue((byte[])content, EnvelopeResponse.class);
            if (!StringUtils.equals((CharSequence)response.getCode(), (CharSequence)"000")) {
                throw new KylinRuntimeException(String.format(Locale.ROOT, "route cache request has error, message is [%s]", response.getMsg()));
            }
            boolean result = (Boolean)response.getData();
            if (result) {
                return;
            }
            throw new KylinRuntimeException("route cache has error, some query node cache failed");
        }
        throw new KylinRuntimeException("route cache request has error, response body is empty");
    }
}

