/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.builder.CreateFlatTable$;
import org.apache.kylin.engine.spark.job.TableAnalyzeJob;
import org.apache.kylin.engine.spark.job.TableMetaManager$;
import org.apache.kylin.engine.spark.source.SparkSqlUtil;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.source.SourceFactory;
import org.apache.spark.SparkConf;
import org.apache.spark.application.NoRetryException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameEnhancement$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\b\u0010\u0001qA\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!i\u0005A!A!\u0002\u00139\u0004\"\u0002(\u0001\t\u0003y\u0005bB,\u0001\u0005\u0004%\t\u0001\u0017\u0005\u00079\u0002\u0001\u000b\u0011B-\t\u000bu\u0003A\u0011\u00010\t\u000b\u0015\u0004A\u0011\u00014\t\u000b\u0015\u0004A\u0011A6\t\u000b9\u0004A\u0011A8\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\t\u0001B+\u00192mK\u0006s\u0017\r\\={K\u0016CXm\u0019\u0006\u0003!E\t1A[8c\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051QM\\4j]\u0016T!AF\f\u0002\u000b-LH.\u001b8\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\u0011\u0001Qd\t\u0014\u0011\u0005y\tS\"A\u0010\u000b\u0003\u0001\nQa]2bY\u0006L!AI\u0010\u0003\r\u0005s\u0017PU3g!\tqB%\u0003\u0002&?\ta1+\u001a:jC2L'0\u00192mKB\u0011qeK\u0007\u0002Q)\u0011\u0011FK\u0001\tS:$XM\u001d8bY*\u0011!cF\u0005\u0003Y!\u0012q\u0001T8hO&tw-A\u0005uC\ndW\rR3tGB\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0006[>$W\r\u001c\u0006\u0003gU\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0003kA\u0012\u0011\u0002V1cY\u0016$Um]2\u0002\u000fA\u0014xN[3diB\u0011\u0001h\u0010\b\u0003su\u0002\"AO\u0010\u000e\u0003mR!\u0001P\u000e\u0002\rq\u0012xn\u001c;?\u0013\tqt$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001  \u0003!\u0011xn^\"pk:$\bC\u0001\u0010E\u0013\t)uD\u0001\u0003M_:<\u0017AA:t!\tA5*D\u0001J\u0015\tQ%&A\u0002tc2L!\u0001T%\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u000b)|'-\u00133\u0002\rqJg.\u001b;?)\u0019\u0001&k\u0015+V-B\u0011\u0011\u000bA\u0007\u0002\u001f!)QF\u0002a\u0001]!)aG\u0002a\u0001o!)!I\u0002a\u0001\u0007\")aI\u0002a\u0001\u000f\")QJ\u0002a\u0001o\u0005QA/Y:l\r\u0006\u001cGo\u001c:\u0016\u0003e\u0003\"A\b.\n\u0005m{\"aA%oi\u0006YA/Y:l\r\u0006\u001cGo\u001c:!\u00031\tg.\u00197zu\u0016$\u0016M\u00197f)\u0005y\u0006c\u0001\u0010aE&\u0011\u0011m\b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0011\u000eL!\u0001Z%\u0003\u0007I{w/\u0001\u000edC2\u001cW\u000f\\1uKZKWm^'fi\u0006\u001c\u0018J\u001a(fK\u0012,G\r\u0006\u0002hUB\u0011a\u0004[\u0005\u0003S~\u0011A!\u00168ji\")QF\u0003a\u0001]Q\u0011q\r\u001c\u0005\u0006[.\u0001\raN\u0001\ni\u0006\u0014G.\u001a(b[\u0016\f\u0001CY;jY\u0012\u001cF/\u0019;t\u001b\u0016$(/[2\u0015\u0005Ad\bcA9ws:\u0011!\u000f\u001e\b\u0003uML\u0011\u0001I\u0005\u0003k~\tq\u0001]1dW\u0006<W-\u0003\u0002xq\n!A*[:u\u0015\t)x\u0004\u0005\u0002Iu&\u001110\u0013\u0002\u0007\u0007>dW/\u001c8\t\u000bud\u0001\u0019\u0001@\u0002\u0017M|WO]2f)\u0006\u0014G.\u001a\t\u0004\u0011~\u0014\u0017bAA\u0001\u0013\n9A)\u0019;bg\u0016$\u0018\u0001D2iK\u000e\\7i\u001c7v[:\u001cHCBA\u0004\u0003\u001b\ty\u0001E\u0002\u001f\u0003\u0013I1!a\u0003 \u0005\u001d\u0011un\u001c7fC:DQ!L\u0007A\u00029Ba!!\u0005\u000e\u0001\u0004q\u0018A\u00013t\u0001")
public class TableAnalyzeExec
implements scala.Serializable,
Logging {
    private final TableDesc tableDesc;
    private final long rowCount;
    private final SparkSession ss;
    private final int taskFactor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int taskFactor() {
        return this.taskFactor;
    }

    public Row[] analyzeTable() {
        SparkConf sparkConf = this.ss.sparkContext().getConf();
        int instances = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.instances", "1"))).toInt();
        int cores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.cores", "1"))).toInt();
        int numPartitions = instances * cores;
        long rowsTakenInEachPartition = this.rowCount / (long)numPartitions;
        Map params = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(this.tableDesc.getProject()).getLegalOverrideKylinProps();
        params.put("sampleRowCount", String.valueOf(this.rowCount));
        Dataset dataFrame = ((NSparkCubingEngine.NSparkCubingSource)SourceFactory.createEngineAdapter((ISourceAware)this.tableDesc, NSparkCubingEngine.NSparkCubingSource.class)).getSourceData(this.tableDesc, this.ss, params).coalesce(numPartitions);
        if (!this.checkColumns(this.tableDesc, (Dataset<Row>)dataFrame)) {
            throw new NoRetryException("Source table missing columns. Please reload table before sampling.");
        }
        this.calculateViewMetasIfNeeded(this.tableDesc);
        Dataset dat = DataFrameEnhancement$.MODULE$.Functions(dataFrame).localLimit(rowsTakenInEachPartition);
        Dataset<Row> sampledDataset = CreateFlatTable$.MODULE$.changeSchemaToAliasDotName((Dataset<Row>)dat, this.tableDesc.getBackTickIdentity());
        List<Column> statsMetrics = this.buildStatsMetric(sampledDataset);
        Row[] aggData = (Row[])sampledDataset.agg(functions$.MODULE$.count(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))), statsMetrics).collect();
        return (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggData)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampledDataset.limit(10).collect())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
    }

    public void calculateViewMetasIfNeeded(TableDesc tableDesc) {
        String tableName = tableDesc.getBackTickIdentity();
        if (tableDesc.getSourceType() == 8) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Table [").append(tableName).append("] sourceType is JDBC, skip to calculate view meta").toString());
            return;
        }
        this.calculateViewMetasIfNeeded(tableName);
    }

    public void calculateViewMetasIfNeeded(String tableName) {
        block1: {
            Set<String> tables;
            String string = this.ss.conf().get("spark.sql.catalogImplementation");
            String string2 = "hive";
            if ((string != null ? !string.equals(string2) : string2 != null) || !this.ss.catalog().tableExists(tableName)) break block1;
            Table sparkTable = this.ss.catalog().getTable(tableName);
            String string3 = sparkTable.tableType();
            String string4 = CatalogTableType$.MODULE$.VIEW().name();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(tables = SparkSqlUtil.getViewOrignalTables(tableName, this.ss)).asScala()).size() > 1) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tables).asScala()).foreach((Function1 & Serializable & scala.Serializable)t -> {
                    TableAnalyzeExec.$anonfun$calculateViewMetasIfNeeded$2(this, sparkTable, t);
                    return BoxedUnit.UNIT;
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Table type ").append(sparkTable.tableType()).append(", orignal table num is ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(tables).asScala()).size()).toString());
            }
        }
    }

    public List<Column> buildStatsMetric(Dataset<Row> sourceTable) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceTable.schema().fieldNames())).flatMap((Function1 & Serializable & scala.Serializable)name -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(TableAnalyzeJob.TABLE_STATS_METRICS.toArray()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Column column;
            Object object = x0$1;
            if ("COUNT".equals(object)) {
                column = functions$.MODULE$.count(functions$.MODULE$.col(name));
            } else if ("COUNT_DISTINCT".equals(object)) {
                column = functions$.MODULE$.approx_count_distinct(functions$.MODULE$.col(name));
            } else if ("MAX".equals(object)) {
                column = functions$.MODULE$.max(functions$.MODULE$.col(name));
            } else if ("MIN".equals(object)) {
                column = functions$.MODULE$.min(functions$.MODULE$.col(name));
            } else {
                throw new IllegalArgumentException("Unsupported metric in TableSampling ");
            }
            return column;
        }, Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).toList();
    }

    public boolean checkColumns(TableDesc tableDesc, Dataset<Row> ds) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Check columns for table ").append(tableDesc.getIdentity()).toString());
        scala.collection.immutable.Set sourceColumnSet = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.columns())).map((Function1 & Serializable & scala.Serializable)col -> col.toUpperCase(Locale.ROOT), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        scala.collection.mutable.Set nonExistColumns = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableDesc.getColumns())).foreach((Function1 & Serializable & scala.Serializable)col -> !col.isComputedColumn() && !sourceColumnSet.contains((Object)col.getName()) ? BoxesRunTime.boxToBoolean((boolean)nonExistColumns.add((Object)col.getName())) : BoxedUnit.UNIT);
        if (nonExistColumns.nonEmpty()) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Check columns for table ").append(tableDesc.getIdentity()).append(" failed, missing following columns: ").append(nonExistColumns).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Check columns for table ").append(tableDesc.getIdentity()).append(" good").toString());
        }
        return nonExistColumns.isEmpty();
    }

    public static final /* synthetic */ void $anonfun$calculateViewMetasIfNeeded$2(TableAnalyzeExec $this, Table sparkTable$1, String t) {
        ObjectRef oriTable = ObjectRef.create((Object)t);
        if (!t.contains(".")) {
            oriTable.elem = new StringBuilder(1).append(sparkTable$1.database()).append(".").append(t).toString();
        }
        long rowCnt = $this.ss.table((String)oriTable.elem).count();
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Table ").append((String)oriTable$1.elem).append(" true number of rows is ").append(rowCnt).toString());
        TableMetaManager$.MODULE$.putTableMeta(t, 0L, rowCnt);
    }

    public TableAnalyzeExec(TableDesc tableDesc, String project, long rowCount, SparkSession ss, String jobId) {
        this.tableDesc = tableDesc;
        this.rowCount = rowCount;
        this.ss = ss;
        Logging.$init$((Logging)this);
        this.taskFactor = 4;
    }
}

