/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.step;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.job.step.StageExec;
import org.apache.kylin.guava30.shaded.common.util.concurrent.RateLimiter;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.spark.SparkConf;
import org.apache.spark.application.NoRetryException;
import org.apache.spark.internal.Logging;
import org.apache.spark.utils.ResourceUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194AAD\b\u0001=!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006C\u00031\u0001\u0011\u0005\u0011\u0007C\u00045\u0001\t\u0007I\u0011B\u001b\t\rq\u0002\u0001\u0015!\u00037\u0011\u001di\u0004A1A\u0005\nyBaa\u0011\u0001!\u0002\u0013y\u0004b\u0002#\u0001\u0005\u0004%I!\u0012\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002$\t\u000b1\u0003A\u0011I'\t\u000b9\u0003A\u0011I(\t\u000bm\u0003A\u0011\u0001/\t\u000b\u0001\u0004A\u0011I1\t\u000b\u0015\u0004A\u0011I(\u0003#I+7o\\;sG\u0016<\u0016-\u001b;Ti\u0006<WM\u0003\u0002\u0011#\u0005!1\u000f^3q\u0015\t\u00112#A\u0002k_\nT!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB3oO&tWM\u0003\u0002\u00193\u0005)1.\u001f7j]*\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0007\u0001\u00192\u0001A\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fMB\u0011aeJ\u0007\u0002\u001f%\u0011\u0001f\u0004\u0002\n'R\fw-Z#yK\u000e\f!B[8c\u0007>tG/\u001a=u!\tYc&D\u0001-\u0015\ti3#A\u0006baBd\u0017nY1uS>t\u0017BA\u0018-\u0005A\u0019\u0006/\u0019:l\u0003B\u0004H.[2bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003eM\u0002\"A\n\u0001\t\u000b%\u0012\u0001\u0019\u0001\u0016\u0002\r\r|gNZ5h+\u00051\u0004CA\u001c;\u001b\u0005A$BA\u001d\u0018\u0003\u0019\u0019w.\\7p]&\u00111\b\u000f\u0002\f\u0017fd\u0017N\\\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u0011\t,\u0018\u000e\u001c3F]Z,\u0012a\u0010\t\u0003\u0001\u0006k\u0011!E\u0005\u0003\u0005F\u0011QbS=mS:\u0014U/\u001b7e\u000b:4\u0018!\u00032vS2$WI\u001c<!\u0003%\u0019\b/\u0019:l\u0007>tg-F\u0001G!\t9\u0015*D\u0001I\u0015\t!\u0012$\u0003\u0002K\u0011\nI1\u000b]1sW\u000e{gNZ\u0001\u000bgB\f'o[\"p]\u001a\u0004\u0013!D4fi*{'mQ8oi\u0016DH/F\u0001+\u0003)9W\r^*uC\u001e,\u0017\nZ\u000b\u0002!B\u0011\u0011\u000b\u0017\b\u0003%Z\u0003\"aU\u0011\u000e\u0003QS!!V\u000f\u0002\rq\u0012xn\u001c;?\u0013\t9\u0016%\u0001\u0004Qe\u0016$WMZ\u0005\u00033j\u0013aa\u0015;sS:<'BA,\"\u0003EqW-\u001a3DQ\u0016\u001c7NU3t_V\u00148-Z\u000b\u0002;B\u0011\u0001EX\u0005\u0003?\u0006\u0012qAQ8pY\u0016\fg.A\u0004fq\u0016\u001cW\u000f^3\u0015\u0003\t\u0004\"\u0001I2\n\u0005\u0011\f#\u0001B+oSR\fAbZ3u'R\fw-\u001a(b[\u0016\u0004")
public class ResourceWaitStage
implements StageExec {
    private final SparkApplication jobContext;
    private final KylinConfig config;
    private final KylinBuildEnv buildEnv;
    private final SparkConf sparkConf;
    private String stageId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String getSegmentId() {
        return StageExec.getSegmentId$(this);
    }

    @Override
    public RateLimiter createRateLimiter(double permitsPerSecond) {
        return StageExec.createRateLimiter$(this, permitsPerSecond);
    }

    @Override
    public double createRateLimiter$default$1() {
        return StageExec.createRateLimiter$default$1$(this);
    }

    @Override
    public void onStageStart() {
        StageExec.onStageStart$(this);
    }

    @Override
    public void onStageFinished(ExecutableState state) {
        StageExec.onStageFinished$(this, state);
    }

    @Override
    public ExecutableState onStageFinished$default$1() {
        return StageExec.onStageFinished$default$1$(this);
    }

    @Override
    public void onStageSkipped() {
        StageExec.onStageSkipped$(this);
    }

    @Override
    public void updateStageInfo(String status, String errMsg, Map<String, String> updateInfo) {
        StageExec.updateStageInfo$(this, status, errMsg, updateInfo);
    }

    @Override
    public void setStageId(String stageId) {
        StageExec.setStageId$(this, stageId);
    }

    @Override
    public void doExecute() {
        StageExec.doExecute$(this);
    }

    @Override
    public void doExecuteWithoutFinally() {
        StageExec.doExecuteWithoutFinally$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String stageId() {
        return this.stageId;
    }

    @Override
    public void stageId_$eq(String x$1) {
        this.stageId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private KylinConfig config() {
        return this.config;
    }

    private KylinBuildEnv buildEnv() {
        return this.buildEnv;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    @Override
    public SparkApplication getJobContext() {
        return this.jobContext;
    }

    @Override
    public String getStageId() {
        String jobStepId = StringUtils.replace((String)this.buildEnv().buildJobInfos().getJobStepId(), (String)"job_step_", (String)"");
        return new StringBuilder(3).append(jobStepId).append("_00").toString();
    }

    public boolean needCheckResource() {
        return this.jobContext.isJobOnCluster(this.sparkConf()) && this.config().getWaitResourceEnabled();
    }

    @Override
    public void execute() {
        block8: {
            Tuple3 tuple3;
            Tuple3 tuple32;
            if (!this.needCheckResource()) break block8;
            long sleepSeconds = (long)(Math.random() * (double)60L);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Sleep ").append(sleepSeconds).append(" seconds to avoid submitting too many spark job at the same time.").toString());
            KylinBuildEnv$.MODULE$.get().buildJobInfos().startWait();
            Thread.sleep(sleepSeconds * 1000L);
            boolean checkEnabled = this.config().getCheckResourceEnabled();
            if (checkEnabled) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("CheckResource timeout limit was set: ").append(this.config().getCheckResourceTimeLimit()).append(" minutes.").toString());
                tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.convert(this.config().getCheckResourceTimeLimit(), TimeUnit.MINUTES)), (Object)BoxesRunTime.boxToLong((long)System.nanoTime()), (Object)BoxesRunTime.boxToLong((long)0L));
            } else {
                tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToLong((long)-1L));
            }
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            long timeoutLimitNs = BoxesRunTime.unboxToLong((Object)tuple3._1());
            long startTime = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long timeTaken = BoxesRunTime.unboxToLong((Object)tuple3._3());
            long l = timeoutLimitNs;
            long l2 = startTime;
            long l3 = timeTaken;
            Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToLong((long)l3));
            Tuple3 tuple34 = tuple33;
            long timeoutLimitNs2 = BoxesRunTime.unboxToLong((Object)tuple34._1());
            long startTime2 = BoxesRunTime.unboxToLong((Object)tuple34._2());
            long timeTaken2 = BoxesRunTime.unboxToLong((Object)tuple34._3());
            try {
                while (!ResourceUtils$.MODULE$.checkResource(this.sparkConf(), this.buildEnv().clusterManager(), this.config().isSkipResourceCheck())) {
                    if (checkEnabled && (timeTaken2 = System.nanoTime()) - startTime2 > timeoutLimitNs2) {
                        long timeout = TimeUnit.MINUTES.convert(timeTaken2 - startTime2, TimeUnit.NANOSECONDS);
                        throw new NoRetryException(new StringBuilder(45).append("CheckResource exceed timeout limit: ").append(timeout).append(" minutes.").toString());
                    }
                    long waitTime = (long)(Math.random() * (double)10 * (double)60);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Current available resource in cluster is not sufficient, wait ").append(waitTime).append(" seconds.").toString());
                    Thread.sleep(waitTime * 1000L);
                }
            }
            catch (NoRetryException e) {
                throw e;
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when check resource. Ignore it and try to submit this job.", e);
            }
            KylinBuildEnv$.MODULE$.get().buildJobInfos().endWait();
        }
    }

    @Override
    public String getStageName() {
        return "ResourceWaitStage";
    }

    public ResourceWaitStage(SparkApplication jobContext) {
        this.jobContext = jobContext;
        Logging.$init$((Logging)this);
        StageExec.$init$(this);
        this.config = jobContext.getConfig();
        this.buildEnv = KylinBuildEnv$.MODULE$.getOrCreate(this.config());
        this.sparkConf = this.buildEnv().sparkConf();
    }
}

