/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.flink.operation;

import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.RemoveJarOperation;
import org.apache.flink.table.operations.command.ResetOperation;
import org.apache.flink.table.operations.command.SetOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.kyuubi.engine.flink.FlinkEngineUtils$;
import org.apache.kyuubi.engine.flink.operation.FlinkOperation;
import org.apache.kyuubi.engine.flink.operation.OperationUtils$;
import org.apache.kyuubi.engine.flink.result.ResultSetUtil$;
import org.apache.kyuubi.operation.ExecutionMode$;
import org.apache.kyuubi.operation.ParseMode$;
import org.apache.kyuubi.operation.PhysicalMode$;
import org.apache.kyuubi.operation.PlanOnlyMode;
import org.apache.kyuubi.operation.PlanOnlyMode$;
import org.apache.kyuubi.operation.UnknownMode$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u3AAD\b\u00019!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005(\u0001\t\u0015\r\u0011\"\u0011)\u0011!1\u0004A!A!\u0002\u0013I\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u000bu\u0002A\u0011\u0001 \t\u000f\r\u0003!\u0019!C\u0005\t\"11\n\u0001Q\u0001\n\u0015Cq\u0001\u0014\u0001C\u0002\u0013%\u0001\u0006\u0003\u0004N\u0001\u0001\u0006I!\u000b\u0005\u0006\u001d\u0002!\te\u0014\u0005\u0006)\u0002!\t&\u0016\u0005\u00063\u0002!\t&\u0016\u0005\u00065\u0002!Ia\u0017\u0002\u0012!2\fgn\u00148msN#\u0018\r^3nK:$(B\u0001\t\u0012\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\u0013'\u0005)a\r\\5oW*\u0011A#F\u0001\u0007K:<\u0017N\\3\u000b\u0005Y9\u0012AB6zkV\u0014\u0017N\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<7\u0001A\n\u0003\u0001u\u0001\"AH\u0010\u000e\u0003=I!\u0001I\b\u0003\u001d\u0019c\u0017N\\6Pa\u0016\u0014\u0018\r^5p]\u000691/Z:tS>t\u0007CA\u0012&\u001b\u0005!#BA\u0011\u0016\u0013\t1CEA\u0004TKN\u001c\u0018n\u001c8\u0002\u0013M$\u0018\r^3nK:$X#A\u0015\u0011\u0005)\u001adBA\u00162!\tas&D\u0001.\u0015\tq3$\u0001\u0004=e>|GO\u0010\u0006\u0002a\u0005)1oY1mC&\u0011!gL\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023_\u0005Q1\u000f^1uK6,g\u000e\u001e\u0011\u0002\t5|G-\u001a\t\u0003smj\u0011A\u000f\u0006\u0003!UI!\u0001\u0010\u001e\u0003\u0019Ac\u0017M\\(oYflu\u000eZ3\u0002\rqJg.\u001b;?)\u0011y\u0004)\u0011\"\u0011\u0005y\u0001\u0001\"B\u0011\u0006\u0001\u0004\u0011\u0003\"B\u0014\u0006\u0001\u0004I\u0003\"B\u001c\u0006\u0001\u0004A\u0014\u0001D8qKJ\fG/[8o\u0019><W#A#\u0011\u0005\u0019KU\"A$\u000b\u0005!S\u0014a\u00017pO&\u0011!j\u0012\u0002\r\u001fB,'/\u0019;j_:dunZ\u0001\u000e_B,'/\u0019;j_:dun\u001a\u0011\u0002\u001b1Lg.Z*fa\u0006\u0014\u0018\r^8s\u00039a\u0017N\\3TKB\f'/\u0019;pe\u0002\nqbZ3u\u001fB,'/\u0019;j_:dunZ\u000b\u0002!B\u0019\u0011KU#\u000e\u0003=J!aU\u0018\u0003\r=\u0003H/[8o\u0003%\u0011WMZ8sKJ+h\u000eF\u0001W!\t\tv+\u0003\u0002Y_\t!QK\\5u\u0003-\u0011XO\\%oi\u0016\u0014h.\u00197\u0002!\u0015D\b\u000f\\1j]>\u0003XM]1uS>tGC\u0001,]\u0011\u00159S\u00021\u0001*\u0001")
public class PlanOnlyStatement
extends FlinkOperation {
    private final String statement;
    private final PlanOnlyMode mode;
    private final OperationLog operationLog;
    private final String lineSeparator;

    @Override
    public String statement() {
        return this.statement;
    }

    private OperationLog operationLog() {
        return this.operationLog;
    }

    private String lineSeparator() {
        return this.lineSeparator;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.operationLog());
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.operationLog());
        super.beforeRun();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runInternal() {
        try {
            Operation operation;
            Operation operation2 = operation = this.executor().parseStatement(this.sessionId(), this.statement());
            if (operation2 instanceof SetOperation) {
                SetOperation setOperation = (SetOperation)operation2;
                this.resultSet_$eq(OperationUtils$.MODULE$.runSetOperation(setOperation, this.executor(), this.sessionId()));
                return;
            }
            if (operation2 instanceof ResetOperation) {
                ResetOperation resetOperation = (ResetOperation)operation2;
                this.resultSet_$eq(OperationUtils$.MODULE$.runResetOperation(resetOperation, this.executor(), this.sessionId()));
                return;
            }
            if (operation2 instanceof AddJarOperation) {
                AddJarOperation addJarOperation = (AddJarOperation)operation2;
                if (FlinkEngineUtils$.MODULE$.isFlinkVersionAtMost("1.15")) {
                    this.resultSet_$eq(OperationUtils$.MODULE$.runAddJarOperation(addJarOperation, this.executor(), this.sessionId()));
                    return;
                }
            }
            if (operation2 instanceof RemoveJarOperation) {
                RemoveJarOperation removeJarOperation = (RemoveJarOperation)operation2;
                this.resultSet_$eq(OperationUtils$.MODULE$.runRemoveJarOperation(removeJarOperation, this.executor(), this.sessionId()));
                return;
            }
            if (operation2 instanceof ShowJarsOperation) {
                ShowJarsOperation showJarsOperation = (ShowJarsOperation)operation2;
                if (FlinkEngineUtils$.MODULE$.isFlinkVersionAtMost("1.15")) {
                    this.resultSet_$eq(OperationUtils$.MODULE$.runShowJarOperation(showJarsOperation, this.executor(), this.sessionId()));
                    return;
                }
            }
            this.explainOperation(this.statement());
            return;
        }
        catch (Throwable x$1) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(this.onError$default$1());
            if (!catchExpr$1.isDefinedAt((Object)x$1)) throw x$1;
            catchExpr$1.apply((Object)x$1);
            return;
        }
    }

    private void explainOperation(String statement) {
        String string;
        StreamTableEnvironment tableEnv = this.sessionContext().getExecutionContext().getTableEnvironment();
        String[] explainPlans = tableEnv.explainSql(statement, new ExplainDetail[0]).split(new StringBuilder(0).append(this.lineSeparator()).append(this.lineSeparator()).toString());
        PlanOnlyMode planOnlyMode = this.mode;
        if (ParseMode$.MODULE$.equals(planOnlyMode)) {
            string = explainPlans[0].split(new StringBuilder(26).append("== Abstract Syntax Tree ==").append(this.lineSeparator()).toString())[1];
        } else if (PhysicalMode$.MODULE$.equals(planOnlyMode)) {
            string = explainPlans[1].split(new StringBuilder(29).append("== Optimized Physical Plan ==").append(this.lineSeparator()).toString())[1];
        } else if (ExecutionMode$.MODULE$.equals(planOnlyMode)) {
            string = explainPlans[2].split(new StringBuilder(30).append("== Optimized Execution Plan ==").append(this.lineSeparator()).toString())[1];
        } else {
            if (UnknownMode$.MODULE$.equals(planOnlyMode)) {
                throw PlanOnlyMode$.MODULE$.unknownModeError(this.mode);
            }
            throw PlanOnlyMode$.MODULE$.notSupportedModeError(this.mode, "Flink SQL");
        }
        String operationPlan = string;
        this.resultSet_$eq(ResultSetUtil$.MODULE$.stringListToResultSet((List<String>)new .colon.colon((Object)operationPlan, (List)Nil$.MODULE$), "plan"));
    }

    public PlanOnlyStatement(Session session, String statement, PlanOnlyMode mode) {
        this.statement = statement;
        this.mode = mode;
        super(session);
        this.operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.lineSeparator = System.lineSeparator();
    }
}

