/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.zookeeper;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientCallbackHandler
implements CallbackHandler {
    private String password = null;
    private static final Logger LOG = LoggerFactory.getLogger(SaslClientCallbackHandler.class);
    private final String entity;

    public SaslClientCallbackHandler(String password, String client) {
        this.password = password;
        this.entity = client;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                nc.setName(nc.getDefaultName());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                if (this.password != null) {
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                LOG.warn("Could not login: the {} is being asked for a password, but the ZooKeeper {} code does not currently support obtaining a password from the user. Make sure that the {} is configured to use a ticket cache (using the JAAS configuration setting 'useTicketCache=true)' and restart the {}. If you still get this message after that, the TGT in the ticket cache has expired and must be manually refreshed. To do so, first determine if you are using a password or a keytab. If the former, run kinit in a Unix shell in the environment of the user who is running this Zookeeper {} using the command 'kinit <princ>' (where <princ> is the name of the {}'s Kerberos principal). If the latter, do 'kinit -k -t <keytab> <princ>' (where <princ> is the name of the Kerberos principal, and <keytab> is the location of the keytab file). After manually refreshing your cache, restart this {}. If you continue to see this message after manually refreshing your cache, ensure that your KDC host's clock is in sync with this host's clock.", new Object[]{this.entity, this.entity, this.entity, this.entity, this.entity, this.entity, this.entity});
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                rc.setText(rc.getDefaultText());
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                String authzid;
                AuthorizeCallback ac = (AuthorizeCallback)callback;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (!ac.isAuthorized()) continue;
                ac.setAuthorizedID(authzid);
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized SASL " + this.entity + "Callback");
        }
    }
}

