/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import java.util.HashMap;
import java.util.Map;

public class HttpStatusMessage {
    private static final String UNKNOWN_STATUS = "Unknown Status";
    private static final Map<Integer, String> REASONS = new HashMap<Integer, String>();

    private static void entry(int i, String string) {
        REASONS.put(i, string);
    }

    public static String getMessageForStatus(int status) {
        return REASONS.getOrDefault(status, UNKNOWN_STATUS);
    }

    private HttpStatusMessage() {
    }

    static {
        HttpStatusMessage.entry(100, "Continue");
        HttpStatusMessage.entry(101, "Switching Protocol");
        HttpStatusMessage.entry(102, "Processing");
        HttpStatusMessage.entry(103, "Early Hints");
        HttpStatusMessage.entry(200, "OK");
        HttpStatusMessage.entry(201, "Created");
        HttpStatusMessage.entry(202, "Accepted");
        HttpStatusMessage.entry(203, "Non-Authoritative Information");
        HttpStatusMessage.entry(204, "No Content");
        HttpStatusMessage.entry(205, "Reset Content");
        HttpStatusMessage.entry(206, "Partial Content");
        HttpStatusMessage.entry(207, "Multi Status");
        HttpStatusMessage.entry(208, "Already Reported");
        HttpStatusMessage.entry(226, "IM Used");
        HttpStatusMessage.entry(300, "Multiple Choice");
        HttpStatusMessage.entry(301, "Moved Permanently");
        HttpStatusMessage.entry(302, "Found");
        HttpStatusMessage.entry(303, "See Other");
        HttpStatusMessage.entry(304, "Not Modified");
        HttpStatusMessage.entry(305, "Use Proxy");
        HttpStatusMessage.entry(307, "Temporary Redirect");
        HttpStatusMessage.entry(308, "Permanent Redirect");
        HttpStatusMessage.entry(400, "Bad Request");
        HttpStatusMessage.entry(401, "Unauthorized");
        HttpStatusMessage.entry(402, "Payment Required");
        HttpStatusMessage.entry(403, "Forbidden");
        HttpStatusMessage.entry(404, "Not Found");
        HttpStatusMessage.entry(405, "Method Not Allowed");
        HttpStatusMessage.entry(406, "Not Acceptable");
        HttpStatusMessage.entry(407, "Proxy Authentication Required");
        HttpStatusMessage.entry(408, "Request Timeout");
        HttpStatusMessage.entry(409, "Conflict");
        HttpStatusMessage.entry(410, "Gone");
        HttpStatusMessage.entry(411, "Length Required");
        HttpStatusMessage.entry(412, "Precondition Failed");
        HttpStatusMessage.entry(413, "Payload Too Long");
        HttpStatusMessage.entry(414, "URI Too Long");
        HttpStatusMessage.entry(415, "Unsupported Media Type");
        HttpStatusMessage.entry(416, "Range Not Satisfiable");
        HttpStatusMessage.entry(417, "Expectation Failed");
        HttpStatusMessage.entry(418, "I'm a Teapot");
        HttpStatusMessage.entry(421, "Misdirected Request");
        HttpStatusMessage.entry(422, "Unprocessable Entity");
        HttpStatusMessage.entry(423, "Locked");
        HttpStatusMessage.entry(424, "Failed Dependency");
        HttpStatusMessage.entry(425, "Too Early");
        HttpStatusMessage.entry(426, "Upgrade Required");
        HttpStatusMessage.entry(428, "Precondition Required");
        HttpStatusMessage.entry(429, "Too Many Requests");
        HttpStatusMessage.entry(431, "Request Header Fields Too Large");
        HttpStatusMessage.entry(451, "Unavailable for Legal Reasons");
        HttpStatusMessage.entry(500, "Internal Server Error");
        HttpStatusMessage.entry(501, "Not Implemented");
        HttpStatusMessage.entry(502, "Bad Gateway");
        HttpStatusMessage.entry(503, "Service Unavailable");
        HttpStatusMessage.entry(504, "Gateway Timeout");
        HttpStatusMessage.entry(505, "HTTP Version Not Supported");
        HttpStatusMessage.entry(506, "Variant Also Negotiates");
        HttpStatusMessage.entry(507, "Insufficient Storage");
        HttpStatusMessage.entry(508, "Loop Detected");
        HttpStatusMessage.entry(510, "Not Extended");
        HttpStatusMessage.entry(511, "Network Authentication Required");
    }
}

