/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationState$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.KyuubiApplicationManager;
import org.apache.kyuubi.engine.ProcBuilder;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.flink.FlinkProcessBuilder;
import org.apache.kyuubi.engine.hive.HiveProcessBuilder;
import org.apache.kyuubi.engine.jdbc.JdbcProcessBuilder;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.trino.TrinoProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.plugin.GroupProvider;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tUa!\u0002\u0016,\u00015\u001a\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u0005\u000f\"A!\f\u0001B\u0001B\u0003%1\fC\u0003`\u0001\u0011\u0005\u0001\rC\u0004h\u0001\t\u0007I\u0011\u00025\t\r%\u0004\u0001\u0015!\u0003H\u0011\u001dQ\u0007A1A\u0005\n-Daa\u001c\u0001!\u0002\u0013a\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003s\u0011%\t)\u0001\u0001b\u0001\n\u0013\t9\u0001\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0011BA\u0005\u0011%\tI\u0002\u0001b\u0001\n\u0013\tY\u0002\u0003\u0005\u0002$\u0001\u0001\u000b\u0011BA\u000f\u0011%\t)\u0003\u0001b\u0001\n\u0013\tY\u0002\u0003\u0005\u0002(\u0001\u0001\u000b\u0011BA\u000f\u0011!\tI\u0003\u0001b\u0001\n\u0013A\u0007bBA\u0016\u0001\u0001\u0006Ia\u0012\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003_A\u0001\"a\u000e\u0001A\u0003%\u0011\u0011\u0007\u0005\t\u0003s\u0001!\u0019!C\u0005Q\"9\u00111\b\u0001!\u0002\u00139\u0005\"CA\u001f\u0001\t\u0007I\u0011BA \u0011!\t9\u0005\u0001Q\u0001\n\u0005\u0005\u0003bCA%\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017B1\"a\u0015\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002V!Y\u0011\u0011\r\u0001A\u0002\u0003\u0005\u000b\u0015BA'\u0011%\t\u0019\u0007\u0001b\u0001\n\u0003i\u0003\u000eC\u0004\u0002f\u0001\u0001\u000b\u0011B$\t\u0013\u0005\u001d\u0004A1A\u0005\u00025B\u0007bBA5\u0001\u0001\u0006Ia\u0012\u0005\n\u0003\u000b\u0003!\u0019!C\u0001[!Dq!a\"\u0001A\u0003%q\t\u0003\u0006\u0002\f\u0002A)\u0019!C\u0001[!Dq!a$\u0001\t\u0013\t\t\nC\u0004\u0002L\u0002!I!!4\t\u000f\u0005E\b\u0001\"\u0001\u0002t\"I\u0011\u0011 \u0001\u0012\u0002\u0013\u0005\u00111 \u0005\b\u0005#\u0001A\u0011\u0001B\n\u0005%)enZ5oKJ+gM\u0003\u0002-[\u00051QM\\4j]\u0016T!AL\u0018\u0002\r-LX/\u001e2j\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\u0014\u0007\u0001!$\b\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003wqj\u0011!L\u0005\u0003{5\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u00076\naaY8oM&<\u0017BA#C\u0005)Y\u00150^;cS\u000e{gNZ\u0001\u0005kN,'\u000f\u0005\u0002I\u001f:\u0011\u0011*\u0014\t\u0003\u0015Zj\u0011a\u0013\u0006\u0003\u0019~\na\u0001\u0010:p_Rt\u0014B\u0001(7\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u000593\u0014!D4s_V\u0004\bK]8wS\u0012,'\u000f\u0005\u0002U/6\tQK\u0003\u0002W[\u00051\u0001\u000f\\;hS:L!\u0001W+\u0003\u001b\u001d\u0013x.\u001e9Qe>4\u0018\u000eZ3s\u0003-)gnZ5oKJ+g-\u00133\u0002\u001b\u0015tw-\u001b8f\u001b\u0006t\u0017mZ3s!\taV,D\u0001,\u0013\tq6F\u0001\rLsV,(-[!qa2L7-\u0019;j_:l\u0015M\\1hKJ\fa\u0001P5oSRtDCB1cG\u0012,g\r\u0005\u0002]\u0001!)aH\u0002a\u0001\u0001\")aI\u0002a\u0001\u000f\")!K\u0002a\u0001'\")\u0011L\u0002a\u0001\u000f\")!L\u0002a\u00017\u0006Y1/\u001a:wKJ\u001c\u0006/Y2f+\u00059\u0015\u0001D:feZ,'o\u00159bG\u0016\u0004\u0013a\u0002;j[\u0016|W\u000f^\u000b\u0002YB\u0011Q'\\\u0005\u0003]Z\u0012A\u0001T8oO\u0006AA/[7f_V$\b%\u0001\u0006tQ\u0006\u0014X\rT3wK2,\u0012A\u001d\t\u0003gzt!\u0001\u001e?\u000f\u0005U\\hB\u0001<{\u001d\t9\u0018P\u0004\u0002Kq&\t!'\u0003\u00021c%\u0011afL\u0005\u0003Y5J!!`\u0016\u0002\u0015MC\u0017M]3MKZ,G.C\u0002\u0000\u0003\u0003\u0011!b\u00155be\u0016dUM^3m\u0015\ti8&A\u0006tQ\u0006\u0014X\rT3wK2\u0004\u0013AC3oO&tW\rV=qKV\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\t\tBD\u0002u\u0003\u001bI1!a\u0004,\u0003))enZ5oKRK\b/Z\u0005\u0005\u0003'\t)B\u0001\u0006F]\u001eLg.\u001a+za\u0016T1!a\u0004,\u0003-)gnZ5oKRK\b/\u001a\u0011\u0002\u001bA|w\u000e\u001c+ie\u0016\u001c\bn\u001c7e+\t\ti\u0002E\u00026\u0003?I1!!\t7\u0005\rIe\u000e^\u0001\u000fa>|G\u000e\u00165sKNDw\u000e\u001c3!\u00039\u0019G.[3oiB{w\u000e\\*ju\u0016\fqb\u00197jK:$\bk\\8m'&TX\rI\u0001\u000fG2LWM\u001c;Q_>dg*Y7f\u0003=\u0019G.[3oiB{w\u000e\u001c(b[\u0016\u0004\u0013!G3oO&tW\rU8pY&;gn\u001c:f'V\u0014Gm\\7bS:,\"!!\r\u0011\u0007U\n\u0019$C\u0002\u00026Y\u0012qAQ8pY\u0016\fg.\u0001\u000ef]\u001eLg.\u001a)p_2LuM\\8sKN+(\rZ8nC&t\u0007%\u0001\ff]\u001eLg.\u001a)p_2\u001cV\r\\3diB{G.[2z\u0003])gnZ5oKB{w\u000e\\*fY\u0016\u001cG\u000fU8mS\u000eL\b%\u0001\rM\u001f\u000e[u\fV%N\u000b>+FkX*Q\u0003:{f)Q\"U\u001fJ+\"!!\u0011\u0011\u0007U\n\u0019%C\u0002\u0002FY\u0012a\u0001R8vE2,\u0017!\u0007'P\u0007.{F+S'F\u001fV#vl\u0015)B\u001d~3\u0015i\u0011+P%\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002NA\u0019A,a\u0014\n\u0007\u0005E3FA\u0006Qe>\u001c')^5mI\u0016\u0014\u0018a\u00032vS2$WM]0%KF$B!a\u0016\u0002^A\u0019Q'!\u0017\n\u0007\u0005mcG\u0001\u0003V]&$\b\"CA09\u0005\u0005\t\u0019AA'\u0003\rAH%M\u0001\tEVLG\u000eZ3sA\u00059\u0011\r\u001d9Vg\u0016\u0014\u0018\u0001C1qaV\u001bXM\u001d\u0011\u0002\u0013M,(\rZ8nC&t\u0017AC:vE\u0012|W.Y5oA!\u001a\u0011%!\u001c\u0011\t\u0005=\u0014\u0011Q\u0007\u0003\u0003cRA!a\u001d\u0002v\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\u0011\t9(!\u001f\u0002\r\r|W.\\8o\u0015\u0011\tY(! \u0002\r\u001d|wn\u001a7f\u0015\t\ty(A\u0002d_6LA!a!\u0002r\t\tb+[:jE2,gi\u001c:UKN$\u0018N\\4\u0002#\u0011,g-Y;mi\u0016sw-\u001b8f\u001d\u0006lW-\u0001\neK\u001a\fW\u000f\u001c;F]\u001eLg.\u001a(b[\u0016\u0004\u0003fA\u0012\u0002n\u0005YQM\\4j]\u0016\u001c\u0006/Y2fQ\r!\u0013QN\u0001\fiJLx+\u001b;i\u0019>\u001c7.\u0006\u0003\u0002\u0014\u0006mE\u0003BAK\u0003o#B!a&\u0002.B!\u0011\u0011TAN\u0019\u0001!q!!(&\u0005\u0004\tyJA\u0001U#\u0011\t\t+a*\u0011\u0007U\n\u0019+C\u0002\u0002&Z\u0012qAT8uQ&tw\rE\u00026\u0003SK1!a+7\u0005\r\te.\u001f\u0005\t\u0003_+C\u00111\u0001\u00022\u0006\ta\rE\u00036\u0003g\u000b9*C\u0002\u00026Z\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0003s+\u0003\u0019AA^\u0003=!\u0017n]2pm\u0016\u0014\u0018p\u00117jK:$\b\u0003BA_\u0003\u000fl!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u0007G2LWM\u001c;\u000b\u0007\u0005\u0015W&\u0001\u0002iC&!\u0011\u0011ZA`\u0005=!\u0015n]2pm\u0016\u0014\u0018p\u00117jK:$\u0018AB2sK\u0006$X\r\u0006\u0004\u0002P\u0006U\u0017q\u001b\t\u0007k\u0005Ew)!\b\n\u0007\u0005MgG\u0001\u0004UkBdWM\r\u0005\b\u0003s3\u0003\u0019AA^\u0011\u001d\tIN\na\u0001\u00037\fa\"\u001a=ue\u0006,enZ5oK2{w\rE\u00036\u0003;\f\t/C\u0002\u0002`Z\u0012aa\u00149uS>t\u0007\u0003BAr\u0003[l!!!:\u000b\t\u0005\u001d\u0018\u0011^\u0001\u0004Y><'bAAv[\u0005Iq\u000e]3sCRLwN\\\u0005\u0005\u0003_\f)O\u0001\u0007Pa\u0016\u0014\u0018\r^5p]2{w-A\u0006hKR|%o\u0011:fCR,GCBAh\u0003k\f9\u0010C\u0004\u0002:\u001e\u0002\r!a/\t\u0013\u0005ew\u0005%AA\u0002\u0005m\u0017!F4fi>\u00138I]3bi\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003{TC!a7\u0002\u0000.\u0012!\u0011\u0001\t\u0005\u0005\u0007\u0011i!\u0004\u0002\u0003\u0006)!!q\u0001B\u0005\u0003%)hn\u00195fG.,GMC\u0002\u0003\fY\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yA!\u0002\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0003dY>\u001cX\r\u0006\u0002\u0002X\u0001")
public class EngineRef
implements Logging {
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final String engineRefId;
    private final KyuubiApplicationManager engineManager;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    private final String clientPoolName;
    private final boolean enginePoolIgnoreSubdomain;
    private final String enginePoolSelectPolicy;
    private final double LOCK_TIMEOUT_SPAN_FACTOR;
    private ProcBuilder builder;
    private final String appUser;
    @VisibleForTesting
    private final String subdomain;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    private String clientPoolName() {
        return this.clientPoolName;
    }

    private boolean enginePoolIgnoreSubdomain() {
        return this.enginePoolIgnoreSubdomain;
    }

    private String enginePoolSelectPolicy() {
        return this.enginePoolSelectPolicy;
    }

    private double LOCK_TIMEOUT_SPAN_FACTOR() {
        return this.LOCK_TIMEOUT_SPAN_FACTOR;
    }

    private ProcBuilder builder() {
        return this.builder;
    }

    private void builder_$eq(ProcBuilder x$1) {
        this.builder = x$1;
    }

    public String appUser() {
        return this.appUser;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if (!this.bitmap$0) {
                String commonParent = new StringBuilder(3).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                this.engineSpace = !(value2 != null ? !value2.equals(value3) : value3 != null) ? DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.engineRefId})) : DiscoveryPaths$.MODULE$.makePath(commonParent, this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
                this.bitmap$0 = true;
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        if (!this.bitmap$0) {
            return this.engineSpace$lzycompute();
        }
        return this.engineSpace;
    }

    private <T> T tryWithLock(DiscoveryClient discoveryClient, Function0<T> f) {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return (T)f.apply();
        }
        String lockPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(8).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_lock").toString(), this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.subdomain()}));
        return (T)discoveryClient.tryWithLock(lockPath, this.timeout() + (long)(this.LOCK_TIMEOUT_SPAN_FACTOR() * (double)this.timeout()), f);
    }

    private Tuple2<String, Object> create(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(discoveryClient, (Function0 & Serializable & scala.Serializable)() -> {
                boolean destroyProcess;
                Tuple2 tuple2;
                Logging logging;
                Option engineRef = discoveryClient.getServerHost(this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ENGINE_REF_ID(), (Object)$this.engineRefId);
                long started = System.currentTimeMillis();
                $this.conf.set("kyuubi.engine.submit.time", String.valueOf(started));
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                    logging = new SparkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                } else {
                    Enumeration.Value value4 = EngineType$.MODULE$.FLINK_SQL();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        $this.conf.setIfMissing("yarn.application.name", this.defaultEngineName());
                        logging = new FlinkProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                    } else {
                        Enumeration.Value value6 = EngineType$.MODULE$.TRINO();
                        Enumeration.Value value7 = value;
                        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                            logging = new TrinoProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                        } else {
                            Enumeration.Value value8 = EngineType$.MODULE$.HIVE_SQL();
                            Enumeration.Value value9 = value;
                            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                                logging = new HiveProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                            } else {
                                Enumeration.Value value10 = EngineType$.MODULE$.JDBC();
                                Enumeration.Value value11 = value;
                                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                                    logging = new JdbcProcessBuilder(this.appUser(), $this.conf, $this.engineRefId, extraEngineLog);
                                } else {
                                    throw new MatchError((Object)value);
                                }
                            }
                        }
                    }
                }
                this.builder_$eq((ProcBuilder)logging);
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                try {
                    String redactedCmd = this.builder().toString();
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(redactedCmd).toString());
                    this.builder().validateConf();
                    Process process = this.builder().start();
                    None$ exitValue = None$.MODULE$;
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS) && BoxesRunTime.unboxToInt((Object)(exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()))).get()) != 0) {
                            Throwable error = this.builder().getError();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                EngineRef.$anonfun$create$4(this, error, ms);
                                return BoxedUnit.UNIT;
                            });
                            throw error;
                        }
                        None$ none$ = exitValue;
                        Some some = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                        if (!(none$ != null ? !none$.equals(some) : some != null)) {
                            Option$.MODULE$.apply((Object)$this.engineManager).foreach((Function1 & Serializable & scala.Serializable)engineMgr -> {
                                EngineRef.$anonfun$create$5(this, started, engineMgr);
                                return BoxedUnit.UNIT;
                            });
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            Tuple2<Object, String> killMessage = $this.engineManager.killApplication(this.builder().clusterManager(), $this.engineRefId);
                            process.destroyForcibly();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                                x$2.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(70).append("Timeout(").append(this.timeout()).append(" ms, you can modify ").append(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT().key()).append(" to change it) to").append(" launched ").append(this.engineType()).append(" engine with ").append(redactedCmd).append(". ").append(killMessage).toString(), this.builder().getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = discoveryClient.getEngineByRefId(this.engineSpace(), $this.engineRefId);
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                catch (Throwable throwable) {
                    boolean destroyProcess2;
                    boolean waitCompletion = BoxesRunTime.unboxToBoolean((Object)$this.conf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_STARTUP_WAIT_COMPLETION()));
                    boolean bl = destroyProcess2 = !waitCompletion && this.builder().isClusterMode();
                    if (destroyProcess2) {
                        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                    }
                    this.builder().close(destroyProcess2);
                    throw throwable;
                }
                boolean waitCompletion = BoxesRunTime.unboxToBoolean((Object)$this.conf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_STARTUP_WAIT_COMPLETION()));
                boolean bl = destroyProcess = !waitCompletion && this.builder().isClusterMode();
                if (destroyProcess) {
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Destroy the builder process because waitCompletion is false and the engine is running in cluster mode.");
                }
                this.builder().close(destroyProcess);
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(DiscoveryClient discoveryClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)discoveryClient.getServerHost(this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(discoveryClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public void close() {
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        if (!(value != null ? !value.equals(value2) : value2 != null) && this.builder() != null) {
            try {
                Option<String> clusterManager = this.builder().clusterManager();
                this.builder().close(true);
                this.engineManager.killApplication(clusterManager, this.engineRefId);
            }
            catch (Exception e) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Error closing engine builder, engineRefId: ").append($this.engineRefId).toString(), e);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$create$4(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public static final /* synthetic */ void $anonfun$create$7(EngineRef $this, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{"ENGINE_TERMINATE"}));
    }

    public static final /* synthetic */ void $anonfun$create$6(EngineRef $this, ApplicationInfo appInfo) {
        if (ApplicationState$.MODULE$.isTerminated(appInfo.state())) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                EngineRef.$anonfun$create$7($this, ms);
                return BoxedUnit.UNIT;
            });
            throw new KyuubiSQLException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n                     |The engine application has been terminated. Please check the engine log.\n                     |ApplicationInfo: ").append(appInfo.toMap().mkString("(\n", ",\n", "\n)")).append("\n                     |").toString())).stripMargin(), $this.builder().getError());
        }
    }

    public static final /* synthetic */ void $anonfun$create$5(EngineRef $this, long started$1, KyuubiApplicationManager engineMgr) {
        engineMgr.getApplicationInfo($this.builder().clusterManager(), $this.engineRefId, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)started$1))).foreach((Function1 & Serializable & scala.Serializable)appInfo -> {
            EngineRef.$anonfun$create$6($this, appInfo);
            return BoxedUnit.UNIT;
        });
    }

    public EngineRef(KyuubiConf conf, String user, GroupProvider groupProvider, String engineRefId, KyuubiApplicationManager engineManager) {
        String string;
        String string2;
        this.conf = conf;
        this.engineRefId = engineRefId;
        this.engineManager = engineManager;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        this.clientPoolName = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_NAME());
        this.enginePoolIgnoreSubdomain = BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_IGNORE_SUBDOMAIN()));
        this.enginePoolSelectPolicy = (String)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SELECT_POLICY());
        this.LOCK_TIMEOUT_SPAN_FACTOR = Utils$.MODULE$.isTesting() ? 0.5 : 0.1;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string2 = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value5 = value;
            string2 = !(value4 != null ? !value4.equals(value5) : value5 != null) ? groupProvider.primaryGroup(user, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)conf.getAll()).asJava()) : user;
        }
        this.appUser = string2;
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (this.clientPoolSize() > 0 && (option.isEmpty() || this.enginePoolIgnoreSubdomain())) {
            int n;
            String string3;
            int poolSize = scala.math.package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            if ("POLLING".equals(string3 = this.enginePoolSelectPolicy())) {
                String snPath = DiscoveryPaths$.MODULE$.makePath(new StringBuilder(10).append(this.serverSpace()).append("_").append(package$.MODULE$.KYUUBI_VERSION()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).append("_seqNum").toString(), this.appUser(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.clientPoolName()}));
                n = BoxesRunTime.unboxToInt((Object)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(conf, (Function1 & Serializable & scala.Serializable)client -> BoxesRunTime.boxToInteger((int)client.getAndIncrement(snPath, client.getAndIncrement$default$2()))));
            } else if ("RANDOM".equals(string3)) {
                n = Random$.MODULE$.nextInt(poolSize);
            } else {
                throw new MatchError((Object)string3);
            }
            int seqNum = n;
            string = new StringBuilder(1).append(this.clientPoolName()).append("-").append(seqNum % poolSize).toString();
        } else if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string = _subdomain = (String)some.value();
        } else {
            string = "default";
        }
        this.subdomain = string;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.appUser()).toString();
        Enumeration.Value value6 = this.shareLevel();
        Enumeration.Value value7 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value8 = value6;
        this.defaultEngineName = !(value7 != null ? !value7.equals(value8) : value8 != null) ? new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
    }
}

