/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.Serializable;
import java.net.ConnectException;
import java.util.Base64;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.client.KyuubiSyncThriftClient;
import org.apache.kyuubi.client.KyuubiSyncThriftClient$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.EngineRef;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.events.EventBus$;
import org.apache.kyuubi.events.KyuubiEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent;
import org.apache.kyuubi.events.KyuubiSessionEvent$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.operation.Operation;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.session.KyuubiSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.sql.parser.server.KyuubiParser;
import org.apache.kyuubi.sql.plan.KyuubiTreeNode;
import org.apache.kyuubi.sql.plan.command.RunnableCommand;
import org.apache.kyuubi.util.SignUtils$;
import org.apache.thrift.transport.TTransportException;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001B\u001a5\u0001uB\u0011B\u0011\u0001\u0003\u0002\u0003\u0006IaQ(\t\u0013I\u0003!\u0011!Q\u0001\nM\u0003\u0007\"C1\u0001\u0005\u0003\u0005\u000b\u0011B*c\u0011%\u0019\u0007A!A!\u0002\u0013\u0019F\rC\u0005f\u0001\t\u0005\t\u0015!\u0003gS\"I!\u000e\u0001B\u0001B\u0003%1N\u001c\u0005\t_\u0002\u0011\t\u0011)A\u0005a\"Aa\u000f\u0001B\u0001B\u0003%q\u000fC\u0004\u0002\u0002\u0001!\t!a\u0001\t\u0013\u0005]\u0001A1A\u0005B\u0005e\u0001\u0002CA\u001d\u0001\u0001\u0006I!a\u0007\t\u0015\u0005m\u0002A1A\u0005\u0002Y\ni\u0004C\u0004\u0002@\u0001\u0001\u000b\u0011\u00024\t\u0015\u0005\u0005\u0003\u0001#b\u0001\n\u0013\t\u0019\u0005\u0003\u0006\u0002F\u0001A)\u0019!C\u0001\u0003\u000fB!\"a\u0015\u0001\u0005\u0004%\tANA+\u0011!\t\u0019\u0007\u0001Q\u0001\n\u0005]\u0003BCA3\u0001!\u0015\r\u0011\"\u0003\u0002D!I\u0011q\r\u0001C\u0002\u0013%\u0011\u0011\u000e\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002l!9\u0011\u0011\u0010\u0001\u0005B\u0005m\u0004bBAC\u0001\u0011\u0005\u0013q\u0011\u0005\f\u0003\u001f\u0003\u0001\u0019!a\u0001\n\u0013\t\t\nC\u0006\u0002 \u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0006bCAT\u0001\u0001\u0007\t\u0011)Q\u0005\u0003'Cq!!'\u0001\t\u0003\t\t\nC\u0006\u0002*\u0002\u0001\r\u00111A\u0005\n\u0005-\u0006bCAZ\u0001\u0001\u0007\t\u0019!C\u0005\u0003kC1\"!/\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002.\"I\u00111\u0018\u0001A\u0002\u0013%\u0011Q\u0018\u0005\n\u0003'\u0004\u0001\u0019!C\u0005\u0003+D\u0001\"!7\u0001A\u0003&\u0011q\u0018\u0005\b\u00037\u0004A\u0011IAD\u0011!\ti\u000e\u0001C\u0001m\u0005}\u0007BCAz\u0001E\u0005I\u0011\u0001\u001c\u0002v\"9!1\u0002\u0001\u0005R\t5\u0001\"\u0003B\f\u0001\u0001\u0007I\u0011\u0002B\r\u0011%\u0011\t\u0003\u0001a\u0001\n\u0013\u0011\u0019\u0003\u0003\u0005\u0003(\u0001\u0001\u000b\u0015\u0002B\u000e\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0003\u000fCqAa\r\u0001\t\u0013\u0011)\u0004C\u0004\u00038\u0001!\t%a\"\t\u000f\te\u0002\u0001\"\u0011\u0003<!9!Q\n\u0001\u0005B\t=\u0003\"\u0004B4\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\r\u0003\r\u0003\b\u0003j\u0001\u0001\n1!A\u0001\n\u0013\t9Ia\u001b\t\u001b\t5\u0004\u0001%A\u0002\u0002\u0003%IAa\u001co\u00115\u00119\b\u0001I\u0001\u0004\u0003\u0005I\u0011BA\"E\"i!\u0011\u0010\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0003|=CaB! \u0001!\u0003\r\t\u0011!C\u0005\u0005\u007f\u0012IIA\tLsV,(-[*fgNLwN\\%na2T!!\u000e\u001c\u0002\u000fM,7o]5p]*\u0011q\u0007O\u0001\u0007Wf,XOY5\u000b\u0005eR\u0014AB1qC\u000eDWMC\u0001<\u0003\ry'oZ\u0002\u0001'\t\u0001a\b\u0005\u0002@\u00016\tA'\u0003\u0002Bi\ti1*_;vE&\u001cVm]:j_:\f\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0003\t6k\u0011!\u0012\u0006\u0003\r\u001e\u000ba\u0001\u001e5sS\u001a$(B\u0001%J\u0003\r\u0011\bo\u0019\u0006\u0003\u0015.\u000bqa]3sm&\u001cWM\u0003\u0002Mq\u0005!\u0001.\u001b<f\u0013\tqUI\u0001\tU!J|Go\\2pYZ+'o]5p]&\u0011!\tU\u0005\u0003#R\u0012q\"\u00112tiJ\f7\r^*fgNLwN\\\u0001\u0005kN,'\u000f\u0005\u0002U;:\u0011Qk\u0017\t\u0003-fk\u0011a\u0016\u0006\u00031r\na\u0001\u0010:p_Rt$\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK\u0016A\u0002)sK\u0012,g-\u0003\u0002_?\n11\u000b\u001e:j]\u001eT!\u0001X-\n\u0005I\u0003\u0016\u0001\u00039bgN<xN\u001d3\n\u0005\u0005\u0004\u0016!C5q\u0003\u0012$'/Z:t\u0013\t\u0019\u0007+\u0001\u0003d_:4\u0007\u0003\u0002+h'NK!\u0001[0\u0003\u00075\u000b\u0007/\u0003\u0002f!\u0006q1/Z:tS>tW*\u00198bO\u0016\u0014\bCA m\u0013\tiGG\u0001\u000bLsV,(-[*fgNLwN\\'b]\u0006<WM]\u0005\u0003UB\u000b1b]3tg&|gnQ8oMB\u0011\u0011\u000f^\u0007\u0002e*\u00111ON\u0001\u0007G>tg-[4\n\u0005U\u0014(AC&zkV\u0014\u0017nQ8oM\u00061\u0001/\u0019:tKJ\u0004\"\u0001\u001f@\u000e\u0003eT!A_>\u0002\rM,'O^3s\u0015\t1HP\u0003\u0002~m\u0005\u00191/\u001d7\n\u0005}L(\u0001D&zkV\u0014\u0017\u000eU1sg\u0016\u0014\u0018A\u0002\u001fj]&$h\b\u0006\n\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0001CA \u0001\u0011\u0015\u0011\u0015\u00021\u0001D\u0011\u0015\u0011\u0016\u00021\u0001T\u0011\u0015\t\u0017\u00021\u0001T\u0011\u0015\u0019\u0017\u00021\u0001T\u0011\u0015)\u0017\u00021\u0001g\u0011\u0015Q\u0017\u00021\u0001l\u0011\u0015y\u0017\u00021\u0001q\u0011\u00151\u0018\u00021\u0001x\u0003-\u0019Xm]:j_:$\u0016\u0010]3\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003gqA!a\b\u000209!\u0011\u0011EA\u0017\u001d\u0011\t\u0019#a\u000b\u000f\t\u0005\u0015\u0012\u0011\u0006\b\u0004-\u0006\u001d\u0012\"A\u001e\n\u0005eR\u0014BA\u001c9\u0013\t)d'C\u0002\u00022Q\n1bU3tg&|g\u000eV=qK&!\u0011QGA\u001c\u0005-\u0019Vm]:j_:$\u0016\u0010]3\u000b\u0007\u0005EB'\u0001\u0007tKN\u001c\u0018n\u001c8UsB,\u0007%A\u0007paRLW.\u001b>fI\u000e{gNZ\u000b\u0002M\u0006qq\u000e\u001d;j[&TX\rZ\"p]\u001a\u0004\u0013!E3oO&tWm\u0011:fI\u0016tG/[1mgV\t1+\u0001\u0004f]\u001eLg.Z\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002P5\u0011\u0011Q\n\u0006\u0004\u0003\u000b2\u0014\u0002BA)\u0003\u001b\u0012\u0011\"\u00128hS:,'+\u001a4\u0002\u001d1\fWO\\2i\u000b:<\u0017N\\3PaV\u0011\u0011q\u000b\t\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011Q\f\u001c\u0002\u0013=\u0004XM]1uS>t\u0017\u0002BA1\u00037\u0012\u0011b\u00149fe\u0006$\u0018n\u001c8\u0002\u001f1\fWO\\2i\u000b:<\u0017N\\3Pa\u0002\nQc]3tg&|g.V:feNKwM\u001c\"bg\u00164D'\u0001\u0007tKN\u001c\u0018n\u001c8Fm\u0016tG/\u0006\u0002\u0002lA!\u0011QNA:\u001b\t\tyGC\u0002\u0002rY\na!\u001a<f]R\u001c\u0018\u0002BA;\u0003_\u0012!cS=vk\nL7+Z:tS>tWI^3oi\u0006i1/Z:tS>tWI^3oi\u0002\nqbZ3u'\u0016\u001c8/[8o\u000bZ,g\u000e^\u000b\u0003\u0003{\u0002b!a \u0002\u0002\u0006-T\"A-\n\u0007\u0005\r\u0015L\u0001\u0004PaRLwN\\\u0001\u001bG\",7m[*fgNLwN\\!dG\u0016\u001c8\u000fU1uQV\u0013\u0016j\u001d\u000b\u0003\u0003\u0013\u0003B!a \u0002\f&\u0019\u0011QR-\u0003\tUs\u0017\u000e^\u0001\b?\u000ed\u0017.\u001a8u+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tIJN\u0001\u0007G2LWM\u001c;\n\t\u0005u\u0015q\u0013\u0002\u0017\u0017f,XOY5Ts:\u001cG\u000b\u001b:jMR\u001cE.[3oi\u0006Yql\u00197jK:$x\fJ3r)\u0011\tI)a)\t\u0013\u0005\u0015\u0006$!AA\u0002\u0005M\u0015a\u0001=%c\u0005Aql\u00197jK:$\b%\u0001\u000b`K:<\u0017N\\3TKN\u001c\u0018n\u001c8IC:$G.Z\u000b\u0003\u0003[\u00032aPAX\u0013\r\t\t\f\u000e\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\u00021}+gnZ5oKN+7o]5p]\"\u000bg\u000e\u001a7f?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0006]\u0006\"CAS9\u0005\u0005\t\u0019AAW\u0003UyVM\\4j]\u0016\u001cVm]:j_:D\u0015M\u001c3mK\u0002\n\u0001c\u001c9f]N+7o]5p]\u0016\u0013(o\u001c:\u0016\u0005\u0005}\u0006CBA@\u0003\u0003\u000b\t\r\u0005\u0003\u0002D\u00065g\u0002BAc\u0003\u0013t1AVAd\u0013\u0005Q\u0016bAAf3\u00069\u0001/Y2lC\u001e,\u0017\u0002BAh\u0003#\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005-\u0017,\u0001\u000bpa\u0016t7+Z:tS>tWI\u001d:pe~#S-\u001d\u000b\u0005\u0003\u0013\u000b9\u000eC\u0005\u0002&~\t\t\u00111\u0001\u0002@\u0006\tr\u000e]3o'\u0016\u001c8/[8o\u000bJ\u0014xN\u001d\u0011\u0002\t=\u0004XM\\\u0001\u0012_B,g.\u00128hS:,7+Z:tS>tG\u0003BAE\u0003CD\u0011\"a9#!\u0003\u0005\r!!:\u0002\u001d\u0015DHO]1F]\u001eLg.\u001a'pOB1\u0011qPAA\u0003O\u0004B!!;\u0002p6\u0011\u00111\u001e\u0006\u0005\u0003[\fY&A\u0002m_\u001eLA!!=\u0002l\naq\n]3sCRLwN\u001c'pO\u0006Yr\u000e]3o\u000b:<\u0017N\\3TKN\u001c\u0018n\u001c8%I\u00164\u0017-\u001e7uIE*\"!a>+\t\u0005\u0015\u0018\u0011`\u0016\u0003\u0003w\u0004B!!@\u0003\b5\u0011\u0011q \u0006\u0005\u0005\u0003\u0011\u0019!A\u0005v]\u000eDWmY6fI*\u0019!QA-\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\n\u0005}(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a!/\u001e8Pa\u0016\u0014\u0018\r^5p]R!!q\u0002B\u000b!\u0011\tIF!\u0005\n\t\tM\u00111\f\u0002\u0010\u001fB,'/\u0019;j_:D\u0015M\u001c3mK\"9\u0011Q\f\u0013A\u0002\u0005]\u0013AD3oO&tW\rT1v]\u000eDW\rZ\u000b\u0003\u00057\u0001B!a \u0003\u001e%\u0019!qD-\u0003\u000f\t{w\u000e\\3b]\u0006\u0011RM\\4j]\u0016d\u0015-\u001e8dQ\u0016$w\fJ3r)\u0011\tII!\n\t\u0013\u0005\u0015f%!AA\u0002\tm\u0011aD3oO&tW\rT1v]\u000eDW\r\u001a\u0011)\u0007\u001d\u0012Y\u0003\u0005\u0003\u0002\u0000\t5\u0012b\u0001B\u00183\nAao\u001c7bi&dW-A\u000bxC&$hi\u001c:F]\u001eLg.\u001a'bk:\u001c\u0007.\u001a3\u0002-I,g.Z<F]\u001eLg.Z\"sK\u0012,g\u000e^5bYN$\u0012aU\u0001\u0006G2|7/Z\u0001\bO\u0016$\u0018J\u001c4p)\u0011\u0011iDa\u0011\u0011\u0007\u0011\u0013y$C\u0002\u0003B\u0015\u0013Q\u0002V$fi&sgm\u001c,bYV,\u0007b\u0002B#W\u0001\u0007!qI\u0001\tS:4w\u000eV=qKB\u0019AI!\u0013\n\u0007\t-SI\u0001\u0007U\u000f\u0016$\u0018J\u001c4p)f\u0004X-\u0001\tfq\u0016\u001cW\u000f^3Ti\u0006$X-\\3oiRQ!q\u0002B)\u0005+\u0012IF!\u0018\t\r\tMC\u00061\u0001T\u0003%\u0019H/\u0019;f[\u0016tG\u000f\u0003\u0004\u0003X1\u0002\rAZ\u0001\fG>tgm\u0014<fe2\f\u0017\u0010C\u0004\u0003\\1\u0002\rAa\u0007\u0002\u0011I,h.Q:z]\u000eDqAa\u0018-\u0001\u0004\u0011\t'\u0001\u0007rk\u0016\u0014\u0018\u0010V5nK>,H\u000f\u0005\u0003\u0002\u0000\t\r\u0014b\u0001B33\n!Aj\u001c8h\u0003)\u0019X\u000f]3sIU\u001cXM]\u0001\u000bgV\u0004XM\u001d\u0013pa\u0016t\u0017bAAn!\u0006!2/\u001e9fe\u0012\u001aXm]:j_:l\u0015M\\1hKJ,\"A!\u001d\u0011\u0007}\u0012\u0019(C\u0002\u0003vQ\u0012abU3tg&|g.T1oC\u001e,'/\u0001\btkB,'\u000f\n9bgN<xN\u001d3\u0002\u001dM,\b/\u001a:%aJ|Go\\2pYV\t1)\u0001\ftkB,'\u000fJ3yK\u000e,H/Z*uCR,W.\u001a8u))\u0011yA!!\u0003\u0004\n\u0015%q\u0011\u0005\u0007\u0005'\u0012\u0004\u0019A*\t\r\t]#\u00071\u0001g\u0011\u001d\u0011YF\ra\u0001\u00057AqAa\u00183\u0001\u0004\u0011\t'C\u0002\u0003NA\u0003")
public class KyuubiSessionImpl
extends KyuubiSession {
    private String engineCredentials;
    private EngineRef engine;
    private String sessionUserSignBase64;
    private final KyuubiConf sessionConf;
    private final KyuubiParser parser;
    private final Enumeration.Value sessionType;
    private final scala.collection.immutable.Map<String, String> optimizedConf;
    private final Operation launchEngineOp;
    private final KyuubiSessionEvent sessionEvent;
    private KyuubiSyncThriftClient _client;
    private SessionHandle _engineSessionHandle;
    private Option<Throwable> openSessionError;
    private volatile boolean engineLaunched;
    private volatile byte bitmap$0;

    private /* synthetic */ String super$user() {
        return super.user();
    }

    private /* synthetic */ void super$open() {
        super.open();
    }

    private /* synthetic */ SessionManager super$sessionManager() {
        return super.sessionManager();
    }

    private /* synthetic */ String super$password() {
        return super.password();
    }

    private /* synthetic */ TProtocolVersion super$protocol() {
        return super.protocol();
    }

    private /* synthetic */ OperationHandle super$executeStatement(String statement, scala.collection.immutable.Map confOverlay, boolean runAsync, long queryTimeout) {
        return super.executeStatement(statement, confOverlay, runAsync, queryTimeout);
    }

    @Override
    public Enumeration.Value sessionType() {
        return this.sessionType;
    }

    public scala.collection.immutable.Map<String, String> optimizedConf() {
        return this.optimizedConf;
    }

    private String engineCredentials$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.engineCredentials = this.renewEngineCredentials();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.engineCredentials;
    }

    private String engineCredentials() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.engineCredentials$lzycompute();
        }
        return this.engineCredentials;
    }

    private EngineRef engine$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.engine = new EngineRef(this.sessionConf, super.user(), ((KyuubiSessionManager)super.sessionManager()).groupProvider(), this.handle().identifier().toString(), ((KyuubiSessionManager)super.sessionManager()).applicationManager());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.engine;
    }

    public EngineRef engine() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.engine$lzycompute();
        }
        return this.engine;
    }

    public Operation launchEngineOp() {
        return this.launchEngineOp;
    }

    private String sessionUserSignBase64$lzycompute() {
        KyuubiSessionImpl kyuubiSessionImpl = this;
        synchronized (kyuubiSessionImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sessionUserSignBase64 = SignUtils$.MODULE$.signWithPrivateKey(super.user(), ((KyuubiSessionManager)super.sessionManager()).signingPrivateKey(), SignUtils$.MODULE$.signWithPrivateKey$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sessionUserSignBase64;
    }

    private String sessionUserSignBase64() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sessionUserSignBase64$lzycompute();
        }
        return this.sessionUserSignBase64;
    }

    private KyuubiSessionEvent sessionEvent() {
        return this.sessionEvent;
    }

    @Override
    public Option<KyuubiSessionEvent> getSessionEvent() {
        return Option$.MODULE$.apply((Object)this.sessionEvent());
    }

    @Override
    public void checkSessionAccessPathURIs() {
        KyuubiApplicationManager$.MODULE$.checkApplicationAccessPaths((String)this.sessionConf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()), (scala.collection.immutable.Map<String, String>)this.sessionConf.getAll(), ((KyuubiSessionManager)super.sessionManager()).getConf());
    }

    private KyuubiSyncThriftClient _client() {
        return this._client;
    }

    private void _client_$eq(KyuubiSyncThriftClient x$1) {
        this._client = x$1;
    }

    public KyuubiSyncThriftClient client() {
        return this._client();
    }

    private SessionHandle _engineSessionHandle() {
        return this._engineSessionHandle;
    }

    private void _engineSessionHandle_$eq(SessionHandle x$1) {
        this._engineSessionHandle = x$1;
    }

    private Option<Throwable> openSessionError() {
        return this.openSessionError;
    }

    private void openSessionError_$eq(Option<Throwable> x$1) {
        this.openSessionError = x$1;
    }

    public void open() {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.traceMetricsOnOpen();
            this.checkSessionAccessPathURIs();
            this.super$open();
            this.runOperation(this.launchEngineOp());
        });
    }

    public void openEngineSession(Option<OperationLog> extraEngineLog) {
        this.handleSessionException((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DiscoveryClientProvider$.MODULE$.withDiscoveryClient($this.sessionConf, (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$2(this, extraEngineLog, discoveryClient);
            return BoxedUnit.UNIT;
        }));
    }

    public Option<OperationLog> openEngineSession$default$1() {
        return None$.MODULE$;
    }

    public OperationHandle runOperation(Operation operation) {
        block2: {
            Operation operation2 = operation;
            Operation operation3 = this.launchEngineOp();
            if (!(operation2 == null ? operation3 != null : !operation2.equals(operation3))) break block2;
            try {
                this.waitForEngineLaunched();
            }
            catch (Throwable t) {
                operation.close();
                throw t;
            }
            this.sessionEvent().totalOperations_$eq(this.sessionEvent().totalOperations() + 1);
        }
        return super.runOperation(operation);
    }

    private boolean engineLaunched() {
        return this.engineLaunched;
    }

    private void engineLaunched_$eq(boolean x$1) {
        this.engineLaunched = x$1;
    }

    private void waitForEngineLaunched() {
        if (!this.engineLaunched()) {
            Option$.MODULE$.apply((Object)this.launchEngineOp()).foreach((Function1 & Serializable & scala.Serializable)op -> {
                KyuubiSessionImpl.$anonfun$waitForEngineLaunched$1(this, op);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private String renewEngineCredentials() {
        String string;
        try {
            string = ((KyuubiSessionManager)super.sessionManager()).credentialsManager().renewCredentials(this.engine().appUser());
        }
        catch (Exception e) {
            this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Failed to renew engine credentials for ").append(this.handle()).toString(), e);
            string = "";
        }
        return string;
    }

    public void close() {
        super.close();
        ((KyuubiSessionManager)super.sessionManager()).credentialsManager().removeSessionCredentialsEpoch(this.handle().identifier().toString());
        try {
            if (this._client() != null) {
                this._client().closeSession();
            }
        }
        finally {
            this.openSessionError().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                KyuubiSessionImpl.$anonfun$close$1(this, x$3);
                return BoxedUnit.UNIT;
            });
            this.sessionEvent().endTime_$eq(System.currentTimeMillis());
            EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
            this.traceMetricsOnClose();
        }
    }

    public TGetInfoValue getInfo(TGetInfoType infoType) {
        String string = (String)this.sessionConf.get(KyuubiConf$.MODULE$.SERVER_INFO_PROVIDER());
        if ("SERVER".equals(string)) {
            return super.getInfo(infoType);
        }
        if ("ENGINE".equals(string)) {
            return (TGetInfoValue)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
                this.waitForEngineLaunched();
                return this.client().getInfo(infoType).getInfoValue();
            });
        }
        throw new IllegalArgumentException(new StringBuilder(29).append("Unknown server info provider ").append(string).toString());
    }

    public OperationHandle executeStatement(String statement, scala.collection.immutable.Map<String, String> confOverlay, boolean runAsync, long queryTimeout) {
        return (OperationHandle)this.withAcquireRelease(this.withAcquireRelease$default$1(), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiTreeNode kyuubiNode = $this.parser.parsePlan(statement);
            KyuubiTreeNode kyuubiTreeNode = kyuubiNode;
            if (kyuubiTreeNode instanceof RunnableCommand) {
                RunnableCommand runnableCommand = (RunnableCommand)kyuubiTreeNode;
                Operation operation = ((KyuubiSessionManager)this.super$sessionManager()).operationManager().newExecuteOnServerOperation(this, runAsync, runnableCommand);
                return this.runOperation(operation);
            }
            return this.super$executeStatement(statement, confOverlay, runAsync, queryTimeout);
        });
    }

    public static final /* synthetic */ boolean $anonfun$openEngineSession$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$9(KyuubiSessionImpl $this, String e) {
        $this.sessionEvent().engineId_$eq(e);
    }

    public static final /* synthetic */ void $anonfun$openEngineSession$2(KyuubiSessionImpl $this, Option extraEngineLog$1, DiscoveryClient discoveryClient) {
        scala.collection.immutable.Map openEngineSessionConf = $this.optimizedConf().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.handle"), (Object)$this.handle().identifier().toString())})));
        if (new StringOps(Predef$.MODULE$.augmentString($this.engineCredentials())).nonEmpty()) {
            $this.sessionConf.set("kyuubi.engine.credentials", $this.engineCredentials());
            openEngineSessionConf = openEngineSessionConf.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.engine.credentials"), (Object)$this.engineCredentials())})));
        }
        if (BoxesRunTime.unboxToBoolean((Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()))) {
            openEngineSessionConf = openEngineSessionConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED().key()), (Object)$this.sessionConf.get(KyuubiConf$.MODULE$.SESSION_USER_SIGN_ENABLED()).toString())).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.sign.publickey"), (Object)Base64.getEncoder().encodeToString(((KyuubiSessionManager)$this.super$sessionManager()).signingPublicKey().getEncoded()))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.user.sign"), (Object)$this.sessionUserSignBase64()));
        }
        int maxAttempts = BoxesRunTime.unboxToInt((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_MAX_ATTEMPTS()));
        long retryWait = BoxesRunTime.unboxToLong((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_OPEN_RETRY_WAIT()));
        IntRef attempt = IntRef.create((int)0);
        boolean shouldRetry = true;
        while (attempt.elem <= maxAttempts && shouldRetry) {
            Tuple2<String, Object> tuple2 = $this.engine().getOrCreate(discoveryClient, (Option<OperationLog>)extraEngineLog$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)port));
            String host2 = (String)tuple22._1();
            int port2 = tuple22._2$mcI$sp();
            try {
                try {
                    String passwd = BoxesRunTime.unboxToBoolean((Object)((KyuubiSessionManager)$this.super$sessionManager()).getConf().get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED())) ? InternalSecurityAccessor$.MODULE$.get().issueToken() : (String)Option$.MODULE$.apply((Object)$this.super$password()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionImpl.$anonfun$openEngineSession$3(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
                    $this._client_$eq(KyuubiSyncThriftClient$.MODULE$.createClient($this.super$user(), passwd, host2, port2, $this.sessionConf));
                    $this._engineSessionHandle_$eq($this._client().openSession($this.super$protocol(), $this.super$user(), passwd, (scala.collection.immutable.Map<String, String>)openEngineSessionConf));
                    $this.logSessionInfo(new StringBuilder(33).append("Connected to engine [").append(host2).append(":").append(port2).append("]/[").append($this.client().engineId().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("]").append(" with ").append($this._engineSessionHandle()).append("]").toString());
                    shouldRetry = false;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof TTransportException) {
                        TTransportException tTransportException = (TTransportException)throwable2;
                        if (attempt.elem < maxAttempts && tTransportException.getCause() instanceof ConnectException && tTransportException.getCause().getMessage().contains("Connection refused")) {
                            $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Failed to open [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("] after").append(" ").append(attempt$1.elem).append("/").append(maxAttempts).append(" times, retrying").toString(), tTransportException.getCause());
                            Thread.sleep(retryWait);
                            shouldRetry = true;
                            continue;
                        }
                    }
                    if (throwable2 != null) {
                        Throwable throwable3 = throwable2;
                        $this.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Opening engine [").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").append(" for ").append($this.super$user()).append(" session failed").toString(), throwable3);
                        $this.openSessionError_$eq((Option<Throwable>)new Some((Object)throwable3));
                        throw throwable3;
                    }
                    throw throwable;
                }
            }
            finally {
                ++attempt.elem;
                if (!shouldRetry || $this._client() == null) continue;
                try {
                    $this._client().closeSession();
                }
                catch (Throwable e2) {
                    $this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Error on closing broken client of engine ").append("[").append($this.engine().defaultEngineName()).append(" ").append(host2).append(":").append(port2).append("]").toString(), e2);
                }
            }
        }
        $this.sessionEvent().openedTime_$eq(System.currentTimeMillis());
        $this.sessionEvent().remoteSessionId_$eq($this._engineSessionHandle().identifier().toString());
        $this._client().engineId().foreach((Function1 & Serializable & scala.Serializable)e -> {
            KyuubiSessionImpl.$anonfun$openEngineSession$9($this, e);
            return BoxedUnit.UNIT;
        });
        EventBus$.MODULE$.post((KyuubiEvent)$this.sessionEvent());
    }

    public static final /* synthetic */ void $anonfun$waitForEngineLaunched$1(KyuubiSessionImpl $this, Operation op) {
        long waitingStartTime = System.currentTimeMillis();
        $this.logSessionInfo("Starting to wait the launch engine operation finished");
        op.getBackgroundHandle().get();
        long elapsedTime = System.currentTimeMillis() - waitingStartTime;
        $this.logSessionInfo(new StringBuilder(42).append("Engine has been launched, elapsed time: ").append(elapsedTime / 1000L).append(" s").toString());
        if ($this._engineSessionHandle() == null) {
            KyuubiSQLException ex = (KyuubiSQLException)op.getStatus().exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> KyuubiSQLException$.MODULE$.apply(new StringBuilder(28).append("Failed to launch engine for ").append($this.handle()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4()));
            throw ex;
        }
        $this.engineLaunched_$eq(true);
    }

    public static final /* synthetic */ void $anonfun$close$1(KyuubiSessionImpl $this, Throwable x$3) {
        if ($this.engine() != null) {
            $this.engine().close();
            return;
        }
    }

    public KyuubiSessionImpl(TProtocolVersion protocol, String user, String password, String ipAddress, scala.collection.immutable.Map<String, String> conf, KyuubiSessionManager sessionManager, KyuubiConf sessionConf, KyuubiParser parser) {
        scala.collection.immutable.Map map;
        this.sessionConf = sessionConf;
        this.parser = parser;
        super(protocol, user, password, ipAddress, conf, sessionManager);
        this.sessionType = SessionType$.MODULE$.INTERACTIVE();
        java.util.Map confOverlay = ((KyuubiSessionManager)super.sessionManager()).sessionConfAdvisor().getConfOverlay(super.user(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.normalizedConf()).asJava());
        if (confOverlay != null) {
            map = this.normalizedConf().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(confOverlay).asScala());
        } else {
            this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("the server plugin return null value for user: ").append(this.super$user()).append(", ignore it").toString());
            map = this.normalizedConf();
        }
        this.optimizedConf = map;
        this.optimizedConf().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            String string2;
            String string3;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && "use:catalog".equals(string3 = (String)tuple2._1())) {
                return BoxedUnit.UNIT;
            }
            if (tuple2 != null && "use:database".equals(string2 = (String)tuple2._1())) {
                return BoxedUnit.UNIT;
            }
            if (tuple2 != null && "kyuubi.engine.pool.size.threshold".equals(string = (String)tuple2._1())) {
                return BoxedUnit.UNIT;
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return $this.sessionConf.set(key, value);
            }
            throw new MatchError((Object)tuple2);
        });
        this.launchEngineOp = ((KyuubiSessionManager)super.sessionManager()).operationManager().newLaunchEngineOperation(this, BoxesRunTime.unboxToBoolean((Object)sessionConf.get(KyuubiConf$.MODULE$.SESSION_ENGINE_LAUNCH_ASYNC())));
        this.sessionEvent = KyuubiSessionEvent$.MODULE$.apply(this);
        EventBus$.MODULE$.post((KyuubiEvent)this.sessionEvent());
        this.openSessionError = None$.MODULE$;
        this.engineLaunched = false;
    }
}

