/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import io.grpc.ChannelCredentials;
import io.grpc.Internal;
import io.grpc.ManagedChannelProvider;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.NettyChannelProvider;
import io.grpc.netty.Utils;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;

@Internal
public final class UdsNettyChannelProvider
extends ManagedChannelProvider {
    public boolean isAvailable() {
        return Utils.EPOLL_DOMAIN_CLIENT_CHANNEL_TYPE != null;
    }

    public int priority() {
        return 3;
    }

    public NettyChannelBuilder builderForAddress(String name, int port) {
        throw new AssertionError((Object)"NettyChannelProvider shadows this implementation");
    }

    public NettyChannelBuilder builderForTarget(String target) {
        throw new AssertionError((Object)"NettyChannelProvider shadows this implementation");
    }

    public ManagedChannelProvider.NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
        ManagedChannelProvider.NewChannelBuilderResult result = new NettyChannelProvider().newChannelBuilder(target, creds);
        if (result.getChannelBuilder() != null) {
            ((NettyChannelBuilder)result.getChannelBuilder()).eventLoopGroupPool((ObjectPool<? extends EventLoopGroup>)SharedResourcePool.forResource(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP)).channelType(Utils.EPOLL_DOMAIN_CLIENT_CHANNEL_TYPE);
        }
        return result;
    }

    protected Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

