/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkItem;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.JavaType;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.hadoop.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DiskBalancerWorkStatus {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ObjectMapper MAPPER_WITH_INDENT_OUTPUT = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private static final ObjectReader READER_WORKSTATUS = new ObjectMapper().readerFor(DiskBalancerWorkStatus.class);
    private static final ObjectReader READER_WORKENTRY = new ObjectMapper().readerFor((JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, DiskBalancerWorkEntry.class));
    private final List<DiskBalancerWorkEntry> currentState;
    private Result result;
    private String planID;
    private String planFile;

    public DiskBalancerWorkStatus() {
        this.currentState = new LinkedList<DiskBalancerWorkEntry>();
    }

    public DiskBalancerWorkStatus(Result result, String planID, String planFile) {
        this();
        this.result = result;
        this.planID = planID;
        this.planFile = planFile;
    }

    public DiskBalancerWorkStatus(Result result, String planID, List<DiskBalancerWorkEntry> currentState) {
        this.result = result;
        this.planID = planID;
        this.currentState = currentState;
    }

    public DiskBalancerWorkStatus(Result result, String planID, String planFile, String currentState) throws IOException {
        this.result = result;
        this.planID = planID;
        this.planFile = planFile;
        this.currentState = (List)READER_WORKENTRY.readValue(currentState);
    }

    public Result getResult() {
        return this.result;
    }

    public String getPlanID() {
        return this.planID;
    }

    public String getPlanFile() {
        return this.planFile;
    }

    public List<DiskBalancerWorkEntry> getCurrentState() {
        return this.currentState;
    }

    public String currentStateString() throws IOException {
        return MAPPER_WITH_INDENT_OUTPUT.writeValueAsString(this.currentState);
    }

    public String toJsonString() throws IOException {
        return MAPPER.writeValueAsString((Object)this);
    }

    public static DiskBalancerWorkStatus parseJson(String json) throws IOException {
        return (DiskBalancerWorkStatus)READER_WORKSTATUS.readValue(json);
    }

    public void addWorkEntry(DiskBalancerWorkEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        this.currentState.add(entry);
    }

    public static class DiskBalancerWorkEntry {
        private String sourcePath;
        private String destPath;
        private DiskBalancerWorkItem workItem;

        public DiskBalancerWorkEntry() {
        }

        public DiskBalancerWorkEntry(String workItem) throws IOException {
            this.workItem = DiskBalancerWorkItem.parseJson(workItem);
        }

        public DiskBalancerWorkEntry(String sourcePath, String destPath, DiskBalancerWorkItem workItem) {
            this.sourcePath = sourcePath;
            this.destPath = destPath;
            this.workItem = workItem;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public String getDestPath() {
            return this.destPath;
        }

        public void setDestPath(String destPath) {
            this.destPath = destPath;
        }

        public DiskBalancerWorkItem getWorkItem() {
            return this.workItem;
        }

        public void setWorkItem(DiskBalancerWorkItem workItem) {
            this.workItem = workItem;
        }
    }

    public static enum Result {
        NO_PLAN(0),
        PLAN_UNDER_PROGRESS(1),
        PLAN_DONE(2),
        PLAN_CANCELLED(3);

        private int result;

        private Result(int result) {
            this.result = result;
        }

        public int getIntResult() {
            return this.result;
        }
    }
}

