/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.schema;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TBinaryColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TByteColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TRow;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.kyuubi.util.RowSetUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.HiveResult;
import org.apache.spark.sql.execution.HiveResult$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class RowSet$ {
    public static RowSet$ MODULE$;

    static {
        new RowSet$();
    }

    public String toHiveString(Tuple2<Object, DataType> valueAndType, boolean nested) {
        HiveResult.TimeFormatters timeFormatters = HiveResult$.MODULE$.getTimeFormatters();
        return HiveResult$.MODULE$.toHiveString(valueAndType, nested, timeFormatters);
    }

    public boolean toHiveString$default$2() {
        return false;
    }

    public TRowSet toTRowSet(byte[] bytes, TProtocolVersion protocolVersion) {
        if (protocolVersion.getValue() < TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue()) {
            throw new UnsupportedOperationException();
        }
        return this.toColumnBasedSet(bytes);
    }

    public TRowSet emptyTRowSet() {
        return new TRowSet(0L, new ArrayList<TRow>(0));
    }

    public TRowSet toColumnBasedSet(byte[] data) {
        TRowSet tRowSet = new TRowSet(0L, new ArrayList<TRow>(1));
        TColumn tColumn = this.toTColumn(data);
        tRowSet.addToColumns(tColumn);
        return tRowSet;
    }

    public TRowSet toTRowSet(Seq<Row> rows, StructType schema, TProtocolVersion protocolVersion) {
        if (protocolVersion.getValue() < TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue()) {
            return this.toRowBasedSet(rows, schema);
        }
        return this.toColumnBasedSet(rows, schema);
    }

    public TRowSet toRowBasedSet(Seq<Row> rows, StructType schema) {
        int rowSize = rows.length();
        ArrayList<TRow> tRows = new ArrayList<TRow>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            Row row = (Row)rows.apply(i);
            TRow tRow = new TRow();
            int columnSize = row.length();
            for (int j = 0; j < columnSize; ++j) {
                TColumnValue columnValue = this.toTColumnValue(j, row, schema);
                tRow.addToColVals(columnValue);
            }
            tRows.add(tRow);
        }
        return new TRowSet(0L, tRows);
    }

    public TRowSet toColumnBasedSet(Seq<Row> rows, StructType schema) {
        int rowSize = rows.length();
        TRowSet tRowSet = new TRowSet(0L, new ArrayList<TRow>(rowSize));
        int columnSize = schema.length();
        for (int i = 0; i < columnSize; ++i) {
            StructField field = schema.apply(i);
            TColumn tColumn = this.toTColumn(rows, i, field.dataType());
            tRowSet.addToColumns(tColumn);
        }
        return tRowSet;
    }

    private TColumn toTColumn(Seq<Row> rows, int ordinal, DataType typ) {
        BitSet nulls = new BitSet();
        DataType dataType = typ;
        if (BooleanType$.MODULE$.equals(dataType)) {
            List<Boolean> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.boolean2Boolean(true));
            return TColumn.boolVal(new TBoolColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            List<Byte> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.byte2Byte((byte)0));
            return TColumn.byteVal(new TByteColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            List<Short> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.short2Short((short)0));
            return TColumn.i16Val(new TI16Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            List<Integer> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.int2Integer(0));
            return TColumn.i32Val(new TI32Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (LongType$.MODULE$.equals(dataType)) {
            List<Long> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.long2Long(0L));
            return TColumn.i64Val(new TI64Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            List values = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.float2Float(0.0f))).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Double.valueOf(n.toString()), Buffer$.MODULE$.canBuildFrom())).asJava();
            return TColumn.doubleVal(new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            List<Double> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.double2Double(0.0));
            return TColumn.doubleVal(new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            List<String> values = this.getOrSetAsNull(rows, ordinal, nulls, "");
            return TColumn.stringVal(new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            List values = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ByteBuffer.wrap(x$1), Buffer$.MODULE$.canBuildFrom())).asJava();
            return TColumn.binaryVal(new TBinaryColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        int rowSize = rows.length();
        ArrayList<String> values = new ArrayList<String>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            Row row = (Row)rows.apply(i);
            nulls.set(i, row.isNullAt(ordinal));
            values.add(this.toHiveString((Tuple2<Object, DataType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(row.get(ordinal)), (Object)typ), this.toHiveString$default$2()));
        }
        return TColumn.stringVal(new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
    }

    private <T> List<T> getOrSetAsNull(Seq<Row> rows, int ordinal, BitSet nulls, T defaultVal) {
        int size = rows.length();
        ArrayList<Object> ret = new ArrayList<Object>(size);
        for (int idx = 0; idx < size; ++idx) {
            Row row = (Row)rows.apply(idx);
            boolean isNull = row.isNullAt(ordinal);
            if (isNull) {
                nulls.set(idx, true);
                ret.add(idx, defaultVal);
                continue;
            }
            ret.add(idx, row.getAs(ordinal));
        }
        return ret;
    }

    private TColumnValue toTColumnValue(int ordinal, Row row, StructType types) {
        TStringValue tStrValue;
        block16: {
            DataType dataType = types.apply(ordinal).dataType();
            if (BooleanType$.MODULE$.equals(dataType)) {
                TBoolValue boolValue = new TBoolValue();
                if (!row.isNullAt(ordinal)) {
                    boolValue.setValue(row.getBoolean(ordinal));
                }
                return TColumnValue.boolVal(boolValue);
            }
            if (ByteType$.MODULE$.equals(dataType)) {
                TByteValue byteValue = new TByteValue();
                if (!row.isNullAt(ordinal)) {
                    byteValue.setValue(row.getByte(ordinal));
                }
                return TColumnValue.byteVal(byteValue);
            }
            if (ShortType$.MODULE$.equals(dataType)) {
                TI16Value tI16Value = new TI16Value();
                if (!row.isNullAt(ordinal)) {
                    tI16Value.setValue(row.getShort(ordinal));
                }
                return TColumnValue.i16Val(tI16Value);
            }
            if (IntegerType$.MODULE$.equals(dataType)) {
                TI32Value tI32Value = new TI32Value();
                if (!row.isNullAt(ordinal)) {
                    tI32Value.setValue(row.getInt(ordinal));
                }
                return TColumnValue.i32Val(tI32Value);
            }
            if (LongType$.MODULE$.equals(dataType)) {
                TI64Value tI64Value = new TI64Value();
                if (!row.isNullAt(ordinal)) {
                    tI64Value.setValue(row.getLong(ordinal));
                }
                return TColumnValue.i64Val(tI64Value);
            }
            if (FloatType$.MODULE$.equals(dataType)) {
                TDoubleValue tDoubleValue = new TDoubleValue();
                if (!row.isNullAt(ordinal)) {
                    Double doubleValue = Double.valueOf(Float.toString(row.getFloat(ordinal)));
                    tDoubleValue.setValue(Predef$.MODULE$.Double2double(doubleValue));
                }
                return TColumnValue.doubleVal(tDoubleValue);
            }
            if (DoubleType$.MODULE$.equals(dataType)) {
                TDoubleValue tDoubleValue = new TDoubleValue();
                if (!row.isNullAt(ordinal)) {
                    tDoubleValue.setValue(row.getDouble(ordinal));
                }
                return TColumnValue.doubleVal(tDoubleValue);
            }
            if (StringType$.MODULE$.equals(dataType)) {
                TStringValue tStringValue = new TStringValue();
                if (!row.isNullAt(ordinal)) {
                    tStringValue.setValue(row.getString(ordinal));
                }
                return TColumnValue.stringVal(tStringValue);
            }
            tStrValue = new TStringValue();
            if (row.isNullAt(ordinal)) break block16;
            tStrValue.setValue(this.toHiveString((Tuple2<Object, DataType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(row.get(ordinal)), (Object)types.apply(ordinal).dataType()), this.toHiveString$default$2()));
        }
        return TColumnValue.stringVal(tStrValue);
    }

    private TColumn toTColumn(byte[] data) {
        ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>(1);
        values.add(ByteBuffer.wrap(data));
        BitSet nulls = new BitSet();
        return TColumn.binaryVal(new TBinaryColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
    }

    private RowSet$() {
        MODULE$ = this;
    }
}

