/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.AuthMethods$;
import org.apache.kyuubi.service.authentication.AuthTypes$;
import org.apache.kyuubi.service.authentication.FEServiceProcessorFactory;
import org.apache.kyuubi.service.authentication.HadoopThriftAuthBridgeServer;
import org.apache.kyuubi.service.authentication.InternalSecurityAccessor$;
import org.apache.kyuubi.service.authentication.KyuubiAuthenticationFactory$;
import org.apache.kyuubi.service.authentication.KyuubiDelegationTokenManager;
import org.apache.kyuubi.service.authentication.KyuubiDelegationTokenManager$;
import org.apache.kyuubi.service.authentication.PlainSASLHelper$;
import org.apache.kyuubi.service.authentication.SaslQOP$;
import org.apache.kyuubi.service.authentication.TSetIpAddressProcessor$;
import org.apache.kyuubi.shade.org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.kyuubi.shade.org.apache.thrift.TProcessorFactory;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TSaslServerTransport;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TTransportException;
import org.apache.kyuubi.shade.org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001db\u0001B\u0011#\u00015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\")1\t\u0001C\u0001\t\"9\u0011\n\u0001b\u0001\n\u0013Q\u0005BB-\u0001A\u0003%1\nC\u0004[\u0001\t\u0007I\u0011B.\t\rq\u0003\u0001\u0015!\u0003A\u0011\u001di\u0006A1A\u0005\nmCaA\u0018\u0001!\u0002\u0013\u0001\u0005bB0\u0001\u0005\u0004%Ia\u0017\u0005\u0007A\u0002\u0001\u000b\u0011\u0002!\t\u000f\u0005\u0004!\u0019!C\u0005E\"1a\r\u0001Q\u0001\n\rDqa\u001a\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004n\u0001\u0001\u0006I!\u001b\u0005\u0006]\u0002!Ia\u001c\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!!\u0018\u0001\t\u0003\ty\u0006C\u0004\u0002d\u0001!\t!a\u0018\t\r\u0005\u0015\u0004\u0001\"\u0001\\\u0011\u0019\t9\u0007\u0001C\u00017\"1\u0011\u0011\u000e\u0001\u0005\u0002mCa!a\u001b\u0001\t\u0003Y\u0006bBA7\u0001\u0011\u0005\u0011qN\u0004\b\u0003\u0017\u0013\u0003\u0012AAG\r\u0019\t#\u0005#\u0001\u0002\u0010\"11i\u0007C\u0001\u0003#C\u0011\"a%\u001c\u0005\u0004%\t!!&\t\u0011\u0005\u00056\u0004)A\u0005\u0003/Cq!a)\u001c\t\u0003\t)\u000bC\u0005\u0003\u0010m\t\n\u0011\"\u0001\u0003\u0012\tY2*_;vE&\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015m\u0019;pefT!a\t\u0013\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011QEJ\u0001\bg\u0016\u0014h/[2f\u0015\t9\u0003&\u0001\u0004lsV,(-\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kYj\u0011AJ\u0005\u0003o\u0019\u0012q\u0001T8hO&tw-\u0001\u0003d_:4\u0007C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f'\u0003\u0019\u0019wN\u001c4jO&\u0011ah\u000f\u0002\u000b\u0017f,XOY5D_:4\u0017\u0001C5t'\u0016\u0014h/\u001a:\u0011\u0005=\n\u0015B\u0001\"1\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDcA#H\u0011B\u0011a\tA\u0007\u0002E!)\u0001h\u0001a\u0001s!9qh\u0001I\u0001\u0002\u0004\u0001\u0015!C1vi\"$\u0016\u0010]3t+\u0005Y\u0005c\u0001'P#6\tQJ\u0003\u0002Oa\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Ak%aA*fcB\u0011!+\u0016\b\u0003\rNK!\u0001\u0016\u0012\u0002\u0013\u0005+H\u000f\u001b+za\u0016\u001c\u0018B\u0001,X\u0005\u00151\u0016\r\\;f\u0013\tA\u0006GA\u0006F]VlWM]1uS>t\u0017AC1vi\"$\u0016\u0010]3tA\u0005!an\u001c8f+\u0005\u0001\u0015!\u00028p]\u0016\u0004\u0013A\u00028p'\u0006\u001cH.A\u0004o_N\u000b7\u000f\u001c\u0011\u0002\u001f-,'OY3s_N,e.\u00192mK\u0012\f\u0001c[3sE\u0016\u0014xn]#oC\ndW\r\u001a\u0011\u0002!Ad\u0017-\u001b8BkRDG+\u001f9f\u001fB$X#A2\u0011\u0007=\"\u0017+\u0003\u0002fa\t1q\n\u001d;j_:\f\u0011\u0003\u001d7bS:\fU\u000f\u001e5UsB,w\n\u001d;!\u0003AA\u0017\rZ8pa\u0006+H\u000f[*feZ,'/F\u0001j!\ryCM\u001b\t\u0003\r.L!\u0001\u001c\u0012\u00039!\u000bGm\\8q)\"\u0014\u0018N\u001a;BkRD'I]5eO\u0016\u001cVM\u001d<fe\u0006\t\u0002.\u00193p_B\fU\u000f\u001e5TKJ4XM\u001d\u0011\u0002#\u001d,GoU1tYB\u0013x\u000e]3si&,7/F\u0001q!\u0011\th\u000f\u001f=\u000e\u0003IT!a\u001d;\u0002\tU$\u0018\u000e\u001c\u0006\u0002k\u0006!!.\u0019<b\u0013\t9(OA\u0002NCB\u00042!_A\u0001\u001d\tQh\u0010\u0005\u0002|a5\tAP\u0003\u0002~Y\u00051AH]8pizJ!a \u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019!!\u0002\u0003\rM#(/\u001b8h\u0015\ty\b'\u0001\u000bhKR$FK]1ogB|'\u000f\u001e$bGR|'/_\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005ue\u0006t7\u000f]8si*\u0019\u0011Q\u0003\u0015\u0002\rQD'/\u001b4u\u0013\u0011\tI\"a\u0004\u0003#Q#&/\u00198ta>\u0014HOR1di>\u0014\u00180\u0001\u000bhKR$\u0006K]8dKN\u001cxN\u001d$bGR|'/\u001f\u000b\u0005\u0003?\t9\u0003\u0005\u0003\u0002\"\u0005\rRBAA\n\u0013\u0011\t)#a\u0005\u0003#Q\u0003&o\\2fgN|'OR1di>\u0014\u0018\u0010C\u0004\u0002*I\u0001\r!a\u000b\u0002\u0005\u0019,\u0007\u0003BA\u0017\u0003/rA!a\f\u0002R9!\u0011\u0011GA'\u001d\u0011\t\u0019$a\u0012\u000f\t\u0005U\u00121\t\b\u0005\u0003o\tyD\u0004\u0003\u0002:\u0005ubbA>\u0002<%\t1&\u0003\u0002*U%\u0019\u0011\u0011\t\u0015\u0002\t!Lg/Z\u0005\u0004K\u0005\u0015#bAA!Q%!\u0011\u0011JA&\u0003\r\u0011\bo\u0019\u0006\u0004K\u0005\u0015\u0013\u0002BA\u000b\u0003\u001fRA!!\u0013\u0002L%!\u00111KA+\u0003-!6\tT%TKJ4\u0018nY3\u000b\t\u0005U\u0011qJ\u0005\u0005\u00033\nYFA\u0003JM\u0006\u001cWM\u0003\u0003\u0002T\u0005U\u0013!D4fiJ+Wn\u001c;f+N,'/\u0006\u0002\u0002bA\u0019q\u0006\u001a=\u0002\u0019\u001d,G/\u00139BI\u0012\u0014Xm]:\u0002\u001f%\u001chj\\*bg2,e.\u00192mK\u0012\f\u0011#[:LKJ\u0014WM]8t\u000b:\f'\r\\3e\u0003II7\u000f\u00157bS:\fU\u000f\u001e5F]\u0006\u0014G.\u001a3\u0002\u001b%\u001chj\u001c8f\u000b:\f'\r\\3e\u0003i9W\r\u001e,bY&$\u0007+Y:to>\u0014H-Q;uQ6+G\u000f[8e+\t\t\t\b\u0005\u0003\u0002t\u0005\u0015e\u0002BA;\u0003\u0003sA!a\u001e\u0002\u00009!\u0011\u0011PA?\u001d\u0011\t9$a\u001f\n\u0005\u001dB\u0013BA\u0013'\u0013\t\u0019C%C\u0002\u0002\u0004\n\n1\"Q;uQ6+G\u000f[8eg&!\u0011qQAE\u0005)\tU\u000f\u001e5NKRDw\u000e\u001a\u0006\u0004\u0003\u0007\u0013\u0013aG&zkV\u0014\u0017.Q;uQ\u0016tG/[2bi&|gNR1di>\u0014\u0018\u0010\u0005\u0002G7M\u00111D\f\u000b\u0003\u0003\u001b\u000ba\u0002S*3?B\u0013v\nW-`+N+%+\u0006\u0002\u0002\u0018B!\u0011\u0011TAP\u001b\t\tYJC\u0002\u0002\u001eR\fA\u0001\\1oO&!\u00111AAN\u0003=A5KM0Q%>C\u0016lX+T\u000bJ\u0003\u0013!\u0005<fe&4\u0017\u0010\u0015:pqf\f5mY3tgRQ\u0011qUAW\u0003c\u000b),!/\u0011\u0007=\nI+C\u0002\u0002,B\u0012A!\u00168ji\"1\u0011qV\u0010A\u0002a\f\u0001B]3bYV\u001bXM\u001d\u0005\u0007\u0003g{\u0002\u0019\u0001=\u0002\u0013A\u0014x\u000e_=Vg\u0016\u0014\bBBA\\?\u0001\u0007\u00010A\u0005ja\u0006#GM]3tg\"9\u00111X\u0010A\u0002\u0005u\u0016A\u00035bI>|\u0007oQ8oMB!\u0011qXAd\u001b\t\t\tMC\u00029\u0003\u0007T1!!2)\u0003\u0019A\u0017\rZ8pa&!\u0011\u0011ZAa\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"*q$!4\u0002ZB)q&a4\u0002T&\u0019\u0011\u0011\u001b\u0019\u0003\rQD'o\\<t!\r)\u0014Q[\u0005\u0004\u0003/4#AE&zkV\u0014\u0017nU)M\u000bb\u001cW\r\u001d;j_:\fdA\b=\u0002\\\n5\u0011'C\u0012\u0002^\u0006\u0015(1AAt+\u0011\ty.!9\u0016\u0003a$q!a9-\u0005\u0004\tiOA\u0001U\u0013\u0011\t9/!;\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tY\u000fM\u0001\u0007i\"\u0014xn^:\u0012\t\u0005=\u0018Q\u001f\t\u0004_\u0005E\u0018bAAza\t9aj\u001c;iS:<\u0007\u0003BA|\u0003{t1aLA}\u0013\r\tY\u0010M\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tyP!\u0001\u0003\u0013QC'o\\<bE2,'bAA~aEJ1E!\u0002\u0003\b\t%\u00111\u001e\b\u0004_\t\u001d\u0011bAAvaE*!e\f\u0019\u0003\f\t)1oY1mCF\u001aa%a5\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019BK\u0002A\u0005+Y#Aa\u0006\u0011\t\te!1E\u0007\u0003\u00057QAA!\b\u0003 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005C\u0001\u0014AC1o]>$\u0018\r^5p]&!!Q\u0005B\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class KyuubiAuthenticationFactory
implements Logging {
    private final KyuubiConf conf;
    private final boolean isServer;
    private final Seq<Enumeration.Value> authTypes;
    private final boolean none;
    private final boolean noSasl;
    private final boolean kerberosEnabled;
    private final Option<Enumeration.Value> plainAuthTypeOpt;
    private final Option<HadoopThriftAuthBridgeServer> hadoopAuthServer;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return KyuubiAuthenticationFactory$.MODULE$.$lessinit$greater$default$2();
    }

    public static void verifyProxyAccess(String string, String string2, String string3, Configuration configuration) throws KyuubiSQLException {
        KyuubiAuthenticationFactory$.MODULE$.verifyProxyAccess(string, string2, string3, configuration);
    }

    public static String HS2_PROXY_USER() {
        return KyuubiAuthenticationFactory$.MODULE$.HS2_PROXY_USER();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private Seq<Enumeration.Value> authTypes() {
        return this.authTypes;
    }

    private boolean none() {
        return this.none;
    }

    private boolean noSasl() {
        return this.noSasl;
    }

    private boolean kerberosEnabled() {
        return this.kerberosEnabled;
    }

    private Option<Enumeration.Value> plainAuthTypeOpt() {
        return this.plainAuthTypeOpt;
    }

    private Option<HadoopThriftAuthBridgeServer> hadoopAuthServer() {
        return this.hadoopAuthServer;
    }

    private Map<String, String> getSaslProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Enumeration.Value qop = SaslQOP$.MODULE$.withName(this.conf.get(KyuubiConf$.MODULE$.SASL_QOP()));
        props.put("javax.security.sasl.qop", qop.toString());
        props.put("javax.security.sasl.server.authentication", "true");
        return props;
    }

    public TTransportFactory getTTransportFactory() {
        if (this.noSasl()) {
            return new TTransportFactory();
        }
        TSaslServerTransport.Factory transportFactory = null;
        Option<HadoopThriftAuthBridgeServer> option = this.hadoopAuthServer();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopThriftAuthBridgeServer server = (HadoopThriftAuthBridgeServer)some.value();
            transportFactory = this.liftedTree2$1(server);
        }
        Option<Enumeration.Value> option2 = this.plainAuthTypeOpt();
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Enumeration.Value plainAuthType = (Enumeration.Value)some.value();
            transportFactory = (TSaslServerTransport.Factory)PlainSASLHelper$.MODULE$.getTransportFactory(plainAuthType.toString(), this.conf, (Option<TSaslServerTransport.Factory>)Option$.MODULE$.apply((Object)transportFactory), this.isServer);
        }
        Option<HadoopThriftAuthBridgeServer> option3 = this.hadoopAuthServer();
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            HadoopThriftAuthBridgeServer server = (HadoopThriftAuthBridgeServer)some.value();
            return server.wrapTransportFactory(transportFactory);
        }
        return transportFactory;
    }

    public TProcessorFactory getTProcessorFactory(TCLIService.Iface fe) {
        Option<HadoopThriftAuthBridgeServer> option = this.hadoopAuthServer();
        if (option instanceof Some) {
            Some some = (Some)option;
            HadoopThriftAuthBridgeServer server = (HadoopThriftAuthBridgeServer)some.value();
            return new FEServiceProcessorFactory(server, fe);
        }
        return PlainSASLHelper$.MODULE$.getProcessFactory(fe);
    }

    public Option<String> getRemoteUser() {
        return this.hadoopAuthServer().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getRemoteUser()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)TSetIpAddressProcessor$.MODULE$.getUserName()));
    }

    public Option<String> getIpAddress() {
        return this.hadoopAuthServer().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getRemoteAddress()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getHostAddress()).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)TSetIpAddressProcessor$.MODULE$.getUserIpAddress()));
    }

    public boolean isNoSaslEnabled() {
        return this.noSasl();
    }

    public boolean isKerberosEnabled() {
        return this.kerberosEnabled();
    }

    public boolean isPlainAuthEnabled() {
        return this.plainAuthTypeOpt().isDefined();
    }

    public boolean isNoneEnabled() {
        return this.none();
    }

    public Enumeration.Value getValidPasswordAuthMethod() {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> this.authTypes());
        if (this.none()) {
            return AuthMethods$.MODULE$.NONE();
        }
        if (this.authTypes().contains((Object)AuthTypes$.MODULE$.LDAP())) {
            return AuthMethods$.MODULE$.LDAP();
        }
        if (this.authTypes().contains((Object)AuthTypes$.MODULE$.JDBC())) {
            return AuthMethods$.MODULE$.JDBC();
        }
        if (this.authTypes().contains((Object)AuthTypes$.MODULE$.CUSTOM())) {
            return AuthMethods$.MODULE$.CUSTOM();
        }
        throw new IllegalArgumentException("No valid Password Auth detected");
    }

    private static final /* synthetic */ void liftedTree1$1(KyuubiDelegationTokenManager secretMgr$1) {
        try {
            secretMgr$1.startThreads();
        }
        catch (IOException e) {
            throw new TTransportException("Failed to start token manager", (Throwable)e);
        }
    }

    private final /* synthetic */ TSaslServerTransport.Factory liftedTree2$1(HadoopThriftAuthBridgeServer server$1) {
        TSaslServerTransport.Factory factory;
        try {
            factory = server$1.createSaslServerTransportFactory(this.getSaslProperties());
        }
        catch (TTransportException e) {
            throw new LoginException(e.getMessage());
        }
        return factory;
    }

    public KyuubiAuthenticationFactory(KyuubiConf conf, boolean isServer) {
        block2: {
            None$ none$;
            this.conf = conf;
            this.isServer = isServer;
            Logging.$init$(this);
            this.authTypes = (Seq)((TraversableLike)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_METHOD())).map((Function1 & Serializable & scala.Serializable)s -> AuthTypes$.MODULE$.withName((String)s), Seq$.MODULE$.canBuildFrom());
            this.none = this.authTypes().contains((Object)AuthTypes$.MODULE$.NONE());
            Seq<Enumeration.Value> seq = this.authTypes();
            .colon.colon colon2 = new .colon.colon((Object)AuthTypes$.MODULE$.NOSASL(), (List)Nil$.MODULE$);
            this.noSasl = !(seq != null ? !seq.equals((Object)colon2) : colon2 != null);
            this.kerberosEnabled = this.authTypes().contains((Object)AuthTypes$.MODULE$.KERBEROS());
            this.plainAuthTypeOpt = ((TraversableLike)((TraversableLike)this.authTypes().filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals((Object)AuthTypes$.MODULE$.KERBEROS())))).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.equals((Object)AuthTypes$.MODULE$.NOSASL())))).headOption();
            if (this.kerberosEnabled()) {
                KyuubiDelegationTokenManager secretMgr = KyuubiDelegationTokenManager$.MODULE$.apply(conf);
                KyuubiAuthenticationFactory.liftedTree1$1(secretMgr);
                none$ = new Some((Object)new HadoopThriftAuthBridgeServer(secretMgr));
            } else {
                none$ = this.hadoopAuthServer = None$.MODULE$;
            }
            if (!BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED()))) break block2;
            InternalSecurityAccessor$.MODULE$.initialize(conf, isServer);
        }
    }
}

