/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.io.etcd.jetcd.Maintenance;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.AlarmRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.DefragmentRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.HashKVRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MaintenanceGrpc;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.MoveLeaderRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.SnapshotRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.StatusRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.VertxMaintenanceGrpc;
import org.apache.kyuubi.shade.io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.ClientConnectionManager;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.Impl;
import org.apache.kyuubi.shade.io.etcd.jetcd.maintenance.AlarmMember;
import org.apache.kyuubi.shade.io.etcd.jetcd.maintenance.AlarmResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.maintenance.AlarmType;
import org.apache.kyuubi.shade.io.etcd.jetcd.maintenance.DefragmentResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.maintenance.HashKVResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.maintenance.MoveLeaderResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.maintenance.SnapshotResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.maintenance.StatusResponse;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Util;
import org.apache.kyuubi.shade.io.grpc.stub.StreamObserver;

final class MaintenanceImpl
extends Impl
implements Maintenance {
    private final VertxMaintenanceGrpc.MaintenanceVertxStub stub = this.connectionManager().newStub(VertxMaintenanceGrpc::newVertxStub);

    MaintenanceImpl(ClientConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    public CompletableFuture<AlarmResponse> listAlarms() {
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(org.apache.kyuubi.shade.io.etcd.jetcd.api.AlarmType.NONE).setAction(AlarmRequest.AlarmAction.GET).setMemberID(0L).build();
        return this.completable(this.stub.alarm(alarmRequest), AlarmResponse::new);
    }

    @Override
    public CompletableFuture<AlarmResponse> alarmDisarm(AlarmMember member) {
        Preconditions.checkArgument(member.getMemberId() != 0L, "the member id can not be 0");
        Preconditions.checkArgument(member.getAlarmType() != AlarmType.NONE, "alarm type can not be NONE");
        AlarmRequest alarmRequest = AlarmRequest.newBuilder().setAlarm(org.apache.kyuubi.shade.io.etcd.jetcd.api.AlarmType.NOSPACE).setAction(AlarmRequest.AlarmAction.DEACTIVATE).setMemberID(member.getMemberId()).build();
        return this.completable(this.stub.alarm(alarmRequest), AlarmResponse::new);
    }

    @Override
    public CompletableFuture<DefragmentResponse> defragmentMember(URI endpoint) {
        return this.connectionManager().withNewChannel(endpoint.toString(), MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.defragment(DefragmentRequest.getDefaultInstance()), DefragmentResponse::new, this.connectionManager().getExecutorService()));
    }

    @Override
    public CompletableFuture<DefragmentResponse> defragmentMember(String target) {
        return this.connectionManager().withNewChannel(target, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.defragment(DefragmentRequest.getDefaultInstance()), DefragmentResponse::new, this.connectionManager().getExecutorService()));
    }

    @Override
    public CompletableFuture<StatusResponse> statusMember(URI endpoint) {
        return this.connectionManager().withNewChannel(endpoint.toString(), MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.status(StatusRequest.getDefaultInstance()), StatusResponse::new, this.connectionManager().getExecutorService()));
    }

    @Override
    public CompletableFuture<StatusResponse> statusMember(String target) {
        return this.connectionManager().withNewChannel(target, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.status(StatusRequest.getDefaultInstance()), StatusResponse::new, this.connectionManager().getExecutorService()));
    }

    @Override
    public CompletableFuture<MoveLeaderResponse> moveLeader(long transfereeID) {
        return this.completable(this.stub.moveLeader(MoveLeaderRequest.newBuilder().setTargetID(transfereeID).build()), MoveLeaderResponse::new);
    }

    @Override
    public CompletableFuture<HashKVResponse> hashKV(URI endpoint, long rev) {
        return this.connectionManager().withNewChannel(endpoint.toString(), MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.hashKV(HashKVRequest.newBuilder().setRevision(rev).build()), HashKVResponse::new, this.connectionManager().getExecutorService()));
    }

    @Override
    public CompletableFuture<HashKVResponse> hashKV(String target, long rev) {
        return this.connectionManager().withNewChannel(target, MaintenanceGrpc::newFutureStub, stub -> Util.toCompletableFuture(stub.hashKV(HashKVRequest.newBuilder().setRevision(rev).build()), HashKVResponse::new, this.connectionManager().getExecutorService()));
    }

    @Override
    public CompletableFuture<Long> snapshot(OutputStream outputStream) {
        CompletableFuture<Long> answer = new CompletableFuture<Long>();
        AtomicLong bytes = new AtomicLong(0L);
        this.stub.snapshot(SnapshotRequest.getDefaultInstance()).handler(r -> {
            try {
                r.getBlob().writeTo(outputStream);
                bytes.addAndGet(r.getBlob().size());
            }
            catch (IOException e) {
                answer.completeExceptionally(EtcdExceptionFactory.toEtcdException(e));
            }
        }).endHandler(event -> answer.complete(bytes.get())).exceptionHandler(e -> answer.completeExceptionally(EtcdExceptionFactory.toEtcdException(e)));
        return answer;
    }

    @Override
    public void snapshot(StreamObserver<SnapshotResponse> observer) {
        this.stub.snapshot(SnapshotRequest.getDefaultInstance()).handler(r -> observer.onNext(new SnapshotResponse((org.apache.kyuubi.shade.io.etcd.jetcd.api.SnapshotResponse)r))).endHandler(event -> observer.onCompleted()).exceptionHandler(e -> observer.onError(EtcdExceptionFactory.toEtcdException(e)));
    }
}

