/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.http.impl;

import org.apache.kyuubi.shade.io.vertx.core.net.ProxyOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.SocketAddress;

final class EndpointKey {
    final boolean ssl;
    final SocketAddress serverAddr;
    final SocketAddress peerAddr;
    final ProxyOptions proxyOptions;

    EndpointKey(boolean ssl, ProxyOptions proxyOptions, SocketAddress serverAddr, SocketAddress peerAddr) {
        if (serverAddr == null) {
            throw new NullPointerException("No null server address");
        }
        if (peerAddr == null) {
            throw new NullPointerException("No null peer address");
        }
        this.ssl = ssl;
        this.proxyOptions = proxyOptions;
        this.peerAddr = peerAddr;
        this.serverAddr = serverAddr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointKey that = (EndpointKey)o;
        return this.ssl == that.ssl && this.serverAddr.equals(that.serverAddr) && this.peerAddr.equals(that.peerAddr);
    }

    public int hashCode() {
        int result = this.ssl ? 1 : 0;
        result = 31 * result + this.peerAddr.hashCode();
        result = 31 * result + this.serverAddr.hashCode();
        return result;
    }
}

