/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kyuubi;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.operation.Operation;
import org.apache.spark.kyuubi.StageAttempt;
import org.apache.spark.kyuubi.StageInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\u000e\u001c\u0001\u0011B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007O\u0002\u0001\u000b\u0011B%\t\u000f!\u0004!\u0019!C\u0005S\"1Q\u000e\u0001Q\u0001\n)DqA\u001c\u0001A\u0002\u0013%a\rC\u0004p\u0001\u0001\u0007I\u0011\u00029\t\rY\u0004\u0001\u0015)\u0003J\u0011\u001d9\b\u00011A\u0005\naDqA \u0001A\u0002\u0013%q\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0015B=\t\u0013\u0005\u0015\u0001A1A\u0005\u0002\u0005\u001d\u0001\u0002CA\r\u0001\u0001\u0006I!!\u0003\t\u0013\u0005m\u0001A1A\u0005\n\u0005u\u0001\u0002CA\u0014\u0001\u0001\u0006I!a\b\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011Q\u0006\u0001\u0005\n\u0005=\u0002bBA&\u0001\u0011%\u00111\u0006\u0005\b\u0003\u001b\u0002A\u0011AA\u0016\u0005]\u0019\u0006/\u0019:l\u0007>t7o\u001c7f!J|wM]3tg\n\u000b'O\u0003\u0002\u001d;\u000511._;vE&T!AH\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\u0002\u0001'\r\u0001Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u00051rS\"A\u0017\u000b\u0005qy\u0012BA\u0018.\u0005\u001daunZ4j]\u001e\f\u0011b\u001c9fe\u0006$\u0018n\u001c8\u0011\u0005I\"T\"A\u001a\u000b\u0005Aj\u0013BA\u001b4\u0005%y\u0005/\u001a:bi&|g.\u0001\u0006mSZ,7\u000b^1hKN\u0004B\u0001O B\u000b6\t\u0011H\u0003\u0002;w\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005qj\u0014\u0001B;uS2T\u0011AP\u0001\u0005U\u00064\u0018-\u0003\u0002As\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0005\t\u001bU\"A\u000e\n\u0005\u0011[\"\u0001D*uC\u001e,\u0017\t\u001e;f[B$\bC\u0001\"G\u0013\t95DA\u0005Ti\u0006<W-\u00138g_\u0006\u0001R\u000f\u001d3bi\u0016\u0004VM]5pI6\u001bVm\u0019\t\u0003M)K!aS\u0014\u0003\t1{gnZ\u0001\u000bi&lWMR8s[\u0006$\bC\u0001(V\u001d\ty5\u000b\u0005\u0002QO5\t\u0011K\u0003\u0002SG\u00051AH]8pizJ!\u0001V\u0014\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)\u001e\na\u0001P5oSRtD#\u0002.\\9vs\u0006C\u0001\"\u0001\u0011\u0015\u0001T\u00011\u00012\u0011\u00151T\u00011\u00018\u0011\u0015AU\u00011\u0001J\u0011\u0015aU\u00011\u0001N\u0003\t\u0019%+F\u0001b!\t1#-\u0003\u0002dO\t!1\t[1s\u0003\r\u0019%\u000bI\u0001\u000fM&\u00148\u000f\u001e#fY\u0006LXjU3d+\u0005I\u0015a\u00044jeN$H)\u001a7bs6\u001bVm\u0019\u0011\u0002\u001bQ+'/\\5oC2<\u0016\u000e\u001a;i+\u0005Q\u0007C\u0001\u0014l\u0013\tawEA\u0002J]R\fa\u0002V3s[&t\u0017\r\\,jIRD\u0007%\u0001\bmCN$X\u000b\u001d3bi\u0016$\u0016.\\3\u0002%1\f7\u000f^+qI\u0006$X\rV5nK~#S-\u001d\u000b\u0003cR\u0004\"A\n:\n\u0005M<#\u0001B+oSRDq!^\u0007\u0002\u0002\u0003\u0007\u0011*A\u0002yIE\nq\u0002\\1tiV\u0003H-\u0019;f)&lW\rI\u0001\u0010Y\u0006\u001cH\u000f\u0015:pOJ,7o\u001d\"beV\t\u0011\u0010\u0005\u0002{{6\t1P\u0003\u0002}{\u0005!A.\u00198h\u0013\t160A\nmCN$\bK]8he\u0016\u001c8OQ1s?\u0012*\u0017\u000fF\u0002r\u0003\u0003Aq!\u001e\t\u0002\u0002\u0003\u0007\u00110\u0001\tmCN$\bK]8he\u0016\u001c8OQ1sA\u0005YA\r\u001e$pe6\fG\u000f^3s+\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\r\u0019|'/\\1u\u0015\r\t\u0019\"P\u0001\u0005i&lW-\u0003\u0003\u0002\u0018\u00055!!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\u0006aA\r\u001e$pe6\fG\u000f^3sA\u0005)A/[7feV\u0011\u0011q\u0004\t\u0005\u0003C\t\u0019#D\u0001<\u0013\r\t)c\u000f\u0002\u0006)&lWM]\u0001\u0007i&lWM\u001d\u0011\u0002\u000fI,gM]3tQR\t\u0011/\u0001\u0003tQ><H#B9\u00022\u0005U\u0002BBA\u001a/\u0001\u0007\u0011*A\u0002o_^Dq!a\u000e\u0018\u0001\u0004\tI$\u0001\u0004ti\u0006<Wm\u001d\t\u0006\u0003w\t)%\u0012\b\u0005\u0003{\t\tED\u0002Q\u0003\u007fI\u0011\u0001K\u0005\u0004\u0003\u0007:\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\nIEA\u0002TKFT1!a\u0011(\u0003\u0015\u0019G.Z1s\u0003\u00191\u0017N\\5tQ\u0002")
public class SparkConsoleProgressBar
implements Logging {
    private final Operation operation;
    private final ConcurrentHashMap<StageAttempt, StageInfo> liveStages;
    private final char CR;
    private final long firstDelayMSec;
    private final int TerminalWidth;
    private long lastUpdateTime;
    private String lastProgressBar;
    private final DateTimeFormatter dtFormatter;
    private final Timer timer;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private char CR() {
        return this.CR;
    }

    private long firstDelayMSec() {
        return this.firstDelayMSec;
    }

    private int TerminalWidth() {
        return this.TerminalWidth;
    }

    private long lastUpdateTime() {
        return this.lastUpdateTime;
    }

    private void lastUpdateTime_$eq(long x$1) {
        this.lastUpdateTime = x$1;
    }

    private String lastProgressBar() {
        return this.lastProgressBar;
    }

    private void lastProgressBar_$eq(String x$1) {
        this.lastProgressBar = x$1;
    }

    public DateTimeFormatter dtFormatter() {
        return this.dtFormatter;
    }

    private Timer timer() {
        return this.timer;
    }

    public void org$apache$spark$kyuubi$SparkConsoleProgressBar$$refresh() {
        long now = System.currentTimeMillis();
        List stages = (List)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveStages.values()).asScala()).toList().sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.stageId()), (Ordering)Ordering.Int$.MODULE$);
        if (stages.nonEmpty()) {
            this.show(now, (Seq<StageInfo>)stages.take(3));
            return;
        }
    }

    private void show(long now, Seq<StageInfo> stages) {
        String bar;
        int width = this.TerminalWidth() / stages.size();
        String string = bar = ((TraversableOnce)stages.map((Function1 & Serializable & scala.Serializable)s -> {
            String string;
            int total = s.numTasks();
            String header = new StringBuilder(8).append("[Stage ").append(s.stageId()).append(":").toString();
            String tailer = new StringBuilder(9).append("(").append(s.numCompleteTasks()).append(" + ").append(s.numActiveTasks()).append(") / ").append(total).append("]").toString();
            int w = width - header.length() - tailer.length();
            if (w > 0) {
                int percent = w * s.numCompleteTasks() / total;
                string = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), w).map((Function1 & Serializable & scala.Serializable)i -> SparkConsoleProgressBar.$anonfun$show$2(percent, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("");
            } else {
                string = "";
            }
            String bar = string;
            return new StringBuilder(0).append(header).append(bar).append(tailer).toString();
        }, Seq$.MODULE$.canBuildFrom())).mkString("");
        String string2 = this.lastProgressBar();
        if ((string != null ? !string.equals(string2) : string2 != null) || now - this.lastUpdateTime() > 60000L) {
            this.operation.getOperationLog().foreach((Function1 & Serializable & scala.Serializable)log -> {
                log.write(new StringBuilder(0).append(this.dtFormatter().format(Instant.ofEpochMilli(now))).append(' ').append(bar).append(this.CR()).toString());
                return BoxedUnit.UNIT;
            });
            this.lastUpdateTime_$eq(now);
        }
        this.lastProgressBar_$eq(bar);
    }

    private void clear() {
        if (new StringOps(Predef$.MODULE$.augmentString(this.lastProgressBar())).nonEmpty()) {
            this.operation.getOperationLog().foreach((Function1 & Serializable & scala.Serializable)log -> {
                log.write(new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(" ")).$times(this.TerminalWidth())).append(this.CR()).toString());
                return BoxedUnit.UNIT;
            });
            this.lastProgressBar_$eq("");
            return;
        }
    }

    public synchronized void finish() {
        this.clear();
        this.timer().cancel();
    }

    public static final /* synthetic */ String $anonfun$show$2(int percent$1, int i) {
        if (i < percent$1) {
            return "=";
        }
        if (i == percent$1) {
            return ">";
        }
        return " ";
    }

    public SparkConsoleProgressBar(Operation operation, ConcurrentHashMap<StageAttempt, StageInfo> liveStages, long updatePeriodMSec, String timeFormat) {
        this.operation = operation;
        this.liveStages = liveStages;
        Logging.$init$(this);
        this.CR = (char)13;
        this.firstDelayMSec = 500L;
        this.TerminalWidth = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.env().getOrElse((Object)"COLUMNS", (Function0 & Serializable & scala.Serializable)() -> "80"))).toInt();
        this.lastUpdateTime = 0L;
        this.lastProgressBar = "";
        this.dtFormatter = DateTimeFormatter.ofPattern(timeFormat).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        this.timer = new Timer(new StringBuilder(21).append("refresh progress for ").append(operation.getHandle().identifier().toString()).toString(), true);
        this.timer().schedule(new TimerTask(this){
            private final /* synthetic */ SparkConsoleProgressBar $outer;

            public void run() {
                this.$outer.org$apache$spark$kyuubi$SparkConsoleProgressBar$$refresh();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.firstDelayMSec(), updatePeriodMSec);
    }
}

