/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluent;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluentImpl;
import java.util.Objects;

public class ContainerMetricsBuilder
extends ContainerMetricsFluentImpl<ContainerMetricsBuilder>
implements VisitableBuilder<ContainerMetrics, ContainerMetricsBuilder> {
    ContainerMetricsFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerMetricsBuilder() {
        this(false);
    }

    public ContainerMetricsBuilder(Boolean validationEnabled) {
        this(new ContainerMetrics(), validationEnabled);
    }

    public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerMetrics(), validationEnabled);
    }

    public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent, ContainerMetrics instance) {
        this(fluent, instance, false);
    }

    public ContainerMetricsBuilder(ContainerMetricsFluent<?> fluent, ContainerMetrics instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withUsage(instance.getUsage());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ContainerMetricsBuilder(ContainerMetrics instance) {
        this(instance, (Boolean)false);
    }

    public ContainerMetricsBuilder(ContainerMetrics instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withUsage(instance.getUsage());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ContainerMetrics build() {
        ContainerMetrics buildable = new ContainerMetrics(this.fluent.getName(), this.fluent.getUsage());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerMetricsBuilder that = (ContainerMetricsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

