/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.trino.schema;

import io.trino.client.ClientTypeSignature;
import io.trino.client.ClientTypeSignatureParameter;
import io.trino.client.Column;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import org.apache.hive.service.rpc.thrift.TColumnDesc;
import org.apache.hive.service.rpc.thrift.TPrimitiveTypeEntry;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.hive.service.rpc.thrift.TTypeDesc;
import org.apache.hive.service.rpc.thrift.TTypeEntry;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.hive.service.rpc.thrift.TTypeQualifierValue;
import org.apache.hive.service.rpc.thrift.TTypeQualifiers;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SchemaHelper$ {
    public static SchemaHelper$ MODULE$;
    private Set<String> STRING_TYPES;
    private final String UNKNOWN;
    private volatile boolean bitmap$0;

    static {
        new SchemaHelper$();
    }

    public String UNKNOWN() {
        return this.UNKNOWN;
    }

    private Set<String> STRING_TYPES$lzycompute() {
        SchemaHelper$ schemaHelper$ = this;
        synchronized (schemaHelper$) {
            if (!this.bitmap$0) {
                this.STRING_TYPES = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HyperLogLog", "qdigest", "P4HyperLogLog", "timestamp with time zone", "time", "time with time zone", "json", "ipaddress", "uuid", "Geometry", "SphericalGeography", "BingTile"}));
                this.bitmap$0 = true;
            }
        }
        return this.STRING_TYPES;
    }

    private Set<String> STRING_TYPES() {
        if (!this.bitmap$0) {
            return this.STRING_TYPES$lzycompute();
        }
        return this.STRING_TYPES;
    }

    public TTypeId toTTypeId(ClientTypeSignature typ) {
        String string = typ.getRawType().toLowerCase(Locale.ROOT);
        if ("boolean".equals(string)) {
            return TTypeId.BOOLEAN_TYPE;
        }
        if ("tinyint".equals(string)) {
            return TTypeId.TINYINT_TYPE;
        }
        if ("smallint".equals(string)) {
            return TTypeId.SMALLINT_TYPE;
        }
        if ("integer".equals(string)) {
            return TTypeId.INT_TYPE;
        }
        if ("bigint".equals(string)) {
            return TTypeId.BIGINT_TYPE;
        }
        if ("real".equals(string)) {
            return TTypeId.FLOAT_TYPE;
        }
        if ("double".equals(string)) {
            return TTypeId.DOUBLE_TYPE;
        }
        if ("decimal".equals(string)) {
            return TTypeId.DECIMAL_TYPE;
        }
        if ("char".equals(string)) {
            return TTypeId.CHAR_TYPE;
        }
        if ("varchar".equals(string)) {
            return TTypeId.VARCHAR_TYPE;
        }
        if ("varbinary".equals(string)) {
            return TTypeId.BINARY_TYPE;
        }
        if ("date".equals(string)) {
            return TTypeId.DATE_TYPE;
        }
        if ("timestamp".equals(string)) {
            return TTypeId.TIMESTAMP_TYPE;
        }
        if ("interval day to second".equals(string)) {
            return TTypeId.INTERVAL_DAY_TIME_TYPE;
        }
        if ("interval year to month".equals(string)) {
            return TTypeId.INTERVAL_YEAR_MONTH_TYPE;
        }
        if ("array".equals(string)) {
            return TTypeId.ARRAY_TYPE;
        }
        if ("map".equals(string)) {
            return TTypeId.MAP_TYPE;
        }
        if ("row".equals(string)) {
            return TTypeId.STRUCT_TYPE;
        }
        if (this.STRING_TYPES().contains((Object)string)) {
            return TTypeId.STRING_TYPE;
        }
        String string2 = this.UNKNOWN();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return TTypeId.NULL_TYPE;
        }
        throw new IllegalArgumentException(new StringBuilder(30).append("Unrecognized trino type name: ").append(string).toString());
    }

    public TTypeQualifiers toTTypeQualifiers(ClientTypeSignature typ) {
        TTypeQualifiers ret = new TTypeQualifiers();
        String string = typ.getRawType();
        java.util.Map qualifiers = "decimal".equals(string) ? (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precision"), (Object)TTypeQualifierValue.i32Value((int)((int)BoxesRunTime.unboxToLong((Object)((ClientTypeSignatureParameter)typ.getArguments().get(0)).getValue())))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scale"), (Object)TTypeQualifierValue.i32Value((int)((int)BoxesRunTime.unboxToLong((Object)((ClientTypeSignatureParameter)typ.getArguments().get(1)).getValue()))))}))).asJava() : Collections.emptyMap();
        ret.setQualifiers(qualifiers);
        return ret;
    }

    public TTypeDesc toTTypeDesc(ClientTypeSignature typ) {
        TPrimitiveTypeEntry typeEntry = new TPrimitiveTypeEntry(this.toTTypeId(typ));
        typeEntry.setTypeQualifiers(this.toTTypeQualifiers(typ));
        TTypeDesc tTypeDesc = new TTypeDesc();
        tTypeDesc.addToTypes(TTypeEntry.primitiveEntry((TPrimitiveTypeEntry)typeEntry));
        return tTypeDesc;
    }

    public TColumnDesc toTColumnDesc(Column column, int pos) {
        TColumnDesc tColumnDesc = new TColumnDesc();
        tColumnDesc.setColumnName(column.getName());
        tColumnDesc.setTypeDesc(this.toTTypeDesc(column.getTypeSignature()));
        tColumnDesc.setPosition(pos);
        return tColumnDesc;
    }

    public TTableSchema toTTableSchema(Seq<Column> schema) {
        TTableSchema tTableSchema = new TTableSchema();
        ((IterableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SchemaHelper$.$anonfun$toTTableSchema$1(tTableSchema, x0$1);
            return BoxedUnit.UNIT;
        });
        return tTableSchema;
    }

    public static final /* synthetic */ void $anonfun$toTTableSchema$1(TTableSchema tTableSchema$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Column f = (Column)tuple2._1();
            int i = tuple2._2$mcI$sp();
            tTableSchema$1.addToColumns(MODULE$.toTColumnDesc(f, i));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private SchemaHelper$() {
        MODULE$ = this;
        this.UNKNOWN = "unknown";
    }
}

