/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.client.api.v1.dto.Engine;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.DiscoveryClient;
import org.apache.kyuubi.ha.client.DiscoveryClientProvider$;
import org.apache.kyuubi.ha.client.DiscoveryPaths$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.AbstractSeq;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Tag(name="Admin")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005]g!\u0002\u0006\f\u0001-9\u0002\"\u0002\u0014\u0001\t\u0003A\u0003\u0002C\u0016\u0001\u0011\u000b\u0007I\u0011\u0002\u0017\t\u000ba\u0002A\u0011A\u001d\t\u000bU\u0004A\u0011A\u001d\t\u000by\u0004A\u0011A\u001d\t\u000f\u0005=\u0001\u0001\"\u0001\u0002\u0012!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBAQ\u0001\u0011%\u00111\u0015\u0005\b\u0003g\u0003A\u0011BA[\u00055\tE-\\5o%\u0016\u001cx.\u001e:dK*\u0011A\"D\u0001\u0003mFR!AD\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0011#\u000511/\u001a:wKJT!AE\n\u0002\r-LX/\u001e2j\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0014\t\u0001AbD\t\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"A\u0007\n\u0005\u0005j!!E!qSJ+\u0017/^3ti\u000e{g\u000e^3yiB\u00111\u0005J\u0007\u0002#%\u0011Q%\u0005\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u0015\u0011\u0005)\u0002Q\"A\u0006\u0002\u001b\u0005$W.\u001b8jgR\u0014\u0018\r^8s+\u0005i\u0003C\u0001\u00186\u001d\ty3\u0007\u0005\u0002155\t\u0011G\u0003\u00023O\u00051AH]8pizJ!\u0001\u000e\u000e\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003ii\t\u0011D]3ge\u0016\u001c\bN\u0012:p]R,g\u000e\u001a%bI>|\u0007oQ8oMR\t!\b\u0005\u0002<\t6\tAH\u0003\u0002>}\u0005!1m\u001c:f\u0015\ty\u0004)\u0001\u0002sg*\u0011\u0011IQ\u0001\u0003oNT\u0011aQ\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u000br\u0012\u0001BU3ta>t7/\u001a\u0015\u0005\u0007\u001d[E\n\u0005\u0002I\u00136\ta(\u0003\u0002K}\t!\u0001+\u0019;i\u0003\u00151\u0018\r\\;fC\u0005i\u0015a\u0005:fMJ,7\u000f[\u0018iC\u0012|w\u000e]0d_:4\u0007FA\u0002P!\tA\u0005+\u0003\u0002R}\t!\u0001kT*UQ!\u00191k\u00193gOJ\u001c\bC\u0001+b\u001b\u0005)&B\u0001,X\u0003%\u0011Xm\u001d9p]N,7O\u0003\u0002Y3\u0006Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015\tQ6,A\u0002pCNT!\u0001X/\u0002\u0005Y\u001c$B\u00010`\u0003\u001d\u0019x/Y4hKJT\u0011\u0001Y\u0001\u0003S>L!AY+\u0003\u0017\u0005\u0003\u0018NU3ta>t7/Z\u0001\re\u0016\u001c\bo\u001c8tK\u000e{G-Z\u0011\u0002K\u0006\u0019!\u0007\r\u0019\u0002\u000f\r|g\u000e^3oi2\n\u0001nK\u0002j_B\u0004\"A[7\u000e\u0003-T!\u0001\\,\u0002\u000b5,G-[1\n\u00059\\'aB\"p]R,g\u000e^\u0001\n[\u0016$\u0017.\u0019+za\u0016\f\u0013!]\u0001\u0011CB\u0004H.[2bi&|gn\f6t_:\f1\u0002Z3tGJL\u0007\u000f^5p]\u0006\nA/\u00011sK\u001a\u0014Xm\u001d5!i\",\u0007eS=vk\nL\u0007e]3sm\u0016\u0014\b\u0005[1e_>\u0004\beY8oM2\u0002cn\u001c;fAQD\u0017\r\u001e\u0017!SR\u0004sN\u001c7zAQ\f7.Z:!C\u001a4Wm\u0019;!M>\u0014\bE\u001a:p]R,g\u000e\u001a\u0011tKJ4\u0018nY3tA9|w/A\fsK\u001a\u0014Xm\u001d5Vg\u0016\u0014H)\u001a4bk2$8oQ8oM\"\"AaR&xC\u0005A\u0018A\u0007:fMJ,7\u000f[\u0018vg\u0016\u0014x\fZ3gCVdGo]0d_:4\u0007F\u0001\u0003PQ!!1k\u00193gwJdH&\u00015\"\u0003u\f\u0011E]3ge\u0016\u001c\b\u000e\t;iK\u0002*8/\u001a:!I\u00164\u0017-\u001e7ug\u0002\u001awN\u001c4jON\fAC]3ge\u0016\u001c\b.\u00168mS6LG/\u001a3Vg\u0016\u0014\b&B\u0003H\u0017\u0006\u0005\u0011EAA\u0002\u0003]\u0011XM\u001a:fg\"|SO\u001c7j[&$X\rZ0vg\u0016\u00148\u000f\u000b\u0002\u0006\u001f\"RQaU2eM\u0006%!/a\u0003-\u0003!\f#!!\u0004\u00027I,gM]3tQ\u0002\"\b.\u001a\u0011v]2LW.\u001b;fI\u0002*8/\u001a:t\u00031!W\r\\3uK\u0016sw-\u001b8f)%Q\u00141CA\u0012\u0003[\t)\u0004\u0003\u0004\u0002\u0016\u0019\u0001\r!L\u0001\u000bK:<\u0017N\\3UsB,\u0007fBA\n\u00033Y\u0015q\u0004\t\u0004\u0011\u0006m\u0011bAA\u000f}\tQ\u0011+^3ssB\u000b'/Y7\"\u0005\u0005\u0005\u0012\u0001\u0002;za\u0016Da!!\n\u0007\u0001\u0004i\u0013AC:iCJ,G*\u001a<fY\":\u00111EA\r\u0017\u0006%\u0012EAA\u0016\u0003)\u0019\b.\u0019:fY\u00164X\r\u001c\u0005\u0007\u0003_1\u0001\u0019A\u0017\u0002\u0013M,(\rZ8nC&t\u0007fBA\u0017\u00033Y\u00151G\u0011\u0003\u0003_Aa!a\u000e\u0007\u0001\u0004i\u0013\u0001\u00045teA\u0013x\u000e_=Vg\u0016\u0014\bfBA\u001b\u00033Y\u00151H\u0011\u0003\u0003{\tq\u0003[5wK:\u001aXM\u001d<feJr\u0003O]8ys:*8/\u001a:)\u000b\u001995*!\u0011\"\u0005\u0005\r\u0013AB3oO&tW\rK\u0002\u0007\u0003\u000f\u00022\u0001SA%\u0013\r\tYE\u0010\u0002\u0007\t\u0016cU\tV#)\u0015\u0019\u00196\r\u001a4\u0002PI\f\t\u0006L\u0001iC\t\t\u0019&\u0001\u000beK2,G/\u001a\u0011lsV,(-\u001b\u0011f]\u001eLg.Z\u0001\fY&\u001cH/\u00128hS:,7\u000f\u0006\u0006\u0002Z\u0005}\u00141QAD\u0003\u0017\u0003b!a\u0017\u0002f\u0005-d\u0002BA/\u0003Cr1\u0001MA0\u0013\u0005Y\u0012bAA25\u00059\u0001/Y2lC\u001e,\u0017\u0002BA4\u0003S\u00121aU3r\u0015\r\t\u0019G\u0007\t\u0005\u0003[\nY(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\r!Go\u001c\u0006\u0004\u0019\u0005U$b\u0001\b\u0002x)\u0019\u0011\u0011P\t\u0002\r\rd\u0017.\u001a8u\u0013\u0011\ti(a\u001c\u0003\r\u0015sw-\u001b8f\u0011\u0019\t)b\u0002a\u0001[!:\u0011qPA\r\u0017\u0006}\u0001BBA\u0013\u000f\u0001\u0007Q\u0006K\u0004\u0002\u0004\u0006e1*!\u000b\t\r\u0005=r\u00011\u0001.Q\u001d\t9)!\u0007L\u0003gAa!a\u000e\b\u0001\u0004i\u0003fBAF\u00033Y\u00151\b\u0015\u0006\u000f\u001d[\u0015\u0011\t\u0015\u0004\u000f\u0005M\u0005c\u0001%\u0002\u0016&\u0019\u0011q\u0013 \u0003\u0007\u001d+E\u000b\u000b\u0006\b'\u000e$g-a's\u0003;c\u0013\u0001[\u0011\u0003\u0003?\u000b1\u0003\\5ti\u0002Z\u00170^;cS\u0002*gnZ5oKN\f\u0011bZ3u\u000b:<\u0017N\\3\u0015\u0019\u0005-\u0014QUAU\u0003W\u000bi+a,\t\r\u0005\u001d\u0006\u00021\u0001.\u0003!)8/\u001a:OC6,\u0007BBA\u000b\u0011\u0001\u0007Q\u0006\u0003\u0004\u0002&!\u0001\r!\f\u0005\u0007\u0003_A\u0001\u0019A\u0017\t\r\u0005E\u0006\u00021\u0001.\u0003A\u0019XO\u00193p[\u0006Lg\u000eR3gCVdG/\u0001\bhKR,enZ5oKN\u0003\u0018mY3\u0015\u00075\n9\fC\u0004\u0002D%\u0001\r!a\u001b)\r\u0001\tYlSAa!\rA\u0015QX\u0005\u0004\u0003\u007fs$\u0001\u0003)s_\u0012,8-Z:-\u0003ADs\u0001AAc\u0003#\f\u0019\u000e\u0005\u0003\u0002H\u00065WBAAe\u0015\r\tYmV\u0001\u0005i\u0006<7/\u0003\u0003\u0002P\u0006%'a\u0001+bO\u0006!a.Y7fC\t\t).A\u0003BI6Lg\u000e")
public class AdminResource
implements ApiRequestContext,
Logging {
    private String administrator;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private String administrator$lzycompute() {
        AdminResource adminResource = this;
        synchronized (adminResource) {
            if (!this.bitmap$0) {
                this.administrator = Utils$.MODULE$.currentUser();
                this.bitmap$0 = true;
            }
        }
        return this.administrator;
    }

    private String administrator() {
        if (!this.bitmap$0) {
            return this.administrator$lzycompute();
        }
        return this.administrator;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the Kyuubi server hadoop conf, note that, it only takes affect for frontend services now")
    @POST
    @Path(value="refresh/hadoop_conf")
    public Response refreshFrontendHadoopConf() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Receive refresh Kyuubi server hadoop conf request from ").append(userName).append("/").append(ipAddress).toString());
        if (!userName.equals(this.administrator())) {
            throw new NotAllowedException(new StringBuilder(56).append(userName).append(" is not allowed to refresh the Kyuubi server hadoop conf").toString(), new String[0]);
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading the Kyuubi server hadoop conf");
        KyuubiServer$.MODULE$.reloadHadoopConf();
        return Response.ok((Object)new StringBuilder(42).append("Refresh the hadoop conf for ").append(this.fe().connectionUrl()).append(" successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the user defaults configs")
    @POST
    @Path(value="refresh/user_defaults_conf")
    public Response refreshUserDefaultsConf() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Receive refresh user defaults conf request from ").append(userName).append("/").append(ipAddress).toString());
        if (!userName.equals(this.administrator())) {
            throw new NotAllowedException(new StringBuilder(49).append(userName).append(" is not allowed to refresh the user defaults conf").toString(), new String[0]);
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading user defaults conf");
        KyuubiServer$.MODULE$.refreshUserDefaultsConf();
        return Response.ok((Object)"Refresh the user defaults conf successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="refresh the unlimited users")
    @POST
    @Path(value="refresh/unlimited_users")
    public Response refreshUnlimitedUser() {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        String ipAddress = this.fe().getIpAddress();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Receive refresh unlimited users request from ").append(userName).append("/").append(ipAddress).toString());
        if (!userName.equals(this.administrator())) {
            throw new NotAllowedException(new StringBuilder(46).append(userName).append(" is not allowed to refresh the unlimited users").toString(), new String[0]);
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Reloading unlimited users");
        KyuubiServer$.MODULE$.refreshUnlimitedUsers();
        return Response.ok((Object)"Refresh the unlimited users successfully.").build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="delete kyuubi engine")
    @DELETE
    @Path(value="engine")
    public Response deleteEngine(@QueryParam(value="type") String engineType, @QueryParam(value="sharelevel") String shareLevel, @QueryParam(value="subdomain") String subdomain, @QueryParam(value="hive.server2.proxy.user") String hs2ProxyUser) {
        String userName = this.fe().getSessionUser(hs2ProxyUser);
        Engine engine = this.getEngine(userName, engineType, shareLevel, subdomain, "default");
        String engineSpace = this.getEngineSpace(engine);
        DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.fe().getConf(), (Function1 & Serializable & scala.Serializable)discoveryClient -> {
            AdminResource.$anonfun$deleteEngine$1(this, engineSpace, discoveryClient);
            return BoxedUnit.UNIT;
        });
        return Response.ok((Object)new StringBuilder(32).append("Engine ").append(engineSpace).append(" is deleted successfully.").toString()).build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="list kyuubi engines")
    @GET
    @Path(value="engine")
    public Seq<Engine> listEngines(@QueryParam(value="type") String engineType, @QueryParam(value="sharelevel") String shareLevel, @QueryParam(value="subdomain") String subdomain, @QueryParam(value="hive.server2.proxy.user") String hs2ProxyUser) {
        String userName = this.fe().getSessionUser(hs2ProxyUser);
        Engine engine = this.getEngine(userName, engineType, shareLevel, subdomain, "");
        String engineSpace = this.getEngineSpace(engine);
        ObjectRef engineNodes = ObjectRef.create((Object)((ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Option option = Option$.MODULE$.apply((Object)subdomain).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$listEngines$1(x$1)));
        if (option instanceof Some) {
            AbstractSeq cfr_ignored_0 = (AbstractSeq)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.fe().getConf(), (Function1 & Serializable & scala.Serializable)discoveryClient -> {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Listing engine nodes for ").append(engineSpace).toString());
                return ((ListBuffer)engineNodes$1.elem).$plus$plus$eq((TraversableOnce)discoveryClient.getServiceNodesInfo(engineSpace, discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3()));
            });
        } else if (None$.MODULE$.equals(option)) {
            AbstractSeq cfr_ignored_1 = (AbstractSeq)DiscoveryClientProvider$.MODULE$.withDiscoveryClient(this.fe().getConf(), (Function1 & Serializable & scala.Serializable)discoveryClient -> (List)discoveryClient.getChildren(engineSpace).map((Function1 & Serializable & scala.Serializable)child -> {
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Listing engine nodes for ").append(engineSpace).append("/").append((String)child).toString());
                return ((ListBuffer)engineNodes$1.elem).$plus$plus$eq((TraversableOnce)discoveryClient.getServiceNodesInfo(new StringBuilder(1).append(engineSpace).append("/").append((String)child).toString(), discoveryClient.getServiceNodesInfo$default$2(), discoveryClient.getServiceNodesInfo$default$3()));
            }, List$.MODULE$.canBuildFrom()));
        } else {
            throw new MatchError((Object)option);
        }
        return (Seq)((ListBuffer)engineNodes.elem).map((Function1 & Serializable & scala.Serializable)node -> new Engine(engine.getVersion(), engine.getUser(), engine.getEngineType(), engine.getSharelevel(), (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])node.namespace().split("/"))).last(), node.instance(), node.namespace(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)node.attributes()).asJava()), ListBuffer$.MODULE$.canBuildFrom());
    }

    private Engine getEngine(String userName, String engineType, String shareLevel, String subdomain, String subdomainDefault) {
        KyuubiConf clonedConf = this.fe().getConf().clone();
        Option$.MODULE$.apply((Object)engineType).foreach((Function1 & Serializable & scala.Serializable)x$2 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_TYPE(), x$2));
        Option$.MODULE$.apply((Object)subdomain).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$getEngine$2(x$3))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN(), (Object)Option$.MODULE$.apply((Object)subdomain)));
        Option$.MODULE$.apply((Object)shareLevel).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AdminResource.$anonfun$getEngine$4(x$5))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> clonedConf.set(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL(), x$6));
        String normalizedEngineType = (String)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_TYPE());
        String engineSubdomain = (String)((Option)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN())).getOrElse((Function0 & Serializable & scala.Serializable)() -> subdomainDefault);
        String engineShareLevel = (String)clonedConf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL());
        return new Engine(package$.MODULE$.KYUUBI_VERSION(), userName, normalizedEngineType, engineShareLevel, engineSubdomain, null, null, Collections.emptyMap());
    }

    private String getEngineSpace(Engine engine) {
        String serverSpace = (String)this.fe().getConf().get(HighAvailabilityConf$.MODULE$.HA_NAMESPACE());
        String string = engine.getSharelevel();
        String appUser = "GROUP".equals(string) ? this.fe().sessionManager().groupProvider().primaryGroup(engine.getUser(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.fe().getConf().getAll()).asJava()) : engine.getUser();
        return DiscoveryPaths$.MODULE$.makePath(new StringBuilder(3).append(serverSpace).append("_").append(engine.getVersion()).append("_").append(engine.getSharelevel()).append("_").append(engine.getEngineType()).toString(), appUser, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{engine.getSubdomain()}));
    }

    public static final /* synthetic */ void $anonfun$deleteEngine$2(AdminResource $this, String engineSpace$1, DiscoveryClient discoveryClient$1, String node) {
        String nodePath = new StringBuilder(1).append(engineSpace$1).append("/").append(node).toString();
        $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Deleting engine node:").append(nodePath).toString());
        try {
            discoveryClient$1.delete(nodePath, discoveryClient$1.delete$default$2());
        }
        catch (Exception e) {
            $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Failed to delete engine node:").append(nodePath).toString(), e);
            throw new NotFoundException(new StringBuilder(30).append("Failed to delete engine node:").append(nodePath).append(",").append(e.getMessage()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$deleteEngine$1(AdminResource $this, String engineSpace$1, DiscoveryClient discoveryClient) {
        List engineNodes = discoveryClient.getChildren(engineSpace$1);
        engineNodes.foreach((Function1 & Serializable & scala.Serializable)node -> {
            AdminResource.$anonfun$deleteEngine$2($this, engineSpace$1, discoveryClient, node);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$listEngines$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getEngine$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getEngine$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public AdminResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
    }
}

