/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.api.v1.dto.CloseBatchResponse;
import org.apache.kyuubi.client.api.v1.dto.GetBatchesResponse;
import org.apache.kyuubi.client.api.v1.dto.OperationLog;
import org.apache.kyuubi.client.exception.KyuubiRestException;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.operation.BatchJobSubmission;
import org.apache.kyuubi.operation.BatchJobSubmission$;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationStatus;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.v1.BatchesResource$;
import org.apache.kyuubi.server.api.v1.InternalRestClient;
import org.apache.kyuubi.server.metadata.MetadataManager$;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.session.KyuubiBatchSessionImpl;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.util.JdbcUtils$;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@Tag(name="Batch")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\r\u001de!B\u000f\u001f\u0001yQ\u0003\"B\u001d\u0001\t\u0003Y\u0004b\u0002 \u0001\u0005\u0004%Ia\u0010\u0005\u00071\u0002\u0001\u000b\u0011\u0002!\t\u0011e\u0003\u0001R1A\u0005\niC\u0001B\u0018\u0001\t\u0006\u0004%IA\u0017\u0005\u0006?\u0002!I\u0001\u0019\u0005\u0006G\u0002!I\u0001\u001a\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0006W\u0002!Ia\u001f\u0005\b\u0003?\u0001A\u0011BA\u0011\u0011\u001d\ti\u0003\u0001C\u0001\u0003_Aq!!-\u0001\t\u0003\t\u0019\fC\u0004\u0003\u0006\u0001!IAa\u0002\t\u0013\tU\u0001!%A\u0005\n\t]\u0001b\u0002B\u0017\u0001\u0011%!q\u0006\u0005\b\u0005k\u0001A\u0011\u0001B\u001c\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005KBqA!5\u0001\t\u0003\u0011\u0019\u000eC\u0004\u0004\u0006\u0001!\taa\u0002\b\u000f\rMc\u0004#\u0001\u0004V\u00191QD\bE\u0001\u0007/Ba!O\u000b\u0005\u0002\re\u0003\"CB.+\t\u0007I\u0011AB/\u0011!\u0019)(\u0006Q\u0001\n\r}\u0003\"CB<+\t\u0007I\u0011AB/\u0011!\u0019I(\u0006Q\u0001\n\r}\u0003bBB>+\u0011\u00051Q\u0010\u0005\b\u0007\u0003+B\u0011ABB\u0005=\u0011\u0015\r^2iKN\u0014Vm]8ve\u000e,'BA\u0010!\u0003\t1\u0018G\u0003\u0002\"E\u0005\u0019\u0011\r]5\u000b\u0005\r\"\u0013AB:feZ,'O\u0003\u0002&M\u000511._;vE&T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sON!\u0001aK\u00196!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fMB\u0011!gM\u0007\u0002A%\u0011A\u0007\t\u0002\u0012\u0003BL'+Z9vKN$8i\u001c8uKb$\bC\u0001\u001c8\u001b\u0005!\u0013B\u0001\u001d%\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002yA\u0011Q\bA\u0007\u0002=\u0005\u0019\u0012N\u001c;fe:\fGNU3ti\u000ec\u0017.\u001a8ugV\t\u0001\t\u0005\u0003B\u0011*+V\"\u0001\"\u000b\u0005\r#\u0015AC2p]\u000e,(O]3oi*\u0011QIR\u0001\u0005kRLGNC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%\u0013%!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u00111J\u0015\b\u0003\u0019B\u0003\"!T\u0017\u000e\u00039S!a\u0014\u001e\u0002\rq\u0012xn\u001c;?\u0013\t\tV&\u0001\u0004Qe\u0016$WMZ\u0005\u0003'R\u0013aa\u0015;sS:<'BA).!\tid+\u0003\u0002X=\t\u0011\u0012J\u001c;fe:\fGNU3ti\u000ec\u0017.\u001a8u\u0003QIg\u000e^3s]\u0006d'+Z:u\u00072LWM\u001c;tA\u0005)\u0012N\u001c;fe:\fGnU8dW\u0016$H+[7f_V$X#A.\u0011\u00051b\u0016BA/.\u0005\u0011auN\\4\u0002-%tG/\u001a:oC2\u001cuN\u001c8fGR$\u0016.\\3pkR\fQcZ3u\u0013:$XM\u001d8bYJ+7\u000f^\"mS\u0016tG\u000f\u0006\u0002VC\")!M\u0002a\u0001\u0015\u0006q1._;vE&Len\u001d;b]\u000e,\u0017AD:fgNLwN\\'b]\u0006<WM]\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eJ\u0001\bg\u0016\u001c8/[8o\u0013\tQwM\u0001\u000bLsV,(-[*fgNLwN\\'b]\u0006<WM]\u0001\u000bEVLG\u000e\u001a\"bi\u000eDGCA7x!\tqW/D\u0001p\u0015\t\u0001\u0018/A\u0002ei>T!a\b:\u000b\u0005\u0005\u001a(B\u0001;%\u0003\u0019\u0019G.[3oi&\u0011ao\u001c\u0002\u0006\u0005\u0006$8\r\u001b\u0005\u0006Q\"\u0001\r\u0001\u001f\t\u0003MfL!A_4\u0003--KX/\u001e2j\u0005\u0006$8\r[*fgNLwN\\%na2$B!\u001c?\u0002\n!)Q0\u0003a\u0001}\u0006AQ.\u001a;bI\u0006$\u0018\rE\u0002\u0000\u0003\u000bi!!!\u0001\u000b\u0007\u0005\n\u0019A\u0003\u0002~E%!\u0011qAA\u0001\u0005!iU\r^1eCR\f\u0007bBA\u0006\u0013\u0001\u0007\u0011QB\u0001\u000fE\u0006$8\r[!qaN#\u0018\r^;t!\u0015a\u0013qBA\n\u0013\r\t\t\"\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007%\u0003\u0019)gnZ5oK&!\u0011QDA\f\u0005=\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8J]\u001a|\u0017a\u00054pe6\fGoU3tg&|g\u000eS1oI2,G\u0003BA\u0012\u0003S\u00012AZA\u0013\u0013\r\t9c\u001a\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\t\r\u0005-\"\u00021\u0001K\u0003A\u0019Xm]:j_:D\u0015M\u001c3mKN#(/\u0001\tpa\u0016t')\u0019;dQN+7o]5p]R\u0019Q.!\r\t\u000f\u0005M2\u00021\u0001\u00026\u00059!/Z9vKN$\bc\u00018\u00028%\u0019\u0011\u0011H8\u0003\u0019\t\u000bGo\u00195SKF,Xm\u001d;)\u000f-\ti$!\u0015\u0002TA!\u0011qHA'\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013A\u0001:t\u0015\u0011\t9%!\u0013\u0002\u0005]\u001c(BAA&\u0003\u0015Q\u0017M^1y\u0013\u0011\ty%!\u0011\u0003\u0011\r{gn];nKN\fQA^1mk\u0016d#!!\u0016\"\u0005\u0005]\u0013\u0001E1qa2L7-\u0019;j_:|#n]8oQ\rY\u00111\f\t\u0005\u0003\u007f\ti&\u0003\u0003\u0002`\u0005\u0005#\u0001\u0002)P'RCsbCA2\u0003\u0007\u000b))!#\u0002\f\u0006-\u0016Q\u0016\t\u0005\u0003K\ny(\u0004\u0002\u0002h)!\u0011\u0011NA6\u0003%\u0011Xm\u001d9p]N,7O\u0003\u0003\u0002n\u0005=\u0014aC1o]>$\u0018\r^5p]NTA!!\u001d\u0002t\u0005\u0019q.Y:\u000b\t\u0005U\u0014qO\u0001\u0003mNRA!!\u001f\u0002|\u000591o^1hO\u0016\u0014(BAA?\u0003\tIw.\u0003\u0003\u0002\u0002\u0006\u001d$aC!qSJ+7\u000f]8og\u0016\fAB]3ta>t7/Z\"pI\u0016\f#!a\"\u0002\u0007I\u0002\u0004'A\u0004d_:$XM\u001c;-\u0005\u000555FCAH\u00037\u000b)&!(\u0002 B!\u0011\u0011SAL\u001b\t\t\u0019J\u0003\u0003\u0002\u0016\u0006-\u0014!B7fI&\f\u0017\u0002BAM\u0003'\u0013qaQ8oi\u0016tG/A\u0005nK\u0012L\u0017\rV=qK\u000611o\u00195f[\u0006\\c!!)\u0002(\u0006%\u0006\u0003BAI\u0003GKA!!*\u0002\u0014\n11k\u00195f[\u0006\fa\"[7qY\u0016lWM\u001c;bi&|gnI\u0001n\u0003-!Wm]2sSB$\u0018n\u001c8\"\u0005\u0005=\u0016aH2sK\u0006$X\rI1oI\u0002z\u0007/\u001a8!C\u0002\u0012\u0017\r^2iAM,7o]5p]\u0006Qr\u000e]3o\u0005\u0006$8\r[*fgNLwN\\,ji\",\u0006\u000f\\8bIR9Q.!.\u0002T\u0006\u001d\bbBA\\\u0019\u0001\u0007\u0011QG\u0001\rE\u0006$8\r\u001b*fcV,7\u000f\u001e\u0015\t\u0003k\u000bY,!\u0015\u0002RB!\u0011QXAg\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017!C7vYRL\u0007/\u0019:u\u0015\u0011\t)*!2\u000b\t\u0005\u001d\u0017\u0011Z\u0001\u0007U\u0016\u00148/Z=\u000b\u0007\u0005-\u0007&A\u0005hY\u0006\u001c8OZ5tQ&!\u0011qZA`\u000551uN]7ECR\f\u0007+\u0019:b[\u0006\u0012\u0011q\u0017\u0005\b\u0003+d\u0001\u0019AAl\u0003]\u0011Xm]8ve\u000e,g)\u001b7f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0002Z\u0006uWBAAn\u0015\r\tiHR\u0005\u0005\u0003?\fYNA\u0006J]B,Ho\u0015;sK\u0006l\u0007\u0006CAj\u0003w\u000b\t&a9\"\u0005\u0005\u0015\u0018\u0001\u0004:fg>,(oY3GS2,\u0007bBAu\u0019\u0001\u0007\u00111^\u0001\u0015e\u0016\u001cx.\u001e:dK\u001aKG.Z'fi\u0006$\u0017\r^1\u0011\t\u0005u\u0016Q^\u0005\u0005\u0003_\fyL\u0001\u000eG_JlG)\u0019;b\u0007>tG/\u001a8u\t&\u001c\bo\\:ji&|g\u000e\u000b\u0005\u0002h\u0006m\u0016\u0011KArQ\u001da\u0011QHA)\u0003kd#!a>\"\u0005\u0005e\u0018aE7vYRL\u0007/\u0019:u_\u0019|'/\\\u0017eCR\f\u0007f\u0001\u0007\u0002\\!zA\"a\u0019\u0002\u0004\u0006\u0015\u0015\u0011RA\u0000\u0003W\u0013\t\u0001\f\u0002\u0002\u000e\u0006\u0012!1A\u0001=GJ,\u0017\r^3!C:$\u0007e\u001c9f]\u0002\n\u0007EY1uG\"\u00043/Z:tS>t\u0007e^5uQ\u0002*\b\u000f\\8bI&tw\r\t:fg>,(oY3!M&dW-\u0001\rpa\u0016t')\u0019;dQN+7o]5p]&sG/\u001a:oC2$R!\u001cB\u0005\u0005\u0017Aq!a\r\u000e\u0001\u0004\t)\u0004C\u0005\u0003\u000e5\u0001\n\u00111\u0001\u0003\u0010\u0005!\u0012n\u001d*fg>,(oY3Ge>lW\u000b\u001d7pC\u0012\u00042\u0001\fB\t\u0013\r\u0011\u0019\"\f\u0002\b\u0005>|G.Z1o\u0003\tz\u0007/\u001a8CCR\u001c\u0007nU3tg&|g.\u00138uKJt\u0017\r\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u0004\u0016\u0005\u0005\u001f\u0011Yb\u000b\u0002\u0003\u001eA!!q\u0004B\u0015\u001b\t\u0011\tC\u0003\u0003\u0003$\t\u0015\u0012!C;oG\",7m[3e\u0015\r\u00119#L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0016\u0005C\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039i\u0017M]6EkBd\u0017nY1uK\u0012$2!\u001cB\u0019\u0011\u0019\u0011\u0019d\u0004a\u0001[\u0006)!-\u0019;dQ\u0006I!-\u0019;dQ&sgm\u001c\u000b\u0004[\ne\u0002B\u0002B\u001e!\u0001\u0007!*A\u0004cCR\u001c\u0007.\u00133)\u0011\te\"qHA)\u0005\u000b\u0002B!a\u0010\u0003B%!!1IA!\u0005%\u0001\u0016\r\u001e5QCJ\fW.\t\u0002\u0003<!:\u0001C!\u0013\u0002R\t=\u0003\u0003BA \u0005\u0017JAA!\u0014\u0002B\t!\u0001+\u0019;iC\t\u0011\t&A\u0005|E\u0006$8\r[%e{\"\u001a\u0001C!\u0016\u0011\t\u0005}\"qK\u0005\u0005\u00053\n\tEA\u0002H\u000bRCs\u0002EA2\u0003\u0007\u000b))!#\u0003^\u0005-&q\f\u0017\u0003\u0003\u001b\u000b#A!\u0019\u0002?\u001d,G\u000f\t;iK\u0002\u0012\u0017\r^2iA%tgm\u001c\u0011wS\u0006\u0004#-\u0019;dQ\u0002JG-\u0001\thKR\u0014\u0015\r^2i\u0013:4w\u000eT5tiR\u0001\"q\rB7\u0005w\u0012\u0019Ia#\u0003\u0014\nm%\u0011\u0016\t\u0004]\n%\u0014b\u0001B6_\n\u0011r)\u001a;CCR\u001c\u0007.Z:SKN\u0004xN\\:f\u0011\u0019\u0011y'\u0005a\u0001\u0015\u0006I!-\u0019;dQRK\b/\u001a\u0015\t\u0005[\u0012\u0019(!\u0015\u0003zA!\u0011q\bB;\u0013\u0011\u00119(!\u0011\u0003\u0015E+XM]=QCJ\fW.\t\u0002\u0003p!1!QP\tA\u0002)\u000b!BY1uG\"\u001cF/\u0019;fQ!\u0011YHa\u001d\u0002R\t\u0005\u0015E\u0001B?\u0011\u0019\u0011))\u0005a\u0001\u0015\u0006I!-\u0019;dQV\u001bXM\u001d\u0015\t\u0005\u0007\u0013\u0019(!\u0015\u0003\n\u0006\u0012!Q\u0011\u0005\u0007\u0005\u001b\u000b\u0002\u0019A.\u0002\u0015\r\u0014X-\u0019;f)&lW\r\u000b\u0005\u0003\f\nM\u0014\u0011\u000bBIC\t\u0011i\t\u0003\u0004\u0003\u0016F\u0001\raW\u0001\bK:$G+[7fQ!\u0011\u0019Ja\u001d\u0002R\te\u0015E\u0001BK\u0011\u001d\u0011i*\u0005a\u0001\u0005?\u000bAA\u001a:p[B\u0019AF!)\n\u0007\t\rVFA\u0002J]RD\u0003Ba'\u0003t\u0005E#qU\u0011\u0003\u0005;CqAa+\u0012\u0001\u0004\u0011y*\u0001\u0003tSj,\u0007\u0006\u0003BU\u0005_\u000b\tF!.\u0011\t\u0005}\"\u0011W\u0005\u0005\u0005g\u000b\tE\u0001\u0007EK\u001a\fW\u000f\u001c;WC2,X-\t\u0002\u00038\u0006\u0019\u0011\u0007\r\u0019)\u0011\t%&1OA)\u0005w\u000b#Aa+)\u000fE\ti$!\u0015\u0003@2\u0012\u0011Q\u000b\u0015\u0004#\tU\u0003fD\t\u0002d\u0005\r\u0015QQAE\u0005\u000b\fYK!4-\u0005\t\u001d7FCAH\u00037\u000b)&!(\u0003J.2\u0011\u0011UAT\u0005\u0017\u001c#Aa\u001a\"\u0005\t=\u0017a\u0007:fiV\u0014hn\u001d\u0011uQ\u0016\u0004#-\u0019;dQ\u0002\u001aXm]:j_:\u001ch&\u0001\thKR\u0014\u0015\r^2i\u0019>\u001c\u0017\r\u001c'pORA!Q\u001bBn\u0005?\u0014I\u000fE\u0002o\u0005/L1A!7p\u00051y\u0005/\u001a:bi&|g\u000eT8h\u0011\u0019\u0011YD\u0005a\u0001\u0015\"B!1\u001cB \u0003#\u0012)\u0005C\u0004\u0003\u001eJ\u0001\rAa()\u0011\t}'qVA)\u0005G\f#A!:\u0002\u00055\n\u0004\u0006\u0003Bp\u0005g\n\tFa*\t\u000f\t-&\u00031\u0001\u0003 \"B!\u0011\u001eBX\u0003#\u0012)\f\u000b\u0005\u0003j\nM\u0014\u0011\u000bB^Q\u001d\u0011\"\u0011JA)\u0005c\f#Aa=\u0002%m\u0014\u0017\r^2i\u0013\u0012lx\u0006\\8dC2dun\u001a\u0015\u0004%\tU\u0003f\u0004\n\u0002d\u0005\r\u0015QQAE\u0005s\fYk!\u0001-\u0005\tm8FCAH\u00037\u000b)&!(\u0003~.2\u0011\u0011UAT\u0005\u007f\u001c#A!6\"\u0005\r\r\u0011aJ4fi\u0002\"\b.\u001a\u0011m_\u000e\fG\u000e\t7pO\u0002b\u0017N\\3tA\u0019\u0014x.\u001c\u0011uQ&\u001c\bEY1uG\"\f\u0011c\u00197pg\u0016\u0014\u0015\r^2i'\u0016\u001c8/[8o)\u0019\u0019Iaa\u0004\u0004\u0014A\u0019ana\u0003\n\u0007\r5qN\u0001\nDY>\u001cXMQ1uG\"\u0014Vm\u001d9p]N,\u0007B\u0002B\u001e'\u0001\u0007!\n\u000b\u0005\u0004\u0010\t}\u0012\u0011\u000bB#\u0011\u0019\u0019)b\u0005a\u0001\u0015\u0006a\u0001n\u001d\u001aQe>D\u00180V:fe\"B11\u0003B:\u0003#\u001aI\"\t\u0002\u0004\u001c\u00059\u0002.\u001b<f]M,'O^3se9\u0002(o\u001c=z]U\u001cXM\u001d\u0015\b'\t%\u0013\u0011\u000bB(Q\r\u00192\u0011\u0005\t\u0005\u0003\u007f\u0019\u0019#\u0003\u0003\u0004&\u0005\u0005#A\u0002#F\u0019\u0016#V\tK\b\u0014\u0003G\n\u0019)!\"\u0002\n\u000e%\u00121VB\u0019Y\t\u0019Yc\u000b\u0006\u0002\u0010\u0006m\u0015QKAO\u0007[Yc!!)\u0002(\u000e=2EAB\u0005C\t\u0019\u0019$\u0001\u0011dY>\u001cX\rI1oI\u0002\u001a\u0017M\\2fY\u0002\n\u0007EY1uG\"\u00043/Z:tS>t\u0007f\u0002\u0001\u00048\u0005E3Q\b\t\u0005\u0003\u007f\u0019I$\u0003\u0003\u0004<\u0005\u0005#\u0001\u0003)s_\u0012,8-Z:-\u0005\u0005U\u0003f\u0002\u0001\u0004B\r53q\n\t\u0005\u0007\u0007\u001aI%\u0004\u0002\u0004F)!1qIA6\u0003\u0011!\u0018mZ:\n\t\r-3Q\t\u0002\u0004)\u0006<\u0017\u0001\u00028b[\u0016\f#a!\u0015\u0002\u000b\t\u000bGo\u00195\u0002\u001f\t\u000bGo\u00195fgJ+7o\\;sG\u0016\u0004\"!P\u000b\u0014\u0005UYCCAB+\u0003U\u0019V\u000b\u0015)P%R+Ei\u0018\"B)\u000eCu\fV-Q\u000bN+\"aa\u0018\u0011\r\r\u00054qMB6\u001b\t\u0019\u0019GC\u0002\u0004f5\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019Iga\u0019\u0003\u0007M+\u0017\u000f\u0005\u0003\u0004n\rMTBAB8\u0015\r\u0019\tHR\u0001\u0005Y\u0006tw-C\u0002T\u0007_\nacU+Q!>\u0013F+\u0012#`\u0005\u0006#6\tS0U3B+5\u000bI\u0001\u0013-\u0006c\u0015\nR0C\u0003R\u001b\u0005jX*U\u0003R+5+A\nW\u00032KEi\u0018\"B)\u000eCul\u0015+B)\u0016\u001b\u0006%\u0001\ntkB\u0004xN\u001d;fI\n\u000bGo\u00195UsB,G\u0003\u0002B\b\u0007\u007fBaAa\u001c\u001c\u0001\u0004Q\u0015a\u0004<bY&$')\u0019;dQN#\u0018\r^3\u0015\t\t=1Q\u0011\u0005\u0007\u0005{b\u0002\u0019\u0001&")
public class BatchesResource
implements ApiRequestContext,
Logging {
    private long internalSocketTimeout;
    private long internalConnectTimeout;
    private final ConcurrentHashMap<String, InternalRestClient> internalRestClients;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;
    private volatile byte bitmap$0;

    public static boolean validBatchState(String string) {
        return BatchesResource$.MODULE$.validBatchState(string);
    }

    public static boolean supportedBatchType(String string) {
        return BatchesResource$.MODULE$.supportedBatchType(string);
    }

    public static Seq<String> VALID_BATCH_STATES() {
        return BatchesResource$.MODULE$.VALID_BATCH_STATES();
    }

    public static Seq<String> SUPPORTED_BATCH_TYPES() {
        return BatchesResource$.MODULE$.SUPPORTED_BATCH_TYPES();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private ConcurrentHashMap<String, InternalRestClient> internalRestClients() {
        return this.internalRestClients;
    }

    private long internalSocketTimeout$lzycompute() {
        BatchesResource batchesResource = this;
        synchronized (batchesResource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.internalSocketTimeout = BoxesRunTime.unboxToLong((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_INTERNAL_REST_CLIENT_SOCKET_TIMEOUT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.internalSocketTimeout;
    }

    private long internalSocketTimeout() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.internalSocketTimeout$lzycompute();
        }
        return this.internalSocketTimeout;
    }

    private long internalConnectTimeout$lzycompute() {
        BatchesResource batchesResource = this;
        synchronized (batchesResource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.internalConnectTimeout = BoxesRunTime.unboxToLong((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_INTERNAL_REST_CLIENT_CONNECT_TIMEOUT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.internalConnectTimeout;
    }

    private long internalConnectTimeout() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.internalConnectTimeout$lzycompute();
        }
        return this.internalConnectTimeout;
    }

    private InternalRestClient getInternalRestClient(String kyuubiInstance2) {
        return this.internalRestClients().computeIfAbsent(kyuubiInstance2, kyuubiInstance -> new InternalRestClient((String)kyuubiInstance, (int)this.internalSocketTimeout(), (int)this.internalConnectTimeout()));
    }

    private KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.fe().be().sessionManager();
    }

    private Batch buildBatch(KyuubiBatchSessionImpl session) {
        BatchJobSubmission batchOp = session.batchJobSubmissionOp();
        OperationStatus batchOpStatus = batchOp.getStatus();
        Option<ApplicationInfo> batchAppStatus = batchOp.getApplicationInfo();
        String name = (String)Option$.MODULE$.apply((Object)batchOp.batchName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)batchAppStatus.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name()).orNull(Predef$.MODULE$.$conforms()));
        String appId = null;
        String appUrl = null;
        String appState = null;
        String appDiagnostic = null;
        if (!OperationState$.MODULE$.isTerminal(batchOpStatus.state()) && batchAppStatus.nonEmpty()) {
            appId = ((ApplicationInfo)batchAppStatus.get()).id();
            appUrl = (String)((ApplicationInfo)batchAppStatus.get()).url().orNull(Predef$.MODULE$.$conforms());
            appState = ((ApplicationInfo)batchAppStatus.get()).state().toString();
            appDiagnostic = (String)((ApplicationInfo)batchAppStatus.get()).error().orNull(Predef$.MODULE$.$conforms());
        } else {
            Metadata metadata = this.sessionManager().getBatchMetadata(batchOp.batchId());
            appId = metadata.engineId();
            appUrl = metadata.engineUrl();
            appState = metadata.engineState();
            appDiagnostic = (String)metadata.engineError().orNull(Predef$.MODULE$.$conforms());
        }
        return new Batch(batchOp.batchId(), session.user(), batchOp.batchType(), name, batchOp.appStartTime(), appId, appUrl, appState, appDiagnostic, session.connectionUrl(), batchOpStatus.state().toString(), session.createTime(), batchOpStatus.completed(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
    }

    private Batch buildBatch(Metadata metadata, Option<ApplicationInfo> batchAppStatus) {
        return (Batch)batchAppStatus.map((Function1 & Serializable & scala.Serializable)appStatus -> {
            String currentBatchState = BatchJobSubmission$.MODULE$.applicationFailed(batchAppStatus) ? OperationState$.MODULE$.ERROR().toString() : (BatchJobSubmission$.MODULE$.applicationTerminated(batchAppStatus) ? OperationState$.MODULE$.FINISHED().toString() : (batchAppStatus.isDefined() ? OperationState$.MODULE$.RUNNING().toString() : metadata.state()));
            String name = (String)Option$.MODULE$.apply((Object)metadata.requestName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> appStatus.name());
            String appId = appStatus.id();
            String appUrl = (String)appStatus.url().orNull(Predef$.MODULE$.$conforms());
            String appState = appStatus.state().toString();
            String appDiagnostic = (String)appStatus.error().orNull(Predef$.MODULE$.$conforms());
            return new Batch(metadata.identifier(), metadata.username(), metadata.engineType(), name, metadata.engineOpenTime(), appId, appUrl, appState, appDiagnostic, metadata.kyuubiInstance(), currentBatchState, metadata.createTime(), metadata.endTime(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MetadataManager$.MODULE$.buildBatch(metadata));
    }

    private SessionHandle formatSessionHandle(String sessionHandleStr) {
        SessionHandle sessionHandle;
        try {
            sessionHandle = SessionHandle$.MODULE$.fromUUID(sessionHandleStr);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(sessionHandleStr).toString(), (Throwable)e);
        }
        return sessionHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Batch.class))}, description="create and open a batch session")
    @POST
    @Consumes(value={"application/json"})
    public Batch openBatchSession(BatchRequest request) {
        return this.openBatchSessionInternal(request, this.openBatchSessionInternal$default$2());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Batch.class))}, description="create and open a batch session with uploading resource file")
    @POST
    @Consumes(value={"multipart/form-data"})
    public Batch openBatchSessionWithUpload(@FormDataParam(value="batchRequest") BatchRequest batchRequest, @FormDataParam(value="resourceFile") InputStream resourceFileInputStream, @FormDataParam(value="resourceFile") FormDataContentDisposition resourceFileMetadata) {
        Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_RESOURCE_UPLOAD_ENABLED())), (Function0 & Serializable & scala.Serializable)() -> "Batch resource upload function is not enabled.");
        Predef$.MODULE$.require(batchRequest != null, (Function0 & Serializable & scala.Serializable)() -> "batchRequest is required and please check the content type of batchRequest is application/json");
        File tempFile = Utils$.MODULE$.writeToTempFile(resourceFileInputStream, KyuubiApplicationManager$.MODULE$.uploadWorkDir(), resourceFileMetadata.getFileName());
        batchRequest.setResource(tempFile.getPath());
        return this.openBatchSessionInternal(batchRequest, true);
    }

    private Batch openBatchSessionInternal(BatchRequest request, boolean isResourceFromUpload) {
        Predef$.MODULE$.require(BatchesResource$.MODULE$.supportedBatchType(request.getBatchType()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append(request.getBatchType()).append(" is not in the supported list: ").append(BatchesResource$.MODULE$.SUPPORTED_BATCH_TYPES()).append("}").toString());
        Predef$.MODULE$.require(request.getResource() != null, (Function0 & Serializable & scala.Serializable)() -> "resource is a required parameter");
        if (request.getBatchType().equalsIgnoreCase("SPARK")) {
            Predef$.MODULE$.require(request.getClassName() != null, (Function0 & Serializable & scala.Serializable)() -> "classname is a required parameter for SPARK");
        }
        request.setBatchType(request.getBatchType().toUpperCase(Locale.ROOT));
        Option userProvidedBatchId = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).get((Object)BatchUtils.KYUUBI_BATCH_ID_KEY);
        userProvidedBatchId.foreach((Function1 & Serializable & scala.Serializable)batchId -> {
            UUID uUID;
            try {
                uUID = UUID.fromString(batchId);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringBuilder(17).append(BatchUtils.KYUUBI_BATCH_ID_KEY).append("=").append((String)batchId).append(" must be an UUID").toString(), e);
                }
                throw throwable;
            }
            return uUID;
        });
        Option option = userProvidedBatchId.flatMap((Function1 & Serializable & scala.Serializable)batchId -> Option$.MODULE$.apply((Object)this.sessionManager().getBatchFromMetadataStore((String)batchId)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Batch batch = (Batch)some.value();
            return this.markDuplicated(batch);
        }
        if (None$.MODULE$.equals(option)) {
            Failure failure;
            Throwable cause;
            String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()));
            String ipAddress = this.fe().getIpAddress();
            String batchId2 = (String)userProvidedBatchId.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString());
            request.setConf((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchUtils.KYUUBI_BATCH_ID_KEY), (Object)batchId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.batch.resource.uploaded"), (Object)Boolean.toString(isResourceFromUpload)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.client.ipAddress"), (Object)ipAddress), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.server.ipAddress"), (Object)this.fe().host()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.connection.url"), (Object)this.fe().connectionUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.real.user"), (Object)this.fe().getRealUser())})))).asJava());
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.sessionManager().openBatchSession(userName, "anonymous", ipAddress, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), request));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SessionHandle sessionHandle = (SessionHandle)success.value();
                return this.buildBatch(this.sessionManager().getBatchSessionImpl(sessionHandle));
            }
            if (try_ instanceof Failure && JdbcUtils$.MODULE$.isDuplicatedKeyDBErr(cause = (failure = (Failure)try_).exception())) {
                Batch batch = this.sessionManager().getBatchFromMetadataStore(batchId2);
                Predef$.MODULE$.assert(batch != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("can not find duplicated batch ").append(batchId2).append(" from metadata store").toString());
                return this.markDuplicated(batch);
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)option);
    }

    private boolean openBatchSessionInternal$default$2() {
        return false;
    }

    private Batch markDuplicated(Batch batch) {
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("duplicated submission: ").append(batch.getId()).append(", ignore and return the existing batch.").toString());
        batch.setBatchInfo((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchUtils.KYUUBI_BATCH_DUPLICATED_KEY), (Object)"true")}))).asJava());
        return batch;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Batch.class))}, description="get the batch info via batch id")
    @GET
    @Path(value="{batchId}")
    public Batch batchInfo(@PathParam(value="batchId") String batchId) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        return (Batch)Option$.MODULE$.apply((Object)this.sessionManager().getBatchSessionImpl(sessionHandle)).map((Function1 & Serializable & scala.Serializable)batchSession -> this.buildBatch((KyuubiBatchSessionImpl)((Object)batchSession))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Batch)Option$.MODULE$.apply((Object)this.sessionManager().getBatchMetadata(batchId)).map((Function1 & Serializable & scala.Serializable)metadata -> {
            Batch batch;
            block5: {
                block4: {
                    if (OperationState$.MODULE$.isTerminal(OperationState$.MODULE$.withName(metadata.state()))) break block4;
                    String string = metadata.kyuubiInstance();
                    String string2 = this.fe().connectionUrl();
                    if (string != null ? !string.equals(string2) : string2 != null) break block5;
                }
                return MetadataManager$.MODULE$.buildBatch((Metadata)metadata);
            }
            InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
            try {
                batch = internalRestClient.getBatch(userName, batchId);
            }
            catch (KyuubiRestException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Error redirecting get batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString(), e);
                Option<ApplicationInfo> batchAppStatus = this.sessionManager().applicationManager().getApplicationInfo(metadata.clusterManager(), batchId, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)metadata.engineOpenTime())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 > 0L).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()))));
                batch = this.buildBatch((Metadata)metadata, batchAppStatus);
            }
            return batch;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetBatchesResponse.class))}, description="returns the batch sessions.")
    @GET
    @Consumes(value={"application/json"})
    public GetBatchesResponse getBatchInfoList(@QueryParam(value="batchType") String batchType, @QueryParam(value="batchState") String batchState, @QueryParam(value="batchUser") String batchUser, @QueryParam(value="createTime") long createTime, @QueryParam(value="endTime") long endTime, @QueryParam(value="from") int from, @QueryParam(value="size") @DefaultValue(value="100") int size) {
        Predef$.MODULE$.require(createTime >= 0L && endTime >= 0L && (endTime == 0L || createTime <= endTime), (Function0 & Serializable & scala.Serializable)() -> "Invalid time range");
        if (batchState != null) {
            Predef$.MODULE$.require(BatchesResource$.MODULE$.validBatchState(batchState), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("The valid batch state can be one of the following: ").append(BatchesResource$.MODULE$.VALID_BATCH_STATES().mkString(",")).toString());
        }
        Seq<Batch> batches = this.sessionManager().getBatchesFromMetadataStore(batchType, batchUser, batchState, createTime, endTime, from, size);
        return new GetBatchesResponse(from, batches.size(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(batches).asJava());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationLog.class))}, description="get the local log lines from this batch")
    @GET
    @Path(value="{batchId}/localLog")
    public OperationLog getBatchLocalLog(@PathParam(value="batchId") String batchId, @QueryParam(value="from") @DefaultValue(value="-1") int from, @QueryParam(value="size") @DefaultValue(value="100") int size) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        return (OperationLog)Option$.MODULE$.apply((Object)this.sessionManager().getBatchSessionImpl(sessionHandle)).map((Function1 & Serializable & scala.Serializable)batchSession -> {
            OperationLog operationLog;
            try {
                List list;
                BatchJobSubmission submissionOp = batchSession.batchJobSubmissionOp();
                TRowSet rowSet = submissionOp.getOperationLogRowSet(FetchOrientation$.MODULE$.FETCH_NEXT(), from, size);
                List columns = rowSet.getColumns();
                if (columns == null || columns.size() == 0) {
                    list = Collections.emptyList();
                } else {
                    Predef$.MODULE$.assert(columns.size() == 1);
                    list = ((TColumn)columns.get(0)).getStringVal().getValues();
                }
                List logRowSet = list;
                operationLog = new OperationLog(logRowSet, logRowSet.size());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    String errorMsg = new StringBuilder(41).append("Error getting operation log for batchId: ").append(batchId).toString();
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                    throw new NotFoundException(errorMsg);
                }
                throw throwable;
            }
            return operationLog;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (OperationLog)Option$.MODULE$.apply((Object)this.sessionManager().getBatchMetadata(batchId)).map((Function1 & Serializable & scala.Serializable)metadata -> {
            String string = this.fe().connectionUrl();
            String string2 = metadata.kyuubiInstance();
            if (string == null ? string2 != null : !string.equals(string2)) {
                InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
                return internalRestClient.getBatchLocalLog(userName, batchId, from, size);
            }
            throw new NotFoundException(new StringBuilder(30).append("No local log found for batch: ").append(batchId).toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=CloseBatchResponse.class))}, description="close and cancel a batch session")
    @DELETE
    @Path(value="{batchId}")
    public CloseBatchResponse closeBatchSession(@PathParam(value="batchId") String batchId, @QueryParam(value="hive.server2.proxy.user") String hs2ProxyUser) {
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        String userName = this.fe().getSessionUser(hs2ProxyUser);
        return (CloseBatchResponse)Option$.MODULE$.apply((Object)this.sessionManager().getBatchSessionImpl(sessionHandle)).map((Function1 & Serializable & scala.Serializable)batchSession -> {
            String string = userName;
            String string2 = batchSession.user();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new WebApplicationException(new StringBuilder(47).append(userName).append(" is not allowed to close the session belong to ").append(batchSession.user()).toString(), Response.Status.METHOD_NOT_ALLOWED);
            }
            this.sessionManager().closeSession(batchSession.handle());
            Tuple2<Object, String> tuple2 = batchSession.batchJobSubmissionOp().getKillMessage();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean success = tuple2._1$mcZ$sp();
            String msg = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)success), (Object)msg);
            boolean success2 = tuple22._1$mcZ$sp();
            String msg2 = (String)tuple22._2();
            return new CloseBatchResponse(success2, msg2);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (CloseBatchResponse)Option$.MODULE$.apply((Object)this.sessionManager().getBatchMetadata(batchId)).map((Function1 & Serializable & scala.Serializable)metadata -> {
            CloseBatchResponse closeBatchResponse;
            block8: {
                block10: {
                    block9: {
                        String string = userName;
                        String string2 = metadata.username();
                        if (string == null ? string2 != null : !string.equals(string2)) {
                            throw new WebApplicationException(new StringBuilder(47).append(userName).append(" is not allowed to close the session belong to ").append(metadata.username()).toString(), Response.Status.METHOD_NOT_ALLOWED);
                        }
                        if (OperationState$.MODULE$.isTerminal(OperationState$.MODULE$.withName(metadata.state()))) break block9;
                        String string3 = metadata.kyuubiInstance();
                        String string4 = this.fe().connectionUrl();
                        if (string3 != null ? !string3.equals(string4) : string4 != null) break block10;
                    }
                    return new CloseBatchResponse(false, new StringBuilder(32).append("The batch[").append(metadata).append("] has been terminated.").toString());
                }
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Redirecting delete batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString());
                InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
                try {
                    closeBatchResponse = internalRestClient.deleteBatch(userName, batchId);
                }
                catch (KyuubiRestException e) {
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error redirecting delete batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString(), e);
                    Tuple2<Object, String> appMgrKillResp = this.sessionManager().applicationManager().killApplication(metadata.clusterManager(), batchId);
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Marking batch[").append(batchId).append("/").append(metadata.kyuubiInstance()).append("] closed by ").append(this.fe().connectionUrl()).toString());
                    String x$1 = batchId;
                    boolean x$2 = true;
                    Enumeration.Value x$3 = Metadata$.MODULE$.apply$default$2();
                    String x$4 = Metadata$.MODULE$.apply$default$3();
                    String x$5 = Metadata$.MODULE$.apply$default$4();
                    String x$6 = Metadata$.MODULE$.apply$default$5();
                    String x$7 = Metadata$.MODULE$.apply$default$6();
                    String x$8 = Metadata$.MODULE$.apply$default$7();
                    String x$9 = Metadata$.MODULE$.apply$default$8();
                    String x$10 = Metadata$.MODULE$.apply$default$9();
                    String x$11 = Metadata$.MODULE$.apply$default$10();
                    scala.collection.immutable.Map<String, String> x$12 = Metadata$.MODULE$.apply$default$11();
                    Seq<String> x$13 = Metadata$.MODULE$.apply$default$12();
                    long x$14 = Metadata$.MODULE$.apply$default$13();
                    String x$15 = Metadata$.MODULE$.apply$default$14();
                    Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
                    long x$17 = Metadata$.MODULE$.apply$default$16();
                    String x$18 = Metadata$.MODULE$.apply$default$17();
                    String x$19 = Metadata$.MODULE$.apply$default$18();
                    String x$20 = Metadata$.MODULE$.apply$default$19();
                    String x$21 = Metadata$.MODULE$.apply$default$20();
                    Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
                    long x$23 = Metadata$.MODULE$.apply$default$22();
                    this.sessionManager().updateMetadata(new Metadata(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$2));
                    if (appMgrKillResp._1$mcZ$sp()) {
                        closeBatchResponse = new CloseBatchResponse(appMgrKillResp._1$mcZ$sp(), (String)appMgrKillResp._2());
                        break block8;
                    }
                    closeBatchResponse = new CloseBatchResponse(false, Utils$.MODULE$.stringifyException((Throwable)e));
                }
            }
            return closeBatchResponse;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    public BatchesResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
        this.internalRestClients = new ConcurrentHashMap();
    }
}

