/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.sql.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.hive.service.rpc.thrift.TByteColumn;
import org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRow;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.hive.service.rpc.thrift.TTypeId;
import org.apache.kyuubi.sql.schema.Column;
import org.apache.kyuubi.sql.schema.Row;
import org.apache.kyuubi.sql.schema.Schema;
import org.apache.kyuubi.util.RowSetUtils$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;

public final class RowSetHelper$ {
    public static RowSetHelper$ MODULE$;

    static {
        new RowSetHelper$();
    }

    public TRowSet toTRowSet(Seq<Row> rows, Schema schema, TProtocolVersion protocolVersion) {
        if (protocolVersion.getValue() < TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6.getValue()) {
            return this.toRowBasedSet(rows, schema);
        }
        return this.toColumnBasedSet(rows, schema);
    }

    public TRowSet toRowBasedSet(Seq<Row> rows, Schema schema) {
        int rowSize = rows.length();
        ArrayList<TRow> tRows = new ArrayList<TRow>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            Row row = (Row)rows.apply(i);
            TRow tRow = new TRow();
            int columnSize = row.length();
            for (int j = 0; j < columnSize; ++j) {
                TColumnValue columnValue = this.toTColumnValue(j, row, schema);
                tRow.addToColVals(columnValue);
            }
            tRows.add(tRow);
        }
        return new TRowSet(0L, tRows);
    }

    private TColumnValue toTColumnValue(int ordinal, Row row, Schema types) {
        TStringValue tStrValue;
        block16: {
            TTypeId tTypeId = types.apply(ordinal).dataType();
            if (TTypeId.BOOLEAN_TYPE.equals(tTypeId)) {
                TBoolValue boolValue = new TBoolValue();
                if (!row.isNullAt(ordinal)) {
                    boolValue.setValue(row.getBoolean(ordinal));
                }
                return TColumnValue.boolVal((TBoolValue)boolValue);
            }
            if (TTypeId.BINARY_TYPE.equals(tTypeId)) {
                TByteValue byteValue = new TByteValue();
                if (!row.isNullAt(ordinal)) {
                    byteValue.setValue(row.getByte(ordinal));
                }
                return TColumnValue.byteVal((TByteValue)byteValue);
            }
            if (TTypeId.TINYINT_TYPE.equals(tTypeId)) {
                TI16Value tI16Value = new TI16Value();
                if (!row.isNullAt(ordinal)) {
                    tI16Value.setValue(row.getShort(ordinal));
                }
                return TColumnValue.i16Val((TI16Value)tI16Value);
            }
            if (TTypeId.INT_TYPE.equals(tTypeId)) {
                TI32Value tI32Value = new TI32Value();
                if (!row.isNullAt(ordinal)) {
                    tI32Value.setValue(row.getInt(ordinal));
                }
                return TColumnValue.i32Val((TI32Value)tI32Value);
            }
            if (TTypeId.BIGINT_TYPE.equals(tTypeId)) {
                TI64Value tI64Value = new TI64Value();
                if (!row.isNullAt(ordinal)) {
                    tI64Value.setValue(row.getLong(ordinal));
                }
                return TColumnValue.i64Val((TI64Value)tI64Value);
            }
            if (TTypeId.FLOAT_TYPE.equals(tTypeId)) {
                TDoubleValue tDoubleValue = new TDoubleValue();
                if (!row.isNullAt(ordinal)) {
                    Double doubleValue = Double.valueOf(Float.toString(row.getFloat(ordinal)));
                    tDoubleValue.setValue(Predef$.MODULE$.Double2double(doubleValue));
                }
                return TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
            }
            if (TTypeId.DOUBLE_TYPE.equals(tTypeId)) {
                TDoubleValue tDoubleValue = new TDoubleValue();
                if (!row.isNullAt(ordinal)) {
                    tDoubleValue.setValue(row.getDouble(ordinal));
                }
                return TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
            }
            if (TTypeId.STRING_TYPE.equals(tTypeId)) {
                TStringValue tStringValue = new TStringValue();
                if (!row.isNullAt(ordinal)) {
                    tStringValue.setValue(row.getString(ordinal));
                }
                return TColumnValue.stringVal((TStringValue)tStringValue);
            }
            tStrValue = new TStringValue();
            if (row.isNullAt(ordinal)) break block16;
            tStrValue.setValue(new Tuple2(row.get(ordinal), (Object)types.apply(ordinal).dataType()).toString());
        }
        return TColumnValue.stringVal((TStringValue)tStrValue);
    }

    public TRowSet toColumnBasedSet(Seq<Row> rows, Schema schema) {
        int rowSize = rows.length();
        TRowSet tRowSet = new TRowSet(0L, new ArrayList(rowSize));
        int columnSize = schema.length();
        for (int i = 0; i < columnSize; ++i) {
            Column field = schema.apply(i);
            TColumn tColumn = this.toTColumn(rows, i, field.dataType());
            tRowSet.addToColumns(tColumn);
        }
        return tRowSet;
    }

    private TColumn toTColumn(Seq<Row> rows, int ordinal, TTypeId typ) {
        BitSet nulls = new BitSet();
        TTypeId tTypeId = typ;
        if (TTypeId.BOOLEAN_TYPE.equals(tTypeId)) {
            List<Boolean> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.boolean2Boolean(true));
            return TColumn.boolVal((TBoolColumn)new TBoolColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (TTypeId.BINARY_TYPE.equals(tTypeId)) {
            List<Byte> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.byte2Byte((byte)0));
            return TColumn.byteVal((TByteColumn)new TByteColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (TTypeId.TINYINT_TYPE.equals(tTypeId)) {
            List<Short> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.short2Short((short)0));
            return TColumn.i16Val((TI16Column)new TI16Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (TTypeId.INT_TYPE.equals(tTypeId)) {
            List<Integer> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.int2Integer(0));
            return TColumn.i32Val((TI32Column)new TI32Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (TTypeId.BIGINT_TYPE.equals(tTypeId)) {
            List<Long> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.long2Long(0L));
            return TColumn.i64Val((TI64Column)new TI64Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (TTypeId.FLOAT_TYPE.equals(tTypeId)) {
            List values = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.float2Float(0.0f))).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Double.valueOf(n.toString()), Buffer$.MODULE$.canBuildFrom())).asJava();
            return TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (TTypeId.DOUBLE_TYPE.equals(tTypeId)) {
            List<Double> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.double2Double(0.0));
            return TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        if (TTypeId.STRING_TYPE.equals(tTypeId)) {
            List<String> values = this.getOrSetAsNull(rows, ordinal, nulls, "");
            return TColumn.stringVal((TStringColumn)new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
        }
        int rowSize = rows.length();
        ArrayList<String> values = new ArrayList<String>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            Row row = (Row)rows.apply(i);
            nulls.set(i, row.isNullAt(ordinal));
            String value = row.isNullAt(ordinal) ? "" : new Tuple2(row.get(ordinal), (Object)typ).toString();
            values.add(value);
        }
        return TColumn.stringVal((TStringColumn)new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
    }

    private <T> List<T> getOrSetAsNull(Seq<Row> rows, int ordinal, BitSet nulls, T defaultVal) {
        int size = rows.length();
        ArrayList ret = new ArrayList(size);
        for (int idx = 0; idx < size; ++idx) {
            Row row = (Row)rows.apply(idx);
            boolean isNull = row.isNullAt(ordinal);
            if (isNull) {
                nulls.set(idx, true);
                ret.add(idx, defaultVal);
                continue;
            }
            ret.add(idx, row.getAs(ordinal));
        }
        return ret;
    }

    private RowSetHelper$() {
        MODULE$ = this;
    }
}

