/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ConfigFluentImpl;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.util.KubernetesUtils$OptionConfigurableConfigBuilder$;
import org.apache.kyuubi.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KubernetesUtils$
implements Logging {
    public static KubernetesUtils$ MODULE$;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new KubernetesUtils$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public Option<KubernetesClient> buildKubernetesClient(KyuubiConf conf) {
        Option master2 = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.KUBERNETES_MASTER());
        String namespace = (String)conf.get(KyuubiConf$.MODULE$.KUBERNETES_NAMESPACE());
        Option serviceAccountToken = new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/token")).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.exists()));
        Option serviceAccountCaCrt = new Some((Object)new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt")).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.exists()));
        Option oauthTokenFile = ((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.KUBERNETES_AUTHENTICATE_OAUTH_TOKEN_FILE())).map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3)).orElse((Function0 & Serializable & scala.Serializable)() -> serviceAccountToken);
        Option oauthTokenValue = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.KUBERNETES_AUTHENTICATE_OAUTH_TOKEN());
        this.requireNandDefined(oauthTokenFile, oauthTokenValue, new StringBuilder(83).append("Cannot specify OAuth token through both a oauth token file and a ").append("oauth token value.").toString());
        Option caCertFile = ((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.KUBERNETES_AUTHENTICATE_CA_CERT_FILE())).orElse((Function0 & Serializable & scala.Serializable)() -> serviceAccountCaCrt.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getAbsolutePath()));
        Option clientKeyFile = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.KUBERNETES_AUTHENTICATE_CLIENT_KEY_FILE());
        Option clientCertFile = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.KUBERNETES_AUTHENTICATE_CLIENT_CERT_FILE());
        Option kubeContext = ((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.KUBERNETES_CONTEXT())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)KubernetesUtils$.$anonfun$buildKubernetesClient$7(x$5)));
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Auto-configuring K8S client using ").append(kubeContext.map((Function1 & Serializable & scala.Serializable)x$6 -> new StringBuilder(8).append("context ").append((String)x$6).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "current context")).append(" from users K8S config file").toString());
        Config config = KubernetesUtils$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(KubernetesUtils$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(KubernetesUtils$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(KubernetesUtils$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder(KubernetesUtils$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder((ConfigBuilder)((ConfigFluentImpl)KubernetesUtils$OptionConfigurableConfigBuilder$.MODULE$.withOption$extension(this.OptionConfigurableConfigBuilder((ConfigBuilder)new ConfigBuilder(Config.autoConfigure((String)((String)kubeContext.orNull(Predef$.MODULE$.$conforms())))).withApiVersion("v1")), master2, (Function2 & Serializable & scala.Serializable)(master, configBuilder) -> (ConfigBuilder)configBuilder.withMasterUrl(master)).withNamespace(namespace)).withTrustCerts(BoxesRunTime.unboxToBoolean((Object)conf.get(KyuubiConf$.MODULE$.KUBERNETES_TRUST_CERTIFICATES())))), oauthTokenValue, (Function2 & Serializable & scala.Serializable)(token, configBuilder) -> (ConfigBuilder)configBuilder.withOauthToken(token))), oauthTokenFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withOauthToken(Files.asCharSource((File)file, (Charset)Charsets.UTF_8).read()))), caCertFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withCaCertFile(file))), clientKeyFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withClientKeyFile(file))), clientCertFile, (Function2 & Serializable & scala.Serializable)(file, configBuilder) -> (ConfigBuilder)configBuilder.withClientCertFile(file)).build();
        Dispatcher dispatcher = new Dispatcher((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("kubernetes-dispatcher"));
        OkHttpClientFactory factoryWithCustomDispatcher = new OkHttpClientFactory(dispatcher){
            private final Dispatcher dispatcher$1;

            public void additionalConfig(OkHttpClient.Builder builder) {
                builder.dispatcher(this.dispatcher$1);
            }
            {
                this.dispatcher$1 = dispatcher$1;
            }
        };
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Kubernetes client config: ").append(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)config)).toString());
        return new Some((Object)new DefaultKubernetesClient((HttpClient)factoryWithCustomDispatcher.createHttpClient(config), config));
    }

    private ConfigBuilder OptionConfigurableConfigBuilder(ConfigBuilder configBuilder) {
        return configBuilder;
    }

    public void requireNandDefined(Option<?> opt1, Option<?> opt2, String errMessage) {
        opt1.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            Predef$.MODULE$.require(opt2.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> errMessage$1);
            return BoxedUnit.UNIT;
        });
        opt2.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            Predef$.MODULE$.require(opt1.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> errMessage$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$buildKubernetesClient$7(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    private KubernetesUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

