/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.impl;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.kyuubi.shade.com.google.common.util.concurrent.ListenableFuture;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.ClientBuilder;
import org.apache.kyuubi.shade.io.etcd.jetcd.common.exception.EtcdExceptionFactory;
import org.apache.kyuubi.shade.io.etcd.jetcd.impl.AuthCredential;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Errors;
import org.apache.kyuubi.shade.io.etcd.jetcd.support.Util;
import org.apache.kyuubi.shade.io.grpc.CallOptions;
import org.apache.kyuubi.shade.io.grpc.Channel;
import org.apache.kyuubi.shade.io.grpc.ClientCall;
import org.apache.kyuubi.shade.io.grpc.ClientInterceptor;
import org.apache.kyuubi.shade.io.grpc.ForwardingClientCall;
import org.apache.kyuubi.shade.io.grpc.ManagedChannel;
import org.apache.kyuubi.shade.io.grpc.ManagedChannelBuilder;
import org.apache.kyuubi.shade.io.grpc.Metadata;
import org.apache.kyuubi.shade.io.grpc.MethodDescriptor;
import org.apache.kyuubi.shade.io.grpc.netty.NegotiationType;
import org.apache.kyuubi.shade.io.grpc.stub.AbstractStub;
import org.apache.kyuubi.shade.io.netty.channel.ChannelOption;
import org.apache.kyuubi.shade.io.vertx.core.Vertx;
import org.apache.kyuubi.shade.io.vertx.grpc.VertxChannelBuilder;
import org.apache.kyuubi.shade.net.jodah.failsafe.Failsafe;
import org.apache.kyuubi.shade.net.jodah.failsafe.Policy;
import org.apache.kyuubi.shade.net.jodah.failsafe.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientConnectionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnectionManager.class);
    private final Object lock = new Object();
    private final ClientBuilder builder;
    private final ExecutorService executorService;
    private final AuthCredential credential;
    private volatile Vertx vertx;
    private volatile ManagedChannel managedChannel;

    ClientConnectionManager(ClientBuilder builder) {
        this(builder, null);
    }

    ClientConnectionManager(ClientBuilder builder, ManagedChannel managedChannel) {
        this.builder = builder;
        this.managedChannel = managedChannel;
        this.credential = new AuthCredential(this);
        this.executorService = builder.executorService() == null ? Executors.newCachedThreadPool(Util.createThreadFactory("jetcd-", true)) : builder.executorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ManagedChannel getChannel() {
        if (this.managedChannel == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.managedChannel == null) {
                    this.managedChannel = this.defaultChannelBuilder().build();
                }
            }
        }
        return this.managedChannel;
    }

    ByteSequence getNamespace() {
        return this.builder.namespace();
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    ClientBuilder builder() {
        return this.builder;
    }

    AuthCredential authCredential() {
        return this.credential;
    }

    <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> supplier) {
        return this.newStub(supplier, this.getChannel());
    }

    private <T extends AbstractStub<T>> T newStub(Function<ManagedChannel, T> stubCustomizer, ManagedChannel channel) {
        AbstractStub stub = (AbstractStub)stubCustomizer.apply(channel);
        if (this.builder.waitForReady()) {
            stub = stub.withWaitForReady();
        }
        if (this.builder.user() != null && this.builder.password() != null) {
            stub = stub.withCallCredentials(this.authCredential());
        }
        return (T)stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.managedChannel != null) {
                this.managedChannel.shutdownNow();
            }
            if (this.vertx != null) {
                this.vertx.close();
            }
        }
        if (this.builder.executorService() == null) {
            this.executorService.shutdownNow();
        }
    }

    <T extends AbstractStub<T>, R> CompletableFuture<R> withNewChannel(String target, Function<ManagedChannel, T> stubCustomizer, Function<T, CompletableFuture<R>> stubConsumer) {
        ManagedChannel channel = this.defaultChannelBuilder(target).build();
        T stub = this.newStub(stubCustomizer, channel);
        try {
            return stubConsumer.apply(stub).whenComplete((r, t) -> channel.shutdown());
        }
        catch (Exception e) {
            channel.shutdown();
            throw EtcdExceptionFactory.toEtcdException(e);
        }
    }

    ManagedChannelBuilder<?> defaultChannelBuilder() {
        return this.defaultChannelBuilder(this.builder.target());
    }

    ManagedChannelBuilder<?> defaultChannelBuilder(String target) {
        if (target == null) {
            throw new IllegalArgumentException("At least one endpoint should be provided");
        }
        if (this.vertx == null) {
            this.vertx = Vertx.vertx();
        }
        VertxChannelBuilder channelBuilder = VertxChannelBuilder.forTarget(this.vertx, target);
        if (this.builder.authority() != null) {
            channelBuilder.overrideAuthority(this.builder.authority());
        }
        if (this.builder.maxInboundMessageSize() != null) {
            channelBuilder.maxInboundMessageSize(this.builder.maxInboundMessageSize());
        }
        if (this.builder.sslContext() != null) {
            channelBuilder.nettyBuilder().negotiationType(NegotiationType.TLS);
            channelBuilder.nettyBuilder().sslContext(this.builder.sslContext());
        } else {
            channelBuilder.nettyBuilder().negotiationType(NegotiationType.PLAINTEXT);
        }
        if (this.builder.keepaliveTime() != null) {
            channelBuilder.keepAliveTime(this.builder.keepaliveTime().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.builder.keepaliveTimeout() != null) {
            channelBuilder.keepAliveTimeout(this.builder.keepaliveTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        if (this.builder.keepaliveWithoutCalls() != null) {
            channelBuilder.keepAliveWithoutCalls(this.builder.keepaliveWithoutCalls());
        }
        if (this.builder.connectTimeout() != null) {
            channelBuilder.nettyBuilder().withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)this.builder.connectTimeout().toMillis());
        }
        if (this.builder.loadBalancerPolicy() != null) {
            channelBuilder.defaultLoadBalancingPolicy(this.builder.loadBalancerPolicy());
        } else {
            channelBuilder.defaultLoadBalancingPolicy("pick_first");
        }
        if (this.builder.headers() != null) {
            channelBuilder.intercept(new ClientInterceptor(){

                @Override
                public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                    return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                        @Override
                        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                            ClientConnectionManager.this.builder.headers().forEach(headers::put);
                            super.start(responseListener, headers);
                        }
                    };
                }
            });
        }
        if (this.builder.interceptors() != null) {
            channelBuilder.intercept((List)this.builder.interceptors());
        }
        return channelBuilder;
    }

    public <S, T> CompletableFuture<T> execute(Callable<ListenableFuture<S>> task, Function<S, T> resultConvert, Predicate<Throwable> doRetry) {
        RetryPolicy retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf(doRetry)).onRetriesExceeded(e -> LOGGER.warn("maximum number of auto retries reached")).withBackoff(this.builder.retryDelay(), this.builder.retryMaxDelay(), this.builder.retryChronoUnit());
        if (this.builder.retryMaxDuration() != null) {
            retryPolicy = retryPolicy.withMaxDuration(this.builder.retryMaxDuration());
        }
        return Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).with(this.executorService).getAsyncExecution(execution -> {
            CompletableFuture wrappedFuture = new CompletableFuture();
            ListenableFuture future = (ListenableFuture)task.call();
            future.addListener(() -> {
                block3: {
                    try {
                        wrappedFuture.complete(future.get());
                        execution.complete(wrappedFuture);
                    }
                    catch (Exception error) {
                        if (Errors.isInvalidTokenError(error)) {
                            this.authCredential().refresh();
                        }
                        if (execution.retryOn(error)) break block3;
                        wrappedFuture.completeExceptionally(error);
                    }
                }
            }, this.executorService);
        }).thenCompose(f -> f.thenApply(resultConvert));
    }
}

